/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.XAxisRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/mikephil/charting/renderer/XAxisRendererRadarChart;", "Lcom/github/mikephil/charting/renderer/XAxisRenderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "xAxis", "Lcom/github/mikephil/charting/components/XAxis;", "chart", "Lcom/github/mikephil/charting/charts/RadarChart;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/XAxis;Lcom/github/mikephil/charting/charts/RadarChart;)V", "renderAxisLabels", "", "canvas", "Landroid/graphics/Canvas;", "renderLimitLines", "MPChartLib_release"})
public final class XAxisRendererRadarChart
extends XAxisRenderer {
    @NotNull
    private final RadarChart chart;

    public XAxisRendererRadarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull XAxis xAxis, @NotNull RadarChart chart) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"xAxis");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(viewPortHandler, xAxis, null);
        this.chart = chart;
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.getXAxis().isEnabled() || !this.getXAxis().isDrawLabelsEnabled()) {
            return;
        }
        float labelRotationAngleDegrees = this.getXAxis().getLabelRotationAngle();
        MPPointF drawLabelAnchor = MPPointF.Companion.getInstance(0.5f, 0.25f);
        this.getPaintAxisLabels().setTypeface(this.getXAxis().getTypeface());
        this.getPaintAxisLabels().setTextSize(this.getXAxis().getTextSize());
        this.getPaintAxisLabels().setColor(this.getXAxis().getTextColor());
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        MPPointF center = this.chart.getCenterOffsets();
        MPPointF pOut = MPPointF.Companion.getInstance(0.0f, 0.0f);
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        IRadarDataSet iRadarDataSet = (IRadarDataSet)((RadarData)t).getMaxEntryCountSet();
        if (iRadarDataSet != null) {
            IRadarDataSet maxEntryCountSet = iRadarDataSet;
            boolean bl = false;
            int n = maxEntryCountSet.getEntryCount();
            for (int i = 0; i < n; ++i) {
                IAxisValueFormatter iAxisValueFormatter = this.getXAxis().getValueFormatter();
                String label = iAxisValueFormatter != null ? iAxisValueFormatter.getFormattedValue(i, this.getXAxis()) : null;
                float angle = (sliceAngle * (float)i + this.chart.getRotationAngle()) % 360.0f;
                Utils.INSTANCE.getPosition(center, this.chart.getYRange() * factor + (float)this.getXAxis().mLabelWidth / 2.0f, angle, pOut);
                this.drawLabel(canvas, label, pOut.getX(), pOut.getY() - (float)this.getXAxis().mLabelHeight / 2.0f, drawLabelAnchor, labelRotationAngleDegrees);
            }
        }
        MPPointF.Companion.recycleInstance(center);
        MPPointF.Companion.recycleInstance(pOut);
        MPPointF.Companion.recycleInstance(drawLabelAnchor);
    }

    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }
}

