/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R$\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R4\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b8V@TX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/github/mikephil/charting/data/PieData;", "Lcom/github/mikephil/charting/data/ChartData;", "Lcom/github/mikephil/charting/interfaces/datasets/IPieDataSet;", "<init>", "()V", "dataSet", "(Lcom/github/mikephil/charting/interfaces/datasets/IPieDataSet;)V", "getDataSet", "()Lcom/github/mikephil/charting/interfaces/datasets/IPieDataSet;", "setDataSet", "value", "", "dataSets", "getDataSets", "()Ljava/util/List;", "setDataSets", "(Ljava/util/List;)V", "getDataSetByIndex", "index", "", "getDataSetByLabel", "label", "", "ignoreCase", "", "getEntryForHighlight", "Lcom/github/mikephil/charting/data/Entry;", "highlight", "Lcom/github/mikephil/charting/highlight/Highlight;", "yValueSum", "", "getYValueSum", "()F", "MPChartLib_release"})
public final class PieData
extends ChartData<IPieDataSet> {
    public PieData() {
    }

    public PieData(@NotNull IPieDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        IPieDataSet[] iPieDataSetArray = new IPieDataSet[]{dataSet};
        super((IDataSet[])iPieDataSetArray);
    }

    @NotNull
    public final IPieDataSet getDataSet() {
        List<IPieDataSet> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        return list.get(0);
    }

    public final void setDataSet(@NotNull IPieDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        List<IPieDataSet> list = this.getDataSets();
        if (list != null) {
            list.clear();
        }
        List<IPieDataSet> list2 = this.getDataSets();
        if (list2 != null) {
            list2.add(dataSet);
        }
        this.notifyDataChanged();
    }

    @Override
    @Nullable
    public List<IPieDataSet> getDataSets() {
        block1: {
            List list = super.getDataSets();
            if (list == null) break block1;
            List it = list;
            boolean bl = false;
            if (it.isEmpty()) {
                Timber.Forest.e("Found multiple data sets while pie chart only allows one", new Object[0]);
            }
        }
        return super.getDataSets();
    }

    @Override
    protected void setDataSets(@Nullable List<IPieDataSet> value) {
        super.setDataSets(value);
    }

    @Override
    @Nullable
    public IPieDataSet getDataSetByIndex(int index) {
        return index == 0 ? this.getDataSet() : null;
    }

    @Override
    @Nullable
    public IPieDataSet getDataSetByLabel(@NotNull String label, boolean ignoreCase) {
        IPieDataSet iPieDataSet;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (ignoreCase) {
            List<IPieDataSet> list = this.getDataSets();
            Intrinsics.checkNotNull(list);
            if (StringsKt.equals((String)label, (String)list.get(0).getLabel(), (boolean)true)) {
                List<IPieDataSet> list2 = this.getDataSets();
                Intrinsics.checkNotNull(list2);
                iPieDataSet = list2.get(0);
            } else {
                iPieDataSet = null;
            }
        } else {
            List<IPieDataSet> list = this.getDataSets();
            Intrinsics.checkNotNull(list);
            if (Intrinsics.areEqual((Object)label, (Object)list.get(0).getLabel())) {
                List<IPieDataSet> list3 = this.getDataSets();
                Intrinsics.checkNotNull(list3);
                iPieDataSet = list3.get(0);
            } else {
                iPieDataSet = null;
            }
        }
        return iPieDataSet;
    }

    @Override
    @Nullable
    public Entry getEntryForHighlight(@NotNull Highlight highlight) {
        Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
        return this.getDataSet().getEntryForIndex((int)highlight.getX());
    }

    public final float getYValueSum() {
        float sum = 0.0f;
        int n = this.getDataSet().getEntryCount();
        for (int i = 0; i < n; ++i) {
            Object t = this.getDataSet().getEntryForIndex(i);
            Intrinsics.checkNotNull(t);
            sum += ((PieEntry)t).getY();
        }
        return sum;
    }
}

