/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.formatter.ValueFormatter;
import java.text.DecimalFormat;

public class PercentFormatter
extends ValueFormatter {
    public DecimalFormat mFormat = new DecimalFormat("###,###,##0.0");
    private PieChart pieChart;
    private boolean percentSignSeparated = true;

    public PercentFormatter() {
    }

    public PercentFormatter(PieChart pieChart) {
        this();
        this.pieChart = pieChart;
    }

    public PercentFormatter(PieChart pieChart, boolean percentSignSeparated) {
        this(pieChart);
        this.percentSignSeparated = percentSignSeparated;
    }

    @Override
    public String getFormattedValue(float value) {
        return this.mFormat.format(value) + (this.percentSignSeparated ? " %" : "%");
    }

    @Override
    public String getPieLabel(float value, PieEntry pieEntry) {
        if (this.pieChart != null && this.pieChart.isUsePercentValuesEnabled()) {
            return this.getFormattedValue(value);
        }
        return this.mFormat.format(value);
    }
}

