/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Color;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import java.util.ArrayList;
import java.util.List;

public class BarDataSet
extends BarLineScatterCandleBubbleDataSet<BarEntry>
implements IBarDataSet {
    private int mStackSize = 1;
    private int mBarShadowColor = Color.rgb((int)215, (int)215, (int)215);
    private float mBarBorderWidth = 0.0f;
    private int mBarBorderColor = -16777216;
    private int mHighLightAlpha = 120;
    private int mEntryCountStacks = 0;
    private String[] mStackLabels = new String[0];

    public BarDataSet(List<BarEntry> yVals, String label) {
        super(yVals, label);
        this.mHighLightColor = Color.rgb((int)0, (int)0, (int)0);
        this.calcStackSize(yVals);
        this.calcEntryCountIncludingStacks(yVals);
    }

    @Override
    public DataSet<BarEntry> copy() {
        ArrayList<BarEntry> entries = new ArrayList<BarEntry>();
        for (int i = 0; i < this.mEntries.size(); ++i) {
            entries.add(((BarEntry)this.mEntries.get(i)).copy());
        }
        BarDataSet copied = new BarDataSet((List<BarEntry>)entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected void copy(BarDataSet barDataSet) {
        super.copy(barDataSet);
        barDataSet.mStackSize = this.mStackSize;
        barDataSet.mBarShadowColor = this.mBarShadowColor;
        barDataSet.mBarBorderWidth = this.mBarBorderWidth;
        barDataSet.mStackLabels = this.mStackLabels;
        barDataSet.mHighLightAlpha = this.mHighLightAlpha;
    }

    private void calcEntryCountIncludingStacks(List<BarEntry> yVals) {
        this.mEntryCountStacks = 0;
        for (int i = 0; i < yVals.size(); ++i) {
            float[] vals = yVals.get(i).getYVals();
            if (vals == null) {
                ++this.mEntryCountStacks;
                continue;
            }
            this.mEntryCountStacks += vals.length;
        }
    }

    private void calcStackSize(List<BarEntry> yVals) {
        for (int i = 0; i < yVals.size(); ++i) {
            float[] vals = yVals.get(i).getYVals();
            if (vals == null || vals.length <= this.mStackSize) continue;
            this.mStackSize = vals.length;
        }
    }

    @Override
    protected void calcMinMax(BarEntry e) {
        if (e != null && !Float.isNaN(e.getY())) {
            if (e.getYVals() == null) {
                if (e.getY() < this.mYMin) {
                    this.mYMin = e.getY();
                }
                if (e.getY() > this.mYMax) {
                    this.mYMax = e.getY();
                }
            } else {
                if (-e.getNegativeSum() < this.mYMin) {
                    this.mYMin = -e.getNegativeSum();
                }
                if (e.getPositiveSum() > this.mYMax) {
                    this.mYMax = e.getPositiveSum();
                }
            }
            this.calcMinMaxX(e);
        }
    }

    @Override
    public int getStackSize() {
        return this.mStackSize;
    }

    @Override
    public boolean isStacked() {
        return this.mStackSize > 1;
    }

    public int getEntryCountStacks() {
        return this.mEntryCountStacks;
    }

    public void setBarShadowColor(int color) {
        this.mBarShadowColor = color;
    }

    @Override
    public int getBarShadowColor() {
        return this.mBarShadowColor;
    }

    public void setBarBorderWidth(float width) {
        this.mBarBorderWidth = width;
    }

    @Override
    public float getBarBorderWidth() {
        return this.mBarBorderWidth;
    }

    public void setBarBorderColor(int color) {
        this.mBarBorderColor = color;
    }

    @Override
    public int getBarBorderColor() {
        return this.mBarBorderColor;
    }

    public void setHighLightAlpha(int alpha) {
        this.mHighLightAlpha = alpha;
    }

    @Override
    public int getHighLightAlpha() {
        return this.mHighLightAlpha;
    }

    public void setStackLabels(String[] labels) {
        this.mStackLabels = labels;
    }

    @Override
    public String[] getStackLabels() {
        return this.mStackLabels;
    }
}

