/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.data.RadarEntry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J \u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0004J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0004J#\u0010/\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0016\u00a2\u0006\u0002\u00103J>\u00107\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020;R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u00104\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010$\"\u0004\b6\u0010&\u00a8\u0006@"}, d2={"Lcom/github/mikephil/charting/renderer/RadarChartRenderer;", "Lcom/github/mikephil/charting/renderer/LineRadarRenderer;", "chart", "Lcom/github/mikephil/charting/charts/RadarChart;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/charts/RadarChart;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "getChart", "()Lcom/github/mikephil/charting/charts/RadarChart;", "setChart", "(Lcom/github/mikephil/charting/charts/RadarChart;)V", "value", "Landroid/graphics/Paint;", "webPaint", "getWebPaint", "()Landroid/graphics/Paint;", "setWebPaint", "(Landroid/graphics/Paint;)V", "highlightCirclePaint", "getHighlightCirclePaint", "setHighlightCirclePaint", "paint", "previousPath", "Landroid/graphics/Path;", "innerArea", "temp", "initBuffers", "", "drawData", "c", "Landroid/graphics/Canvas;", "drawDataSetSurfacePathBuffer", "getDrawDataSetSurfacePathBuffer", "()Landroid/graphics/Path;", "setDrawDataSetSurfacePathBuffer", "(Landroid/graphics/Path;)V", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IRadarDataSet;", "mostEntries", "", "drawValues", "drawExtras", "drawWeb", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "mDrawHighlightCirclePathBuffer", "getMDrawHighlightCirclePathBuffer", "setMDrawHighlightCirclePathBuffer", "drawHighlightCircle", "point", "Lcom/github/mikephil/charting/utils/MPPointF;", "innerRadius", "", "outerRadius", "fillColor", "strokeColor", "strokeWidth", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nRadarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadarChartRenderer.kt\ncom/github/mikephil/charting/renderer/RadarChartRenderer\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,404:1\n27#2,7:405\n*S KotlinDebug\n*F\n+ 1 RadarChartRenderer.kt\ncom/github/mikephil/charting/renderer/RadarChartRenderer\n*L\n378#1:405,7\n*E\n"})
public class RadarChartRenderer
extends LineRadarRenderer {
    @NotNull
    private RadarChart chart;
    @NotNull
    private Paint webPaint;
    @NotNull
    private Paint highlightCirclePaint;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Path previousPath;
    @NotNull
    private final Path innerArea;
    @NotNull
    private final Path temp;
    @NotNull
    private Path drawDataSetSurfacePathBuffer;
    @NotNull
    private Path mDrawHighlightCirclePathBuffer;

    public RadarChartRenderer(@NotNull RadarChart chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.paint = new Paint(1);
        this.previousPath = new Path();
        this.innerArea = new Path();
        this.temp = new Path();
        this.drawDataSetSurfacePathBuffer = new Path();
        this.mDrawHighlightCirclePathBuffer = new Path();
        this.setPaintHighlight(new Paint(1));
        this.getPaintHighlight().setStyle(Paint.Style.STROKE);
        this.getPaintHighlight().setStrokeWidth(2.0f);
        this.getPaintHighlight().setColor(Color.rgb((int)255, (int)187, (int)115));
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStrokeWidth(2.0f);
        this.paint.setColor(-65536);
        this.webPaint = new Paint(1);
        this.webPaint.setStyle(Paint.Style.STROKE);
        this.highlightCirclePaint = new Paint(1);
    }

    @NotNull
    protected final RadarChart getChart() {
        return this.chart;
    }

    protected final void setChart(@NotNull RadarChart radarChart) {
        Intrinsics.checkNotNullParameter((Object)radarChart, (String)"<set-?>");
        this.chart = radarChart;
    }

    @NotNull
    public final Paint getWebPaint() {
        return this.webPaint;
    }

    protected final void setWebPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.webPaint = paint;
    }

    @NotNull
    protected final Paint getHighlightCirclePaint() {
        return this.highlightCirclePaint;
    }

    protected final void setHighlightCirclePaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.highlightCirclePaint = paint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas c) {
        RadarData radarData;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        RadarData radarData2 = radarData = (RadarData)this.chart.getData();
        Intrinsics.checkNotNull((Object)radarData2);
        int mostEntries = ((IRadarDataSet)radarData2.getMaxEntryCountSet()).getEntryCount();
        for (IRadarDataSet set : radarData.getDataSets()) {
            if (!set.isVisible()) continue;
            Intrinsics.checkNotNull((Object)set);
            this.drawDataSet(c, set, mostEntries);
        }
    }

    @NotNull
    protected final Path getDrawDataSetSurfacePathBuffer() {
        return this.drawDataSetSurfacePathBuffer;
    }

    protected final void setDrawDataSetSurfacePathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.drawDataSetSurfacePathBuffer = path;
    }

    protected final void drawDataSet(@NotNull Canvas c, @NotNull IRadarDataSet dataSet, int mostEntries) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        float phaseX = this.animator.getPhaseX();
        float phaseY = this.animator.getPhaseY();
        float sliceangle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        MPPointF center = this.chart.getCenterOffsets();
        MPPointF pOut = MPPointF.getInstance(0.0f, 0.0f);
        Path surface = this.drawDataSetSurfacePathBuffer;
        surface.reset();
        boolean hasMovedToPoint = false;
        int n = dataSet.getEntryCount();
        for (int j = 0; j < n; ++j) {
            this.getPaintRender().setColor(dataSet.getColor(j));
            RadarEntry e = (RadarEntry)dataSet.getEntryForIndex(j);
            Utils.getPosition(center, (e.getY() - this.chart.getYChartMin()) * factor * phaseY, sliceangle * (float)j * phaseX + this.chart.getRotationAngle(), pOut);
            if (Float.isNaN(pOut.x)) continue;
            if (!hasMovedToPoint) {
                surface.moveTo(pOut.x, pOut.y);
                hasMovedToPoint = true;
                continue;
            }
            surface.lineTo(pOut.x, pOut.y);
        }
        if (dataSet.getEntryCount() > mostEntries) {
            surface.lineTo(center.x, center.y);
        }
        surface.close();
        if (dataSet.isDrawFilledEnabled()) {
            Drawable drawable = dataSet.getFillDrawable();
            if (drawable != null) {
                this.drawFilledPath(c, surface, drawable);
            } else {
                this.drawFilledPath(c, surface, dataSet.getFillColor(), dataSet.getFillAlpha());
            }
        }
        this.getPaintRender().setStrokeWidth(dataSet.getLineWidth());
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        if (!dataSet.isDrawFilledEnabled() || dataSet.getFillAlpha() < 255) {
            c.drawPath(surface, this.getPaintRender());
        }
        MPPointF.recycleInstance(center);
        MPPointF.recycleInstance(pOut);
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        float phaseX = this.animator.getPhaseX();
        float phaseY = this.animator.getPhaseY();
        float sliceangle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        MPPointF center = this.chart.getCenterOffsets();
        MPPointF pOut = MPPointF.getInstance(0.0f, 0.0f);
        MPPointF pIcon = MPPointF.getInstance(0.0f, 0.0f);
        float yoffset = Utils.convertDpToPixel(5.0f);
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        int n = ((RadarData)t).getDataSetCount();
        for (int i = 0; i < n; ++i) {
            Object t2 = this.chart.getData();
            Intrinsics.checkNotNull(t2);
            IRadarDataSet dataSet = (IRadarDataSet)((RadarData)t2).getDataSetByIndex(i);
            if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
            Intrinsics.checkNotNull((Object)dataSet);
            this.applyValueTextStyle(dataSet);
            MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
            iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
            iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
            int n2 = dataSet.getEntryCount();
            for (int j = 0; j < n2; ++j) {
                RadarEntry entry = (RadarEntry)dataSet.getEntryForIndex(j);
                Utils.getPosition(center, (entry.getY() - this.chart.getYChartMin()) * factor * phaseY, sliceangle * (float)j * phaseX + this.chart.getRotationAngle(), pOut);
                if (dataSet.isDrawValuesEnabled()) {
                    IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                    Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                    this.drawValue(c, iValueFormatter, entry.getY(), entry, i, pOut.x, pOut.y - yoffset, dataSet.getValueTextColor(j));
                }
                if (entry.getIcon() == null || !dataSet.isDrawIconsEnabled()) continue;
                Drawable icon = entry.getIcon();
                Utils.getPosition(center, entry.getY() * factor * phaseY + iconsOffset.y, sliceangle * (float)j * phaseX + this.chart.getRotationAngle(), pIcon);
                pIcon.y += iconsOffset.x;
                int n3 = (int)pIcon.x;
                int n4 = (int)pIcon.y;
                Drawable drawable = icon;
                Intrinsics.checkNotNull((Object)drawable);
                Utils.drawImage(c, icon, n3, n4, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
            }
            MPPointF.recycleInstance(iconsOffset);
        }
        MPPointF.recycleInstance(center);
        MPPointF.recycleInstance(pOut);
        MPPointF.recycleInstance(pIcon);
    }

    @Override
    public void drawExtras(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.drawWeb(c);
    }

    protected final void drawWeb(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        float sliceangle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        float rotationangle = this.chart.getRotationAngle();
        MPPointF center = this.chart.getCenterOffsets();
        this.webPaint.setStrokeWidth(this.chart.getWebLineWidth());
        this.webPaint.setColor(this.chart.getWebColor());
        this.webPaint.setAlpha(this.chart.getWebAlpha());
        int xIncrements = 1 + this.chart.getSkipWebLineCount();
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        int maxEntryCount = ((IRadarDataSet)((RadarData)t).getMaxEntryCountSet()).getEntryCount();
        MPPointF p = MPPointF.getInstance(0.0f, 0.0f);
        for (int i = 0; i < maxEntryCount; i += xIncrements) {
            Utils.getPosition(center, this.chart.getYRange() * factor, sliceangle * (float)i + rotationangle, p);
            c.drawLine(center.x, center.y, p.x, p.y, this.webPaint);
        }
        MPPointF.recycleInstance(p);
        this.webPaint.setStrokeWidth(this.chart.getWebLineWidthInner());
        this.webPaint.setColor(this.chart.getWebColorInner());
        this.webPaint.setAlpha(this.chart.getWebAlpha());
        int labelCount = this.chart.getYAxis().mEntryCount;
        MPPointF p1out = MPPointF.getInstance(0.0f, 0.0f);
        MPPointF p2out = MPPointF.getInstance(0.0f, 0.0f);
        for (int j = 0; j < labelCount; ++j) {
            boolean result;
            if (this.chart.isCustomLayerColorEnable()) {
                this.innerArea.rewind();
                Integer n = this.chart.getLayerColorList().get(j);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
                this.paint.setColor(((Number)n).intValue());
            }
            Object t2 = this.chart.getData();
            Intrinsics.checkNotNull(t2);
            int n = ((RadarData)t2).getEntryCount();
            for (int i = 0; i < n; ++i) {
                float r = (this.chart.getYAxis().mEntries[j] - this.chart.getYChartMin()) * factor;
                Utils.getPosition(center, r, sliceangle * (float)i + rotationangle, p1out);
                Utils.getPosition(center, r, sliceangle * (float)(i + 1) + rotationangle, p2out);
                c.drawLine(p1out.x, p1out.y, p2out.x, p2out.y, this.webPaint);
                if (!this.chart.isCustomLayerColorEnable() || p1out.x == p2out.x) continue;
                if (i == 0) {
                    this.innerArea.moveTo(p1out.x, p1out.y);
                } else {
                    this.innerArea.lineTo(p1out.x, p1out.y);
                }
                this.innerArea.lineTo(p2out.x, p2out.y);
            }
            if (!this.chart.isCustomLayerColorEnable()) continue;
            this.temp.set(this.innerArea);
            if (!this.innerArea.isEmpty() && (result = this.innerArea.op(this.previousPath, Path.Op.DIFFERENCE))) {
                c.drawPath(this.innerArea, this.paint);
            }
            this.previousPath.set(this.temp);
        }
        MPPointF.recycleInstance(p1out);
        MPPointF.recycleInstance(p2out);
    }

    @Override
    public void drawHighlighted(@NotNull Canvas c, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        float sliceangle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        MPPointF center = this.chart.getCenterOffsets();
        MPPointF pOut = MPPointF.getInstance(0.0f, 0.0f);
        RadarData radarData = (RadarData)this.chart.getData();
        for (Highlight high : indices) {
            RadarEntry e;
            RadarData radarData2 = radarData;
            Intrinsics.checkNotNull((Object)radarData2);
            IRadarDataSet set = (IRadarDataSet)radarData2.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX(e = (RadarEntry)set.getEntryForIndex((int)high.getX()), set)) continue;
            float y = e.getY() - this.chart.getYChartMin();
            Utils.getPosition(center, y * factor * this.animator.getPhaseY(), sliceangle * high.getX() * this.animator.getPhaseX() + this.chart.getRotationAngle(), pOut);
            high.setDraw(pOut.x, pOut.y);
            this.drawHighlightLines(c, pOut.x, pOut.y, set);
            if (!set.isDrawHighlightCircleEnabled() || Float.isNaN(pOut.x) || Float.isNaN(pOut.y)) continue;
            int strokeColor = set.getHighlightCircleStrokeColor();
            if (strokeColor == 0x112233) {
                strokeColor = set.getColor(0);
            }
            if (set.getHighlightCircleStrokeAlpha() < 255) {
                strokeColor = ColorTemplate.colorWithAlpha(strokeColor, set.getHighlightCircleStrokeAlpha());
            }
            Intrinsics.checkNotNull((Object)pOut);
            this.drawHighlightCircle(c, pOut, set.getHighlightCircleInnerRadius(), set.getHighlightCircleOuterRadius(), set.getHighlightCircleFillColor(), strokeColor, set.getHighlightCircleStrokeWidth());
        }
        MPPointF.recycleInstance(center);
        MPPointF.recycleInstance(pOut);
    }

    @NotNull
    protected final Path getMDrawHighlightCirclePathBuffer() {
        return this.mDrawHighlightCirclePathBuffer;
    }

    protected final void setMDrawHighlightCirclePathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.mDrawHighlightCirclePathBuffer = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawHighlightCircle(@NotNull Canvas c, @NotNull MPPointF point, float innerRadius, float outerRadius, int fillColor, int strokeColor, float strokeWidth) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        float innerRadiusLocal = 0.0f;
        innerRadiusLocal = innerRadius;
        float outerRadiusLocal = 0.0f;
        outerRadiusLocal = outerRadius;
        Canvas $this$withSave$iv = c;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawHighlightCircle_u24lambda_u240 = $this$withSave$iv;
            boolean bl = false;
            outerRadiusLocal = Utils.convertDpToPixel(outerRadiusLocal);
            innerRadiusLocal = Utils.convertDpToPixel(innerRadiusLocal);
            if (fillColor != 0x112233) {
                Path p = this.mDrawHighlightCirclePathBuffer;
                p.reset();
                p.addCircle(point.x, point.y, outerRadiusLocal, Path.Direction.CW);
                if (innerRadiusLocal > 0.0f) {
                    p.addCircle(point.x, point.y, innerRadiusLocal, Path.Direction.CCW);
                }
                this.highlightCirclePaint.setColor(fillColor);
                this.highlightCirclePaint.setStyle(Paint.Style.FILL);
                $this$drawHighlightCircle_u24lambda_u240.drawPath(p, this.highlightCirclePaint);
            }
            if (strokeColor != 0x112233) {
                this.highlightCirclePaint.setColor(strokeColor);
                this.highlightCirclePaint.setStyle(Paint.Style.STROKE);
                this.highlightCirclePaint.setStrokeWidth(Utils.convertDpToPixel(strokeWidth));
                $this$drawHighlightCircle_u24lambda_u240.drawCircle(point.x, point.y, outerRadiusLocal, this.highlightCirclePaint);
            }
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }
}

