/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.buffer.HorizontalBarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.ChartInterface;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Fill;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0014H\u0004J0\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020)H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/github/mikephil/charting/renderer/HorizontalBarChartRenderer;", "Lcom/github/mikephil/charting/renderer/BarChartRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "initBuffers", "", "mBarShadowRectBuffer", "Landroid/graphics/RectF;", "drawDataSet", "c", "Landroid/graphics/Canvas;", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "index", "", "drawValues", "drawValue", "valueText", "", "x", "", "y", "color", "prepareBarHighlight", "y1", "y2", "barWidthHalf", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "setHighlightDrawPos", "high", "Lcom/github/mikephil/charting/highlight/Highlight;", "bar", "isDrawingValuesAllowed", "", "Lcom/github/mikephil/charting/interfaces/dataprovider/ChartInterface;", "MPChartLib_release"})
public class HorizontalBarChartRenderer
extends BarChartRenderer {
    @NotNull
    private final RectF mBarShadowRectBuffer;

    public HorizontalBarChartRenderer(@NotNull BarDataProvider chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(chart, animator, viewPortHandler);
        this.mBarShadowRectBuffer = new RectF();
        this.getPaintValues().setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.chart.getBarData();
        this.barBuffers = ArraysKt.toMutableList((Object[])new HorizontalBarBuffer[barData.getDataSetCount()]);
        int n = ((Collection)this.barBuffers).size();
        for (int i = 0; i < n; ++i) {
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(i);
            this.barBuffers.set(i, new HorizontalBarBuffer(set.getEntryCount() * 4 * (set.isStacked() ? set.getStackSize() : 1), barData.getDataSetCount(), set.isStacked()));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void drawDataSet(@NotNull Canvas c, @NotNull IBarDataSet dataSet, int index) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        trans = this.chart.getTransformer(dataSet.getAxisDependency());
        this.barBorderPaint.setColor(dataSet.getBarBorderColor());
        this.barBorderPaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getBarBorderWidth()));
        drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        phaseX = this.animator.getPhaseX();
        phaseY = this.animator.getPhaseY();
        if (this.chart.isDrawBarShadowEnabled()) {
            this.shadowPaint.setColor(dataSet.getBarShadowColor());
            barData = this.chart.getBarData();
            barWidth = barData.getBarWidth();
            barWidthHalf = barWidth / 2.0f;
            x = 0.0f;
            i = 0;
            count = (int)Math.min((double)((int)Math.ceil((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
            while (i < count) {
                e = (BarEntry)dataSet.getEntryForIndex(i);
                x = e.getX();
                this.mBarShadowRectBuffer.top = x - barWidthHalf;
                this.mBarShadowRectBuffer.bottom = x + barWidthHalf;
                v0 = trans;
                Intrinsics.checkNotNull((Object)v0);
                v0.rectValueToPixel(this.mBarShadowRectBuffer);
                if (!this.viewPortHandler.isInBoundsTop(this.mBarShadowRectBuffer.bottom)) {
                    ++i;
                    continue;
                }
                if (!this.viewPortHandler.isInBoundsBottom(this.mBarShadowRectBuffer.top)) break;
                this.mBarShadowRectBuffer.left = this.viewPortHandler.contentLeft();
                this.mBarShadowRectBuffer.right = this.viewPortHandler.contentRight();
                c.drawRect(this.mBarShadowRectBuffer, this.shadowPaint);
                ++i;
            }
        }
        v1 = this.barBuffers.get(index);
        Intrinsics.checkNotNull(v1);
        buffer = (BarBuffer)v1;
        buffer.setPhases(phaseX, phaseY);
        buffer.setDataSet(index);
        buffer.setInverted(this.chart.isInverted(dataSet.getAxisDependency()));
        buffer.setBarWidth(this.chart.getBarData().getBarWidth());
        buffer.feed(dataSet);
        v2 = trans;
        Intrinsics.checkNotNull((Object)v2);
        v2.pointValuesToPixel(buffer.buffer);
        if (dataSet.getFills() == null) ** GOTO lbl-1000
        v3 = dataSet.getFills();
        Intrinsics.checkNotNullExpressionValue(v3, (String)"getFills(...)");
        if (((Collection)v3).isEmpty() == false) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        isCustomFill = v4;
        isSingleColor = dataSet.getColors().size() == 1;
        isInverted = this.chart.isInverted(dataSet.getAxisDependency());
        if (isSingleColor) {
            this.getPaintRender().setColor(dataSet.getColor());
        }
        j = 0;
        pos = 0;
        while (j < buffer.size() && this.viewPortHandler.isInBoundsTop(buffer.buffer[j + 3])) {
            if (!this.viewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                j += 4;
                ++pos;
                continue;
            }
            if (!isSingleColor) {
                this.getPaintRender().setColor(dataSet.getColor(j / 4));
            }
            if (isCustomFill) {
                dataSet.getFill(pos).fillRect(c, this.getPaintRender(), buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], isInverted != false ? Fill.Direction.LEFT : Fill.Direction.RIGHT, 0.0f);
            } else {
                c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
            }
            if (drawBorder) {
                c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.barBorderPaint);
            }
            j += 4;
            ++pos;
        }
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (this.isDrawingValuesAllowed(this.chart)) {
            List dataSets = this.chart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(5.0f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.chart.isDrawValueAboveBarEnabled();
            int n = this.chart.getBarData().getDataSetCount();
            for (int i = 0; i < n; ++i) {
                IBarDataSet dataSet = (IBarDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
                boolean isInverted = this.chart.isInverted(dataSet.getAxisDependency());
                Intrinsics.checkNotNull((Object)dataSet);
                this.applyValueTextStyle(dataSet);
                float halfTextHeight = (float)Utils.calcTextHeight(this.getPaintValues(), "10") / 2.0f;
                IValueFormatter formatter = dataSet.getValueFormatter();
                Object e = this.barBuffers.get(i);
                Intrinsics.checkNotNull(e);
                BarBuffer buffer = (BarBuffer)e;
                float phaseY = this.animator.getPhaseY();
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                if (!dataSet.isStacked()) {
                    int j = 0;
                    while ((float)j < (float)buffer.buffer.length * this.animator.getPhaseX()) {
                        float y = (buffer.buffer[j + 1] + buffer.buffer[j + 3]) / 2.0f;
                        if (this.viewPortHandler.isInBoundsTop(buffer.buffer[j + 1])) {
                            if (!this.viewPortHandler.isInBoundsX(buffer.buffer[j])) {
                                j += 4;
                                continue;
                            }
                            if (!this.viewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                                j += 4;
                                continue;
                            }
                            BarEntry entry = (BarEntry)dataSet.getEntryForIndex(j / 4);
                            float val = entry.getY();
                            String formattedValue = formatter.getFormattedValue(val, entry, i, this.viewPortHandler);
                            float valueTextWidth = Utils.calcTextWidth(this.getPaintValues(), formattedValue);
                            posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                            negOffset = (drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus) - (buffer.buffer[j + 2] - buffer.buffer[j]);
                            if (isInverted) {
                                posOffset = -posOffset - valueTextWidth;
                                negOffset = -negOffset - valueTextWidth;
                            }
                            if (dataSet.isDrawValuesEnabled()) {
                                String string = formattedValue;
                                Intrinsics.checkNotNull((Object)string);
                                this.drawValue(c, string, buffer.buffer[j + 2] + (val >= 0.0f ? posOffset : negOffset), y + halfTextHeight, dataSet.getValueTextColor(j / 2));
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                Drawable icon = entry.getIcon();
                                float px = buffer.buffer[j + 2] + (val >= 0.0f ? posOffset : negOffset);
                                float py = y;
                                int n2 = (int)(px += iconsOffset.x);
                                int n3 = (int)(py += iconsOffset.y);
                                Drawable drawable = icon;
                                Intrinsics.checkNotNull((Object)drawable);
                                Utils.drawImage(c, icon, n2, n3, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                            }
                            j += 4;
                            continue;
                        }
                        break;
                    }
                } else {
                    Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
                    int bufferIndex = 0;
                    int index = 0;
                    while ((float)index < (float)dataSet.getEntryCount() * this.animator.getPhaseX()) {
                        BarEntry entry = (BarEntry)dataSet.getEntryForIndex(index);
                        int color = dataSet.getValueTextColor(index);
                        float[] vals = entry.getYVals();
                        if (vals == null) {
                            if (!this.viewPortHandler.isInBoundsTop(buffer.buffer[bufferIndex + 1])) break;
                            if (!this.viewPortHandler.isInBoundsX(buffer.buffer[bufferIndex]) || !this.viewPortHandler.isInBoundsBottom(buffer.buffer[bufferIndex + 1])) continue;
                            float val = entry.getY();
                            String formattedValue = formatter.getFormattedValue(val, entry, i, this.viewPortHandler);
                            float valueTextWidth = Utils.calcTextWidth(this.getPaintValues(), formattedValue);
                            posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                            float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                            if (isInverted) {
                                posOffset = -posOffset - valueTextWidth;
                                negOffset = -negOffset - valueTextWidth;
                            }
                            if (dataSet.isDrawValuesEnabled()) {
                                String string = formattedValue;
                                Intrinsics.checkNotNull((Object)string);
                                this.drawValue(c, string, buffer.buffer[bufferIndex + 2] + (entry.getY() >= 0.0f ? posOffset : negOffset), buffer.buffer[bufferIndex + 1] + halfTextHeight, color);
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                Drawable icon = entry.getIcon();
                                float px = buffer.buffer[bufferIndex + 2] + (entry.getY() >= 0.0f ? posOffset : negOffset);
                                float py = buffer.buffer[bufferIndex + 1];
                                int n4 = (int)(px += iconsOffset.x);
                                int n5 = (int)(py += iconsOffset.y);
                                Drawable drawable = icon;
                                Intrinsics.checkNotNull((Object)drawable);
                                Utils.drawImage(c, icon, n4, n5, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                            }
                        } else {
                            float y;
                            float[] transformed = new float[vals.length * 2];
                            float posY = 0.0f;
                            float negY = 0.0f;
                            negY = -entry.getNegativeSum();
                            HorizontalBarChartRenderer $this$drawValues_u24lambda_u240 = this;
                            boolean bl = false;
                            int k = 0;
                            int idx = 0;
                            while (k < transformed.length) {
                                float value = vals[idx];
                                y = 0.0f;
                                if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                                    y = value;
                                } else if (value >= 0.0f) {
                                    y = posY += value;
                                } else {
                                    y = negY;
                                    negY -= value;
                                }
                                transformed[k] = y * phaseY;
                                k += 2;
                                ++idx;
                            }
                            Transformer transformer = trans;
                            Intrinsics.checkNotNull((Object)transformer);
                            transformer.pointValuesToPixel(transformed);
                            int k2 = 0;
                            while (k2 < transformed.length) {
                                float val = vals[k2 / 2];
                                String formattedValue = formatter.getFormattedValue(val, entry, i, this.viewPortHandler);
                                float valueTextWidth = Utils.calcTextWidth(this.getPaintValues(), formattedValue);
                                posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                if (isInverted) {
                                    posOffset = -posOffset - valueTextWidth;
                                    negOffset = -negOffset - valueTextWidth;
                                }
                                boolean drawBelow = val == 0.0f && negY == 0.0f && posY > 0.0f || val < 0.0f;
                                float x = transformed[k2] + (drawBelow ? negOffset : posOffset);
                                y = (buffer.buffer[bufferIndex + 1] + buffer.buffer[bufferIndex + 3]) / 2.0f;
                                if (!this.viewPortHandler.isInBoundsTop(y)) break;
                                if (!this.viewPortHandler.isInBoundsX(x)) {
                                    k2 += 2;
                                    continue;
                                }
                                if (!this.viewPortHandler.isInBoundsBottom(y)) {
                                    k2 += 2;
                                    continue;
                                }
                                if (dataSet.isDrawValuesEnabled()) {
                                    String string = formattedValue;
                                    Intrinsics.checkNotNull((Object)string);
                                    this.drawValue(c, string, x, y + halfTextHeight, color);
                                }
                                if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                    Drawable icon = entry.getIcon();
                                    int n6 = (int)(x + iconsOffset.x);
                                    int n7 = (int)(y + iconsOffset.y);
                                    Drawable drawable = icon;
                                    Intrinsics.checkNotNull((Object)drawable);
                                    Utils.drawImage(c, icon, n6, n7, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                                }
                                k2 += 2;
                            }
                        }
                        bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                        ++index;
                    }
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    protected final void drawValue(@NotNull Canvas c, @NotNull String valueText, float x, float y, int color) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)valueText, (String)"valueText");
        this.getPaintValues().setColor(color);
        c.drawText(valueText, x, y, this.getPaintValues());
    }

    @Override
    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, @NotNull Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        float top = x - barWidthHalf;
        float bottom = x + barWidthHalf;
        float left = y1;
        float right = y2;
        this.barRect.set(left, top, right, bottom);
        trans.rectToPixelPhaseHorizontal(this.barRect, this.animator.getPhaseY());
    }

    @Override
    protected void setHighlightDrawPos(@NotNull Highlight high, @NotNull RectF bar) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        high.setDraw(bar.centerY(), bar.right);
    }

    @Override
    protected boolean isDrawingValuesAllowed(@NotNull ChartInterface chart) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        ChartData chartData = chart.getData();
        Intrinsics.checkNotNull((Object)chartData);
        return (float)chartData.getEntryCount() < (float)chart.getMaxVisibleCount() * this.viewPortHandler.getScaleY();
    }
}

