/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

public class LineChartRenderer
extends LineRadarRenderer {
    protected LineDataProvider mChart;
    protected Paint mCirclePaintInner;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    protected Path cubicPath = new Path();
    protected Path cubicFillPath = new Path();
    private float[] mLineBuffer = new float[4];
    protected Path mGenerateFilledPathBuffer = new Path();
    private final HashMap<IDataSet, DataSetImageCache> mImageCaches = new HashMap();
    private final float[] mCirclesBuffer = new float[2];

    public LineChartRenderer(LineDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        Bitmap drawBitmap;
        int width = (int)this.mViewPortHandler.getChartWidth();
        int height = (int)this.mViewPortHandler.getChartHeight();
        Bitmap bitmap = drawBitmap = this.mDrawBitmap == null ? null : (Bitmap)this.mDrawBitmap.get();
        if (drawBitmap == null || drawBitmap.getWidth() != width || drawBitmap.getHeight() != height) {
            if (width > 0 && height > 0) {
                drawBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig);
                this.mDrawBitmap = new WeakReference<Bitmap>(drawBitmap);
                this.mBitmapCanvas = new Canvas(drawBitmap);
            } else {
                return;
            }
        }
        drawBitmap.eraseColor(0);
        LineData lineData = this.mChart.getLineData();
        for (ILineDataSet set : lineData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
        c.drawBitmap(drawBitmap, 0.0f, 0.0f, this.mRenderPaint);
    }

    protected void drawDataSet(Canvas c, ILineDataSet dataSet) {
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
        this.mRenderPaint.setPathEffect((PathEffect)dataSet.getDashPathEffect());
        switch (dataSet.getMode()) {
            default: {
                this.drawLinear(c, dataSet);
                break;
            }
            case CUBIC_BEZIER: {
                this.drawCubicBezier(dataSet);
                break;
            }
            case HORIZONTAL_BEZIER: {
                this.drawHorizontalBezier(dataSet);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawHorizontalBezier(ILineDataSet dataSet) {
        float phaseY = this.mAnimator.getPhaseY();
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mXBounds.set(this.mChart, dataSet);
        this.cubicPath.reset();
        if (this.mXBounds.range >= 1) {
            Object prev;
            Object cur = prev = dataSet.getEntryForIndex(this.mXBounds.min);
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            for (int j = this.mXBounds.min + 1; j <= this.mXBounds.range + this.mXBounds.min; ++j) {
                prev = cur;
                cur = dataSet.getEntryForIndex(j);
                float cpx = ((Entry)prev).getX() + (((Entry)cur).getX() - ((Entry)prev).getX()) / 2.0f;
                this.cubicPath.cubicTo(cpx, ((BaseEntry)prev).getY() * phaseY, cpx, ((BaseEntry)cur).getY() * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, dataSet, this.cubicFillPath, trans, this.mXBounds);
        }
        this.mRenderPaint.setColor(dataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        trans.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicBezier(ILineDataSet dataSet) {
        float phaseY = this.mAnimator.getPhaseY();
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mXBounds.set(this.mChart, dataSet);
        float intensity = dataSet.getCubicIntensity();
        this.cubicPath.reset();
        if (this.mXBounds.range >= 1) {
            Object cur;
            float prevDx = 0.0f;
            float prevDy = 0.0f;
            float curDx = 0.0f;
            float curDy = 0.0f;
            int firstIndex = this.mXBounds.min + 1;
            int lastIndex = this.mXBounds.min + this.mXBounds.range;
            Object prev = dataSet.getEntryForIndex(Math.max(firstIndex - 2, 0));
            Object next = cur = dataSet.getEntryForIndex(Math.max(firstIndex - 1, 0));
            int nextIndex = -1;
            if (cur == null) {
                return;
            }
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            for (int j = this.mXBounds.min + 1; j <= this.mXBounds.range + this.mXBounds.min; ++j) {
                Object prevPrev = prev;
                prev = cur;
                cur = nextIndex == j ? next : dataSet.getEntryForIndex(j);
                nextIndex = j + 1 < dataSet.getEntryCount() ? j + 1 : j;
                next = dataSet.getEntryForIndex(nextIndex);
                prevDx = (((Entry)cur).getX() - ((Entry)prevPrev).getX()) * intensity;
                prevDy = (((BaseEntry)cur).getY() - ((BaseEntry)prevPrev).getY()) * intensity;
                curDx = (((Entry)next).getX() - ((Entry)prev).getX()) * intensity;
                curDy = (((BaseEntry)next).getY() - ((BaseEntry)prev).getY()) * intensity;
                this.cubicPath.cubicTo(((Entry)prev).getX() + prevDx, (((BaseEntry)prev).getY() + prevDy) * phaseY, ((Entry)cur).getX() - curDx, (((BaseEntry)cur).getY() - curDy) * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, dataSet, this.cubicFillPath, trans, this.mXBounds);
        }
        this.mRenderPaint.setColor(dataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        trans.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicFill(Canvas c, ILineDataSet dataSet, Path spline, Transformer trans, BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.mChart);
        spline.lineTo(((Entry)dataSet.getEntryForIndex(bounds.min + bounds.range)).getX(), fillMin);
        spline.lineTo(((Entry)dataSet.getEntryForIndex(bounds.min)).getX(), fillMin);
        spline.close();
        trans.pathValueToPixel(spline);
        Drawable drawable = dataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(c, spline, drawable);
        } else {
            this.drawFilledPath(c, spline, dataSet.getFillColor(), dataSet.getFillAlpha());
        }
    }

    protected void drawLinear(Canvas c, ILineDataSet dataSet) {
        int entryCount = dataSet.getEntryCount();
        boolean isDrawSteppedEnabled = dataSet.isDrawSteppedEnabled();
        int pointsPerEntryPair = isDrawSteppedEnabled ? 4 : 2;
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.mAnimator.getPhaseY();
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        Canvas canvas = null;
        canvas = dataSet.isDashedLineEnabled() ? this.mBitmapCanvas : c;
        this.mXBounds.set(this.mChart, dataSet);
        if (dataSet.isDrawFilledEnabled() && entryCount > 0) {
            this.drawLinearFill(c, dataSet, trans, this.mXBounds);
        }
        if (dataSet.getColors().size() > 1) {
            int numberOfFloats = pointsPerEntryPair * 2;
            if (this.mLineBuffer.length <= numberOfFloats) {
                this.mLineBuffer = new float[numberOfFloats * 2];
            }
            int max = this.mXBounds.min + this.mXBounds.range;
            for (int j = this.mXBounds.min; j < max; ++j) {
                Object e = dataSet.getEntryForIndex(j);
                if (e == null) continue;
                this.mLineBuffer[0] = ((Entry)e).getX();
                this.mLineBuffer[1] = ((BaseEntry)e).getY() * phaseY;
                if (j < this.mXBounds.max) {
                    e = dataSet.getEntryForIndex(j + 1);
                    if (e == null) break;
                    if (isDrawSteppedEnabled) {
                        this.mLineBuffer[2] = ((Entry)e).getX();
                        this.mLineBuffer[3] = this.mLineBuffer[1];
                        this.mLineBuffer[4] = this.mLineBuffer[2];
                        this.mLineBuffer[5] = this.mLineBuffer[3];
                        this.mLineBuffer[6] = ((Entry)e).getX();
                        this.mLineBuffer[7] = ((BaseEntry)e).getY() * phaseY;
                    } else {
                        this.mLineBuffer[2] = ((Entry)e).getX();
                        this.mLineBuffer[3] = ((BaseEntry)e).getY() * phaseY;
                    }
                } else {
                    this.mLineBuffer[2] = this.mLineBuffer[0];
                    this.mLineBuffer[3] = this.mLineBuffer[1];
                }
                float firstCoordinateX = this.mLineBuffer[0];
                float firstCoordinateY = this.mLineBuffer[1];
                float lastCoordinateX = this.mLineBuffer[numberOfFloats - 2];
                float lastCoordinateY = this.mLineBuffer[numberOfFloats - 1];
                if (firstCoordinateX == lastCoordinateX && firstCoordinateY == lastCoordinateY) continue;
                trans.pointValuesToPixel(this.mLineBuffer);
                if (this.mViewPortHandler.isInBoundsRight(firstCoordinateX)) {
                    if (!this.mViewPortHandler.isInBoundsLeft(lastCoordinateX) || !this.mViewPortHandler.isInBoundsTop(Math.max(firstCoordinateY, lastCoordinateY)) || !this.mViewPortHandler.isInBoundsBottom(Math.min(firstCoordinateY, lastCoordinateY))) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    canvas.drawLines(this.mLineBuffer, 0, pointsPerEntryPair * 2, this.mRenderPaint);
                    continue;
                }
                break;
            }
        } else {
            Object e1;
            if (this.mLineBuffer.length < Math.max(entryCount * pointsPerEntryPair, pointsPerEntryPair) * 2) {
                this.mLineBuffer = new float[Math.max(entryCount * pointsPerEntryPair, pointsPerEntryPair) * 4];
            }
            if ((e1 = dataSet.getEntryForIndex(this.mXBounds.min)) != null) {
                int j = 0;
                for (int x = this.mXBounds.min; x <= this.mXBounds.range + this.mXBounds.min; ++x) {
                    e1 = dataSet.getEntryForIndex(x == 0 ? 0 : x - 1);
                    Object e2 = dataSet.getEntryForIndex(x);
                    if (e1 == null || e2 == null) continue;
                    this.mLineBuffer[j++] = ((Entry)e1).getX();
                    this.mLineBuffer[j++] = ((BaseEntry)e1).getY() * phaseY;
                    if (isDrawSteppedEnabled) {
                        this.mLineBuffer[j++] = ((Entry)e2).getX();
                        this.mLineBuffer[j++] = ((BaseEntry)e1).getY() * phaseY;
                        this.mLineBuffer[j++] = ((Entry)e2).getX();
                        this.mLineBuffer[j++] = ((BaseEntry)e1).getY() * phaseY;
                    }
                    this.mLineBuffer[j++] = ((Entry)e2).getX();
                    this.mLineBuffer[j++] = ((BaseEntry)e2).getY() * phaseY;
                }
                if (j > 0) {
                    trans.pointValuesToPixel(this.mLineBuffer);
                    int size = Math.max((this.mXBounds.range + 1) * pointsPerEntryPair, pointsPerEntryPair) * 2;
                    this.mRenderPaint.setColor(dataSet.getColor());
                    canvas.drawLines(this.mLineBuffer, 0, size, this.mRenderPaint);
                }
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawLinearFill(Canvas c, ILineDataSet dataSet, Transformer trans, BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        Path filled = this.mGenerateFilledPathBuffer;
        int startingIndex = bounds.min;
        int endingIndex = bounds.range + bounds.min;
        int indexInterval = 128;
        int currentStartIndex = 0;
        int currentEndIndex = 128;
        int iterations = 0;
        do {
            currentStartIndex = startingIndex + iterations * 128;
            currentEndIndex = currentStartIndex + 128;
            if (currentStartIndex <= (currentEndIndex = Math.min(currentEndIndex, endingIndex))) {
                Drawable drawable = dataSet.getFillDrawable();
                int startIndex = currentStartIndex;
                int endIndex = currentEndIndex;
                if (drawable != null) {
                    startIndex = Math.max(0, currentStartIndex - 1);
                    endIndex = Math.min(endingIndex, currentEndIndex + 1);
                }
                this.generateFilledPath(dataSet, startIndex, endIndex, filled);
                trans.pathValueToPixel(filled);
                if (drawable != null) {
                    this.drawFilledPath(c, filled, drawable);
                } else {
                    this.drawFilledPath(c, filled, dataSet.getFillColor(), dataSet.getFillAlpha());
                }
            }
            ++iterations;
        } while (currentStartIndex <= currentEndIndex);
    }

    private void generateFilledPath(ILineDataSet dataSet, int startIndex, int endIndex, Path outputPath) {
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.mChart);
        float phaseY = this.mAnimator.getPhaseY();
        boolean isDrawSteppedEnabled = dataSet.getMode() == LineDataSet.Mode.STEPPED;
        Path filled = outputPath;
        filled.reset();
        Object entry = dataSet.getEntryForIndex(startIndex);
        filled.moveTo(((Entry)entry).getX(), fillMin);
        filled.lineTo(((Entry)entry).getX(), ((BaseEntry)entry).getY() * phaseY);
        Entry currentEntry = null;
        Object previousEntry = entry;
        for (int x = startIndex + 1; x <= endIndex; ++x) {
            currentEntry = (Entry)dataSet.getEntryForIndex(x);
            if (currentEntry == null) continue;
            if (isDrawSteppedEnabled) {
                filled.lineTo(currentEntry.getX(), ((BaseEntry)previousEntry).getY() * phaseY);
            }
            filled.lineTo(currentEntry.getX(), currentEntry.getY() * phaseY);
            previousEntry = currentEntry;
        }
        if (currentEntry != null) {
            filled.lineTo(currentEntry.getX(), fillMin);
        }
        filled.close();
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getLineData().getDataSets();
            for (int i = 0; i < dataSets.size(); ++i) {
                ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                int valOffset = (int)(dataSet.getCircleRadius() * 1.75f);
                if (!dataSet.isDrawCirclesEnabled()) {
                    valOffset /= 2;
                }
                this.mXBounds.set(this.mChart, dataSet);
                float[] positions = trans.generateTransformedValuesLine(dataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), this.mXBounds.min, this.mXBounds.max);
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                for (int j = 0; j < positions.length; j += 2) {
                    Object entry;
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) break;
                    if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y) || (entry = dataSet.getEntryForIndex(j / 2 + this.mXBounds.min)) == null) continue;
                    if (dataSet.isDrawValuesEnabled()) {
                        this.drawValue(c, dataSet.getValueFormatter(), ((BaseEntry)entry).getY(), (Entry)entry, i, x, y - (float)valOffset, dataSet.getValueTextColor(j / 2));
                    }
                    if (((BaseEntry)entry).getIcon() == null || !dataSet.isDrawIconsEnabled()) continue;
                    Drawable icon = ((BaseEntry)entry).getIcon();
                    Utils.drawImage(c, icon, (int)(x + iconsOffset.x), (int)(y + iconsOffset.y), icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawCircles(c);
    }

    protected void drawCircles(Canvas c) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        float phaseY = this.mAnimator.getPhaseY();
        this.mCirclesBuffer[0] = 0.0f;
        this.mCirclesBuffer[1] = 0.0f;
        List dataSets = this.mChart.getLineData().getDataSets();
        block0: for (int i = 0; i < dataSets.size(); ++i) {
            Object e;
            DataSetImageCache imageCache;
            boolean drawTransparentCircleHole;
            ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
            if (!dataSet.isVisible() || !dataSet.isDrawCirclesEnabled() || dataSet.getEntryCount() == 0) continue;
            this.mCirclePaintInner.setColor(dataSet.getCircleHoleColor());
            Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
            this.mXBounds.set(this.mChart, dataSet);
            float circleRadius = dataSet.getCircleRadius();
            float circleHoleRadius = dataSet.getCircleHoleRadius();
            boolean drawCircleHole = dataSet.isDrawCircleHoleEnabled() && circleHoleRadius < circleRadius && circleHoleRadius > 0.0f;
            boolean bl = drawTransparentCircleHole = drawCircleHole && dataSet.getCircleHoleColor() == 0x112233;
            if (this.mImageCaches.containsKey(dataSet)) {
                imageCache = this.mImageCaches.get(dataSet);
            } else {
                imageCache = new DataSetImageCache();
                this.mImageCaches.put(dataSet, imageCache);
            }
            boolean changeRequired = imageCache.init(dataSet);
            if (changeRequired) {
                imageCache.fill(dataSet, drawCircleHole, drawTransparentCircleHole);
            }
            int boundsRangeCount = this.mXBounds.range + this.mXBounds.min;
            for (int j = this.mXBounds.min; j <= boundsRangeCount && (e = dataSet.getEntryForIndex(j)) != null; ++j) {
                Bitmap circleBitmap;
                this.mCirclesBuffer[0] = ((Entry)e).getX();
                this.mCirclesBuffer[1] = ((BaseEntry)e).getY() * phaseY;
                trans.pointValuesToPixel(this.mCirclesBuffer);
                if (!this.mViewPortHandler.isInBoundsRight(this.mCirclesBuffer[0])) continue block0;
                if (!this.mViewPortHandler.isInBoundsLeft(this.mCirclesBuffer[0]) || !this.mViewPortHandler.isInBoundsY(this.mCirclesBuffer[1]) || (circleBitmap = imageCache.getBitmap(j)) == null) continue;
                c.drawBitmap(circleBitmap, this.mCirclesBuffer[0] - circleRadius, this.mCirclesBuffer[1] - circleRadius, null);
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        LineData lineData = this.mChart.getLineData();
        for (Highlight high : indices) {
            Object e;
            ILineDataSet set = (ILineDataSet)lineData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX((Entry)(e = set.getEntryForXValue(high.getX(), high.getY())), set)) continue;
            MPPointD pix = this.mChart.getTransformer(set.getAxisDependency()).getPixelForValues(((Entry)e).getX(), ((BaseEntry)e).getY() * this.mAnimator.getPhaseY());
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }

    public void setBitmapConfig(Bitmap.Config config) {
        this.mBitmapConfig = config;
        this.releaseBitmap();
    }

    public Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    public void releaseBitmap() {
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            Bitmap drawBitmap = (Bitmap)this.mDrawBitmap.get();
            if (drawBitmap != null) {
                drawBitmap.recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }

    private class DataSetImageCache {
        private final Path mCirclePathBuffer = new Path();
        private Bitmap[] circleBitmaps;

        private DataSetImageCache() {
        }

        protected boolean init(ILineDataSet set) {
            int size = set.getCircleColorCount();
            boolean changeRequired = false;
            if (this.circleBitmaps == null) {
                this.circleBitmaps = new Bitmap[size];
                changeRequired = true;
            } else if (this.circleBitmaps.length != size) {
                this.circleBitmaps = new Bitmap[size];
                changeRequired = true;
            }
            return changeRequired;
        }

        protected void fill(ILineDataSet set, boolean drawCircleHole, boolean drawTransparentCircleHole) {
            int colorCount = set.getCircleColorCount();
            float circleRadius = set.getCircleRadius();
            float circleHoleRadius = set.getCircleHoleRadius();
            for (int i = 0; i < colorCount; ++i) {
                Bitmap.Config conf = Bitmap.Config.ARGB_4444;
                Bitmap circleBitmap = Bitmap.createBitmap((int)((int)((double)circleRadius * 2.1)), (int)((int)((double)circleRadius * 2.1)), (Bitmap.Config)conf);
                Canvas canvas = new Canvas(circleBitmap);
                this.circleBitmaps[i] = circleBitmap;
                LineChartRenderer.this.mRenderPaint.setColor(set.getCircleColor(i));
                if (drawTransparentCircleHole) {
                    this.mCirclePathBuffer.reset();
                    this.mCirclePathBuffer.addCircle(circleRadius, circleRadius, circleRadius, Path.Direction.CW);
                    this.mCirclePathBuffer.addCircle(circleRadius, circleRadius, circleHoleRadius, Path.Direction.CCW);
                    canvas.drawPath(this.mCirclePathBuffer, LineChartRenderer.this.mRenderPaint);
                    continue;
                }
                canvas.drawCircle(circleRadius, circleRadius, circleRadius, LineChartRenderer.this.mRenderPaint);
                if (!drawCircleHole) continue;
                canvas.drawCircle(circleRadius, circleRadius, circleHoleRadius, LineChartRenderer.this.mCirclePaintInner);
            }
        }

        protected Bitmap getBitmap(int index) {
            return this.circleBitmaps[index % this.circleBitmaps.length];
        }
    }
}

