/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BaseDataSet;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSet<T extends Entry>
extends BaseDataSet<T> {
    protected List<T> mEntries;
    protected float mYMax = -3.4028235E38f;
    protected float mYMin = Float.MAX_VALUE;
    protected float mXMax = -3.4028235E38f;
    protected float mXMin = Float.MAX_VALUE;

    public DataSet(List<T> entries, String label) {
        super(label);
        this.mEntries = entries;
        if (this.mEntries == null) {
            this.mEntries = new ArrayList<T>();
        }
        this.calcMinMax();
    }

    @Override
    public void calcMinMax() {
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        if (this.mEntries == null || this.mEntries.isEmpty()) {
            return;
        }
        for (Entry e : this.mEntries) {
            this.calcMinMax(e);
        }
    }

    @Override
    public void calcMinMaxY(float fromX, float toX) {
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        if (this.mEntries == null || this.mEntries.isEmpty()) {
            return;
        }
        int indexFrom = this.getEntryIndex(fromX, Float.NaN, Rounding.DOWN);
        int indexTo = this.getEntryIndex(toX, Float.NaN, Rounding.UP);
        if (indexTo < indexFrom) {
            return;
        }
        for (int i = indexFrom; i <= indexTo; ++i) {
            this.calcMinMaxY((Entry)this.mEntries.get(i));
        }
    }

    protected void calcMinMax(T e) {
        if (e == null) {
            return;
        }
        this.calcMinMaxX(e);
        this.calcMinMaxY(e);
    }

    protected void calcMinMaxX(T e) {
        if (((Entry)e).getX() < this.mXMin) {
            this.mXMin = ((Entry)e).getX();
        }
        if (((Entry)e).getX() > this.mXMax) {
            this.mXMax = ((Entry)e).getX();
        }
    }

    protected void calcMinMaxY(T e) {
        if (((BaseEntry)e).getY() < this.mYMin) {
            this.mYMin = ((BaseEntry)e).getY();
        }
        if (((BaseEntry)e).getY() > this.mYMax) {
            this.mYMax = ((BaseEntry)e).getY();
        }
    }

    @Override
    public int getEntryCount() {
        return this.mEntries.size();
    }

    @Deprecated
    public List<T> getValues() {
        return this.mEntries;
    }

    public List<T> getEntries() {
        return this.mEntries;
    }

    @Deprecated
    public void setValues(List<T> values) {
        this.setEntries(values);
    }

    public void setEntries(List<T> entries) {
        this.mEntries = entries;
        this.notifyDataSetChanged();
    }

    public abstract DataSet<T> copy();

    protected void copy(DataSet dataSet) {
        super.copy(dataSet);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toSimpleString());
        for (int i = 0; i < this.mEntries.size(); ++i) {
            buffer.append(((Entry)this.mEntries.get(i)).toString() + " ");
        }
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSet, label: " + (this.getLabel() == null ? "" : this.getLabel()) + ", entries: " + this.mEntries.size() + "\n");
        return buffer.toString();
    }

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    @Override
    public float getXMin() {
        return this.mXMin;
    }

    @Override
    public float getXMax() {
        return this.mXMax;
    }

    @Override
    public void addEntryOrdered(T e) {
        if (e == null) {
            return;
        }
        if (this.mEntries == null) {
            this.mEntries = new ArrayList<T>();
        }
        this.calcMinMax(e);
        if (this.mEntries.size() > 0 && ((Entry)this.mEntries.get(this.mEntries.size() - 1)).getX() > ((Entry)e).getX()) {
            int closestIndex = this.getEntryIndex(((Entry)e).getX(), ((BaseEntry)e).getY(), Rounding.UP);
            this.mEntries.add(closestIndex, e);
        } else {
            this.mEntries.add(e);
        }
    }

    @Override
    public void clear() {
        this.mEntries.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean addEntry(T e) {
        if (e == null) {
            return false;
        }
        List<T> values = this.getEntries();
        if (values == null) {
            values = new ArrayList<T>();
        }
        this.calcMinMax(e);
        return values.add(e);
    }

    @Override
    public boolean removeEntry(T e) {
        if (e == null) {
            return false;
        }
        if (this.mEntries == null) {
            return false;
        }
        boolean removed = this.mEntries.remove(e);
        if (removed) {
            this.calcMinMax();
        }
        return removed;
    }

    @Override
    public int getEntryIndex(Entry e) {
        return this.mEntries.indexOf(e);
    }

    @Override
    public T getEntryForXValue(float xValue, float closestToY, Rounding rounding) {
        int index = this.getEntryIndex(xValue, closestToY, rounding);
        if (index > -1) {
            return (T)((Entry)this.mEntries.get(index));
        }
        return null;
    }

    @Override
    public T getEntryForXValue(float xValue, float closestToY) {
        return this.getEntryForXValue(xValue, closestToY, Rounding.CLOSEST);
    }

    @Override
    public T getEntryForIndex(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.mEntries.size()) {
            return null;
        }
        return (T)((Entry)this.mEntries.get(index));
    }

    @Override
    public int getEntryIndex(float xValue, float closestToY, Rounding rounding) {
        int high;
        if (this.mEntries == null || this.mEntries.isEmpty()) {
            return -1;
        }
        int low = 0;
        int closest = high = this.mEntries.size() - 1;
        while (low < high) {
            int m = (low + high) / 2;
            float d1 = ((Entry)this.mEntries.get(m)).getX() - xValue;
            float d2 = ((Entry)this.mEntries.get(m + 1)).getX() - xValue;
            float ad1 = Math.abs(d1);
            float ad2 = Math.abs(d2);
            if (ad2 < ad1) {
                low = m + 1;
            } else if (ad1 < ad2) {
                high = m;
            } else if ((double)d1 >= 0.0) {
                high = m;
            } else if ((double)d1 < 0.0) {
                low = m + 1;
            }
            closest = high;
        }
        if (closest != -1) {
            float closestXValue = ((Entry)this.mEntries.get(closest)).getX();
            if (rounding == Rounding.UP) {
                if (closestXValue < xValue && closest < this.mEntries.size() - 1) {
                    ++closest;
                }
            } else if (rounding == Rounding.DOWN && closestXValue > xValue && closest > 0) {
                --closest;
            }
            if (!Float.isNaN(closestToY)) {
                Entry value;
                while (closest > 0 && ((Entry)this.mEntries.get(closest - 1)).getX() == closestXValue) {
                    --closest;
                }
                float closestYValue = ((Entry)this.mEntries.get(closest)).getY();
                int closestYIndex = closest;
                while (++closest < this.mEntries.size() && (value = (Entry)this.mEntries.get(closest)).getX() == closestXValue) {
                    if (!(Math.abs(value.getY() - closestToY) <= Math.abs(closestYValue - closestToY))) continue;
                    closestYValue = closestToY;
                    closestYIndex = closest;
                }
                closest = closestYIndex;
            }
        }
        return closest;
    }

    @Override
    public List<T> getEntriesForXValue(float xValue) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int low = 0;
        int high = this.mEntries.size() - 1;
        while (low <= high) {
            int m = (high + low) / 2;
            Entry entry = (Entry)this.mEntries.get(m);
            if (xValue == entry.getX()) {
                while (m > 0 && ((Entry)this.mEntries.get(m - 1)).getX() == xValue) {
                    --m;
                }
                high = this.mEntries.size();
                while (m < high && (entry = (Entry)this.mEntries.get(m)).getX() == xValue) {
                    entries.add(entry);
                    ++m;
                }
                break;
            }
            if (xValue > entry.getX()) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return entries;
    }

    public static enum Rounding {
        UP,
        DOWN,
        CLOSEST;

    }
}

