/*
 * Decompiled with CFR 0.152.
 */
package xyz.hanks.library.bang;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import xyz.hanks.library.bang.Utils;

public class DotsView
extends View {
    public static final Property<DotsView, Float> DOTS_PROGRESS = new Property<DotsView, Float>(Float.class, "dotsProgress"){

        public Float get(DotsView object) {
            return Float.valueOf(object.getCurrentProgress());
        }

        public void set(DotsView object, Float value) {
            object.setCurrentProgress(value.floatValue());
        }
    };
    public static final int COLOR_1 = -2145656;
    public static final int COLOR_2 = -3306504;
    public static final int COLOR_3 = -13918734;
    public static final int COLOR_4 = -5968204;
    private static final int DOTS_COUNT = 7;
    private static final int OUTER_DOTS_POSITION_ANGLE = 51;
    private final Paint[] circlePaints = new Paint[4];
    private int[] colors = new int[]{-2145656, -3306504, -13918734, -5968204};
    private int centerX;
    private int centerY;
    private float maxOuterDotsRadius;
    private float maxInnerDotsRadius;
    private float maxDotSize;
    private float currentProgress = 0.0f;
    private float currentRadius1 = 0.0f;
    private float currentDotSize1 = 0.0f;
    private float currentDotSize2 = 0.0f;
    private float currentRadius2 = 0.0f;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();

    public DotsView(Context context) {
        super(context);
        this.init();
    }

    public DotsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DotsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        for (int i = 0; i < this.circlePaints.length; ++i) {
            this.circlePaints[i] = new Paint(1);
            this.circlePaints[i].setStyle(Paint.Style.FILL);
        }
    }

    public void setColors(int[] colors) {
        if (colors.length < 4) {
            throw new RuntimeException("the count of dot colors must not be less 4");
        }
        this.colors = colors;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.centerX = w / 2;
        this.centerY = h / 2;
        this.maxDotSize = Utils.dp2px(this.getContext(), 1.1f);
        this.maxOuterDotsRadius = (float)(w / 2) - this.maxDotSize * 2.0f;
        this.maxInnerDotsRadius = 0.8f * this.maxOuterDotsRadius;
    }

    protected void onDraw(Canvas canvas) {
        if (this.currentProgress == 0.0f) {
            canvas.drawColor(0);
            return;
        }
        this.drawOuterDotsFrame(canvas);
        this.drawInnerDotsFrame(canvas);
    }

    private void drawOuterDotsFrame(Canvas canvas) {
        for (int i = 0; i < 7; ++i) {
            int cX = (int)((double)this.centerX + (double)this.currentRadius1 * Math.cos((double)(i * 51) * Math.PI / 180.0));
            int cY = (int)((double)this.centerY + (double)this.currentRadius1 * Math.sin((double)(i * 51) * Math.PI / 180.0));
            canvas.drawCircle((float)cX, (float)cY, this.currentDotSize1, this.circlePaints[i % this.circlePaints.length]);
        }
    }

    private void drawInnerDotsFrame(Canvas canvas) {
        for (int i = 0; i < 7; ++i) {
            int cX = (int)((double)this.centerX + (double)this.currentRadius2 * Math.cos((double)(i * 51 - 10) * Math.PI / 180.0));
            int cY = (int)((double)this.centerY + (double)this.currentRadius2 * Math.sin((double)(i * 51 - 10) * Math.PI / 180.0));
            canvas.drawCircle((float)cX, (float)cY, this.currentDotSize2, this.circlePaints[(i + 1) % this.circlePaints.length]);
        }
    }

    public float getCurrentProgress() {
        return this.currentProgress;
    }

    public void setCurrentProgress(float currentProgress) {
        this.currentProgress = currentProgress;
        this.updateInnerDotsPosition();
        this.updateOuterDotsPosition();
        this.updateDotsPaints();
        this.updateDotsAlpha();
        this.postInvalidate();
    }

    private void updateInnerDotsPosition() {
        this.currentRadius2 = this.currentProgress < 0.3f ? (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.3f, 0.0, this.maxInnerDotsRadius) : this.maxInnerDotsRadius;
        this.currentDotSize2 = (double)this.currentProgress < 0.2 ? this.maxDotSize : ((double)this.currentProgress < 0.5 ? (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.2f, 0.5, this.maxDotSize, 0.5 * (double)this.maxDotSize) : (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.5, 1.0, this.maxDotSize * 0.5f, 0.0));
    }

    private void updateOuterDotsPosition() {
        this.currentRadius1 = this.currentProgress < 0.3f ? (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.3f, 0.0, this.maxOuterDotsRadius * 0.8f) : (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.3f, 1.0, 0.8f * this.maxOuterDotsRadius, this.maxOuterDotsRadius);
        this.currentDotSize1 = (double)this.currentProgress < 0.7 ? this.maxDotSize : (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.7f, 1.0, this.maxDotSize, 0.0);
    }

    private void updateDotsPaints() {
        if (this.currentProgress < 0.5f) {
            float progress = (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.0, 0.5, 0.0, 1.0);
            this.circlePaints[0].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[0], (Object)this.colors[1])).intValue());
            this.circlePaints[1].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[1], (Object)this.colors[2])).intValue());
            this.circlePaints[2].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[2], (Object)this.colors[3])).intValue());
            this.circlePaints[3].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[3], (Object)this.colors[0])).intValue());
        } else {
            float progress = (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.5, 1.0, 0.0, 1.0);
            this.circlePaints[0].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[1], (Object)this.colors[2])).intValue());
            this.circlePaints[1].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[2], (Object)this.colors[3])).intValue());
            this.circlePaints[2].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[3], (Object)this.colors[0])).intValue());
            this.circlePaints[3].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.colors[0], (Object)this.colors[1])).intValue());
        }
    }

    private void updateDotsAlpha() {
        float progress = (float)Utils.clamp(this.currentProgress, 0.6f, 1.0);
        int alpha = (int)Utils.mapValueFromRangeToRange(progress, 0.6f, 1.0, 255.0, 0.0);
        this.circlePaints[0].setAlpha(alpha);
        this.circlePaints[1].setAlpha(alpha);
        this.circlePaints[2].setAlpha(alpha);
        this.circlePaints[3].setAlpha(alpha);
    }
}

