/*
 * Decompiled with CFR 0.152.
 */
package xyz.hanks.library.bang;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;

public class CircleView
extends View {
    public static final Property<CircleView, Float> OUTER_CIRCLE_RADIUS_PROGRESS = new Property<CircleView, Float>(Float.class, "progress"){

        public Float get(CircleView object) {
            return Float.valueOf(object.getProgress());
        }

        public void set(CircleView object, Float value) {
            object.setProgress(value.floatValue());
        }
    };
    public static int START_COLOR = -2145656;
    public static int END_COLOR = -3306504;
    private int startColor = START_COLOR;
    private int endColor = START_COLOR;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private Paint circlePaint = new Paint(1);
    private Paint ringPaint = new Paint(1);
    private float progress = 0.0f;

    public CircleView(Context context) {
        super(context);
        this.init();
    }

    public CircleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CircleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setColor(START_COLOR);
        this.ringPaint.setStyle(Paint.Style.STROKE);
        this.ringPaint.setColor(START_COLOR);
    }

    protected void onDraw(Canvas canvas) {
        if (this.progress == 0.0f) {
            canvas.drawColor(0);
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int radius = Math.min(width, height) / 2;
        if ((double)this.progress <= 0.5) {
            canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)(radius * 2) * this.progress, this.circlePaint);
            return;
        }
        float strokeWidth = 2.0f * (float)radius * (1.0f - this.progress);
        if (strokeWidth <= 0.0f) {
            canvas.drawColor(0);
            return;
        }
        this.ringPaint.setStrokeWidth(strokeWidth);
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius - strokeWidth / 2.0f, this.ringPaint);
    }

    private void updateCircleColor() {
        if ((double)this.progress <= 0.5) {
            Integer color = (Integer)this.argbEvaluator.evaluate(this.progress * 2.0f, (Object)this.startColor, (Object)this.endColor);
            this.circlePaint.setColor(color.intValue());
        } else {
            this.ringPaint.setColor(this.endColor);
        }
    }

    public void setStartColor(int startColor) {
        this.startColor = startColor;
    }

    public void setEndColor(int endColor) {
        this.endColor = endColor;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.updateCircleColor();
        this.postInvalidate();
    }
}

