/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator.buildins.commonnavigator.indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import java.util.List;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.model.PositionData;

public class TestPagerIndicator
extends View
implements IPagerIndicator {
    private Paint mPaint;
    private int mOutRectColor;
    private int mInnerRectColor;
    private RectF mOutRect = new RectF();
    private RectF mInnerRect = new RectF();
    private List<PositionData> mPositionDataList;

    public TestPagerIndicator(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mOutRectColor = -65536;
        this.mInnerRectColor = -16711936;
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setColor(this.mOutRectColor);
        canvas.drawRect(this.mOutRect, this.mPaint);
        this.mPaint.setColor(this.mInnerRectColor);
        canvas.drawRect(this.mInnerRect, this.mPaint);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mPositionDataList == null || this.mPositionDataList.isEmpty()) {
            return;
        }
        int currentPosition = Math.min(this.mPositionDataList.size() - 1, position);
        int nextPosition = Math.min(this.mPositionDataList.size() - 1, position + 1);
        PositionData current = this.mPositionDataList.get(currentPosition);
        PositionData next = this.mPositionDataList.get(nextPosition);
        this.mOutRect.left = (float)current.mLeft + (float)(next.mLeft - current.mLeft) * positionOffset;
        this.mOutRect.top = (float)current.mTop + (float)(next.mTop - current.mTop) * positionOffset;
        this.mOutRect.right = (float)current.mRight + (float)(next.mRight - current.mRight) * positionOffset;
        this.mOutRect.bottom = (float)current.mBottom + (float)(next.mBottom - current.mBottom) * positionOffset;
        this.mInnerRect.left = (float)current.mContentLeft + (float)(next.mContentLeft - current.mContentLeft) * positionOffset;
        this.mInnerRect.top = (float)current.mContentTop + (float)(next.mContentTop - current.mContentTop) * positionOffset;
        this.mInnerRect.right = (float)current.mContentRight + (float)(next.mContentRight - current.mContentRight) * positionOffset;
        this.mInnerRect.bottom = (float)current.mContentBottom + (float)(next.mContentBottom - current.mContentBottom) * positionOffset;
        this.invalidate();
    }

    @Override
    public void onPageSelected(int position) {
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void onPositionDataProvide(List<PositionData> dataList) {
        this.mPositionDataList = dataList;
    }

    public int getOutRectColor() {
        return this.mOutRectColor;
    }

    public void setOutRectColor(int outRectColor) {
        this.mOutRectColor = outRectColor;
    }

    public int getInnerRectColor() {
        return this.mInnerRectColor;
    }

    public void setInnerRectColor(int innerRectColor) {
        this.mInnerRectColor = innerRectColor;
    }
}

