/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.convert;

import java.util.Map;
import java.util.Properties;
import org.osjava.sj.loader.convert.ConverterIF;

public class MapConverter
implements ConverterIF {
    @Override
    public Object convert(Properties properties, String type) {
        if ("java.util.Map".equals(type)) {
            type = "java.util.HashMap";
        } else if ("java.util.Properties".equals(type)) {
            return properties;
        }
        try {
            Class<?> c = Class.forName(type);
            Map map = (Map)c.newInstance();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals("type")) continue;
                map.put(key, entry.getValue());
            }
            return map;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unable to find class: " + type, cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Unable to instantiate class: " + type, ie);
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException("Unable to access class: " + type, ie);
        }
    }
}

