/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.app.Application;
import android.content.Context;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.OAIDRom;
import com.github.gzuliyujiang.oaid.impl.AsusImpl;
import com.github.gzuliyujiang.oaid.impl.CoolpadImpl;
import com.github.gzuliyujiang.oaid.impl.CooseaImpl;
import com.github.gzuliyujiang.oaid.impl.DefaultImpl;
import com.github.gzuliyujiang.oaid.impl.FreemeImpl;
import com.github.gzuliyujiang.oaid.impl.GmsImpl;
import com.github.gzuliyujiang.oaid.impl.HonorImpl;
import com.github.gzuliyujiang.oaid.impl.HuaweiImpl;
import com.github.gzuliyujiang.oaid.impl.LenovoImpl;
import com.github.gzuliyujiang.oaid.impl.MeizuImpl;
import com.github.gzuliyujiang.oaid.impl.MsaImpl;
import com.github.gzuliyujiang.oaid.impl.NubiaImpl;
import com.github.gzuliyujiang.oaid.impl.OppoExtImpl;
import com.github.gzuliyujiang.oaid.impl.OppoImpl;
import com.github.gzuliyujiang.oaid.impl.QikuImpl;
import com.github.gzuliyujiang.oaid.impl.SamsungImpl;
import com.github.gzuliyujiang.oaid.impl.VivoImpl;
import com.github.gzuliyujiang.oaid.impl.XiaomiImpl;

public final class OAIDFactory {
    private static IOAID ioaid;

    private OAIDFactory() {
    }

    public static IOAID create(Context context) {
        if (context != null && !(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        if (ioaid != null) {
            return ioaid;
        }
        ioaid = OAIDFactory.createManufacturerImpl(context);
        if (ioaid != null && ioaid.supported()) {
            OAIDLog.print("Manufacturer interface has been found: " + ioaid.getClass().getName());
            return ioaid;
        }
        ioaid = OAIDFactory.createUniversalImpl(context);
        return ioaid;
    }

    private static IOAID createManufacturerImpl(Context context) {
        HonorImpl honor;
        if (OAIDRom.isLenovo() || OAIDRom.isMotorola()) {
            return new LenovoImpl(context);
        }
        if (OAIDRom.isMeizu()) {
            return new MeizuImpl(context);
        }
        if (OAIDRom.isNubia()) {
            return new NubiaImpl(context);
        }
        if (OAIDRom.isXiaomi() || OAIDRom.isBlackShark() || OAIDRom.isMiui()) {
            return new XiaomiImpl(context);
        }
        if (OAIDRom.isSamsung()) {
            return new SamsungImpl(context);
        }
        if (OAIDRom.isVivo()) {
            return new VivoImpl(context);
        }
        if (OAIDRom.isASUS()) {
            return new AsusImpl(context);
        }
        if (OAIDRom.isHonor() && !OAIDRom.isEmui() && (honor = new HonorImpl(context)).supported()) {
            return honor;
        }
        if (OAIDRom.isHuawei() || OAIDRom.isHonor() || OAIDRom.isHarmonyOS() || OAIDRom.isEmui() || OAIDRom.isMagicUI()) {
            return new HuaweiImpl(context);
        }
        if (OAIDRom.isOppo() || OAIDRom.isOnePlus()) {
            OppoImpl oppo = new OppoImpl(context);
            if (oppo.supported()) {
                return oppo;
            }
            return new OppoExtImpl(context);
        }
        if (OAIDRom.isCoolpad(context)) {
            return new CoolpadImpl(context);
        }
        if (OAIDRom.isCoosea()) {
            return new CooseaImpl(context);
        }
        if (OAIDRom.isFreeme()) {
            return new FreemeImpl(context);
        }
        if (OAIDRom.is360OS()) {
            return new QikuImpl(context);
        }
        return null;
    }

    private static IOAID createUniversalImpl(Context context) {
        IOAID ioaid = new MsaImpl(context);
        if (ioaid.supported()) {
            OAIDLog.print("Mobile Security Alliance has been found: " + ioaid.getClass().getName());
            return ioaid;
        }
        ioaid = new GmsImpl(context);
        if (ioaid.supported()) {
            OAIDLog.print("Google Play Service has been found: " + ioaid.getClass().getName());
            return ioaid;
        }
        ioaid = new DefaultImpl();
        OAIDLog.print("OAID/AAID was not supported: " + ioaid.getClass().getName());
        return ioaid;
    }
}

