/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.media.MediaDrm;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.IRegisterCallback;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.UUID;

public final class DeviceID {
    private Application application;
    private boolean tryWidevine;
    private String clientId;
    private String oaid;

    public static void register(Application application) {
        DeviceID.register(application, false, null);
    }

    public static void register(Application application, boolean tryWidevine) {
        DeviceID.register(application, tryWidevine, null);
    }

    public static void register(Application application, IRegisterCallback callback) {
        DeviceID.register(application, false, callback);
    }

    public static void register(Application application, boolean tryWidevine, IRegisterCallback callback) {
        if (application == null) {
            if (callback != null) {
                callback.onComplete("", new RuntimeException("application is nulll"));
            }
            return;
        }
        Holder.INSTANCE.application = application;
        Holder.INSTANCE.tryWidevine = tryWidevine;
        String uniqueID = DeviceID.getUniqueID((Context)application);
        if (!TextUtils.isEmpty((CharSequence)uniqueID)) {
            Holder.INSTANCE.clientId = uniqueID;
            OAIDLog.print("Client id is IMEI/MEID: " + Holder.INSTANCE.clientId);
            if (callback != null) {
                callback.onComplete(uniqueID, null);
            }
            return;
        }
        DeviceID.getOAIDOrOtherId(application, tryWidevine, callback);
    }

    private static void getOAIDOrOtherId(final Application application, final boolean tryWidevine, final IRegisterCallback callback) {
        DeviceID.getOAID((Context)application, new IGetter(){

            @Override
            public void onOAIDGetComplete(String result) {
                if (TextUtils.isEmpty((CharSequence)result)) {
                    this.onOAIDGetError(new OAIDException("OAID is empty"));
                    return;
                }
                Holder.INSTANCE.clientId = result;
                Holder.INSTANCE.oaid = result;
                OAIDLog.print("Client id is OAID/AAID: " + result);
                if (callback != null) {
                    callback.onComplete(result, null);
                }
            }

            @Override
            public void onOAIDGetError(Exception error) {
                DeviceID.getOtherId(error, application, tryWidevine, callback);
            }
        });
    }

    private static void getOtherId(Exception error, Application application, boolean tryWidevine, IRegisterCallback callback) {
        String id = "";
        if (tryWidevine && !TextUtils.isEmpty((CharSequence)(id = DeviceID.getWidevineID()))) {
            Holder.INSTANCE.clientId = id;
            OAIDLog.print("Client id is WidevineID: " + id);
            if (callback != null) {
                callback.onComplete(id, error);
            }
            return;
        }
        id = DeviceID.getAndroidID((Context)application);
        if (!TextUtils.isEmpty((CharSequence)id)) {
            Holder.INSTANCE.clientId = id;
            OAIDLog.print("Client id is AndroidID: " + id);
            if (callback != null) {
                callback.onComplete(id, error);
            }
            return;
        }
        Holder.INSTANCE.clientId = id = DeviceID.getGUID((Context)application);
        OAIDLog.print("Client id is GUID: " + id);
        if (callback != null) {
            callback.onComplete(id, error);
        }
    }

    public static String getClientId() {
        String clientId = Holder.INSTANCE.clientId;
        if (clientId == null) {
            clientId = "";
        }
        return clientId;
    }

    public static String getClientIdMD5() {
        return DeviceID.calculateHash(DeviceID.getClientId(), "MD5");
    }

    public static String getClientIdSHA1() {
        return DeviceID.calculateHash(DeviceID.getClientId(), "SHA-1");
    }

    public static String getOAID() {
        String oaid = Holder.INSTANCE.oaid;
        if (oaid == null) {
            oaid = "";
        }
        return oaid;
    }

    public static void getOAID(Context context, IGetter getter) {
        IOAID ioaid = OAIDFactory.create(context);
        OAIDLog.print("OAID implements class: " + ioaid.getClass().getName());
        ioaid.doGet(getter);
    }

    public static boolean supportedOAID(Context context) {
        return OAIDFactory.create(context).supported();
    }

    public static String getUniqueID(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            OAIDLog.print("IMEI/MEID not allowed on Android 10+");
            return "";
        }
        if (context == null) {
            return "";
        }
        if (Build.VERSION.SDK_INT >= 23 && context.checkSelfPermission("android.permission.READ_PHONE_STATE") != 0) {
            OAIDLog.print("android.permission.READ_PHONE_STATE not granted");
            return "";
        }
        return DeviceID.getIMEI(context);
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    private static String getIMEI(Context context) {
        if (context == null) {
            return "";
        }
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String imei = tm.getImei();
            if (TextUtils.isEmpty((CharSequence)imei)) {
                imei = tm.getMeid();
            }
            return imei;
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
        catch (Error e) {
            OAIDLog.print(e);
        }
        return "";
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID(Context context) {
        if (context == null) {
            return "";
        }
        String id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (id == null || "9774d56d682e549c".equals(id)) {
            id = "";
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getWidevineID() {
        MediaDrm mediaDrm = null;
        try {
            UUID WIDEVINE_UUID = new UUID(-1301668207276963122L, -6645017420763422227L);
            mediaDrm = new MediaDrm(WIDEVINE_UUID);
            byte[] widevineId = mediaDrm.getPropertyByteArray("deviceUniqueId");
            if (widevineId == null) {
                String string = "";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            for (byte aByte : widevineId) {
                sb.append(String.format("%02x", aByte));
            }
            String string = sb.toString();
            return string;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
        }
        finally {
            if (mediaDrm != null) {
                mediaDrm.release();
            }
        }
        return "";
    }

    public static String getPseudoID() {
        int MODULUS = 10;
        StringBuilder sb = new StringBuilder();
        sb.append(Build.BOARD.length() % 10);
        if (Build.VERSION.SDK_INT >= 21) {
            sb.append(Arrays.deepToString(Build.SUPPORTED_ABIS).length() % 10);
        } else {
            sb.append(Build.CPU_ABI.length() % 10);
        }
        sb.append(Build.DEVICE.length() % 10);
        sb.append(Build.DISPLAY.length() % 10);
        sb.append(Build.HOST.length() % 10);
        sb.append(Build.ID.length() % 10);
        sb.append(Build.MANUFACTURER.length() % 10);
        sb.append(Build.BRAND.length() % 10);
        sb.append(Build.MODEL.length() % 10);
        sb.append(Build.PRODUCT.length() % 10);
        sb.append(Build.BOOTLOADER.length() % 10);
        sb.append(Build.HARDWARE.length() % 10);
        sb.append(Build.TAGS.length() % 10);
        sb.append(Build.TYPE.length() % 10);
        sb.append(Build.USER.length() % 10);
        return sb.toString();
    }

    public static String getGUID(Context context) {
        String uuid = DeviceID.getUuidFromSystemSettings(context);
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = DeviceID.getUuidFromExternalStorage(context);
        }
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = DeviceID.getUuidFromSharedPreferences(context);
        }
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
            OAIDLog.print("Generate uuid by random: " + uuid);
            DeviceID.saveUuidToSharedPreferences(context, uuid);
            DeviceID.saveUuidToSystemSettings(context, uuid);
            DeviceID.saveUuidToExternalStorage(context, uuid);
        }
        return uuid;
    }

    private static String getUuidFromSystemSettings(Context context) {
        if (context == null) {
            return "";
        }
        String uuid = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"GUID_uuid");
        OAIDLog.print("Get uuid from system settings: " + uuid);
        return uuid;
    }

    private static void saveUuidToSystemSettings(Context context, String uuid) {
        if (context == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 23 || Settings.System.canWrite((Context)context)) {
            try {
                Settings.System.putString((ContentResolver)context.getContentResolver(), (String)"GUID_uuid", (String)uuid);
                OAIDLog.print("Save uuid to system settings: " + uuid);
            }
            catch (Exception e) {
                OAIDLog.print(e);
            }
        } else {
            OAIDLog.print("android.permission.WRITE_SETTINGS not granted");
        }
    }

    private static String getUuidFromExternalStorage(Context context) {
        if (context == null) {
            return "";
        }
        String uuid = "";
        File file = DeviceID.getGuidFile(context);
        if (file != null) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                uuid = reader.readLine();
            }
            catch (Exception e) {
                OAIDLog.print(e);
            }
        }
        OAIDLog.print("Get uuid from external storage: " + uuid);
        return uuid;
    }

    private static void saveUuidToExternalStorage(Context context, String uuid) {
        if (context == null) {
            return;
        }
        File file = DeviceID.getGuidFile(context);
        if (file == null) {
            OAIDLog.print("UUID file in external storage is null");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            if (!file.exists()) {
                file.createNewFile();
            }
            writer.write(uuid);
            writer.flush();
            OAIDLog.print("Save uuid to external storage: " + uuid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
    }

    private static File getGuidFile(Context context) {
        boolean hasStoragePermission = false;
        if (Build.VERSION.SDK_INT < 23) {
            hasStoragePermission = true;
        } else if (Build.VERSION.SDK_INT >= 30) {
            hasStoragePermission = false;
        } else if (context != null) {
            boolean bl = hasStoragePermission = context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        }
        if (hasStoragePermission && "mounted".equals(Environment.getExternalStorageState())) {
            return new File(Environment.getExternalStorageDirectory(), "Android/.GUID_uuid");
        }
        return null;
    }

    private static void saveUuidToSharedPreferences(Context context, String uuid) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("GUID", 0);
        preferences.edit().putString("uuid", uuid).apply();
        OAIDLog.print("Save uuid to shared preferences: " + uuid);
    }

    private static String getUuidFromSharedPreferences(Context context) {
        if (context == null) {
            return "";
        }
        SharedPreferences preferences = context.getSharedPreferences("GUID", 0);
        String uuid = preferences.getString("uuid", "");
        OAIDLog.print("Get uuid from shared preferences: " + uuid);
        return uuid;
    }

    public static String calculateHash(String str, String algorithm) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        try {
            byte[] data = str.getBytes();
            byte[] bytes = MessageDigest.getInstance(algorithm).digest(data);
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(String.format("%02x", aByte));
            }
            return sb.toString();
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return "";
        }
    }

    public static String getCanvasFingerprint() {
        int width = 200;
        int height = 100;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(-1);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setTextSize(18.0f);
        paint.setTypeface(Typeface.SERIF);
        canvas.drawText("\u7fa1\u6c11@\u674e\u88d5\u6c5f", 10.0f, 50.0f, paint);
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        StringBuilder pixelData = new StringBuilder();
        for (int pixel : pixels) {
            pixelData.append(pixel);
        }
        return DeviceID.calculateHash(pixelData.toString(), "SHA-1");
    }

    private DeviceID() {
    }

    private static class Holder {
        static final DeviceID INSTANCE = new DeviceID();

        private Holder() {
        }
    }
}

