/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.dialog.ModalDialog;
import com.github.gzuliyujiang.filepicker.ExplorerConfig;
import com.github.gzuliyujiang.filepicker.FileExplorer;
import com.github.gzuliyujiang.filepicker.contract.OnFileClickedListener;
import java.io.File;

public class FilePicker
extends ModalDialog {
    private FileExplorer fileExplorer;
    private boolean initialized = false;
    private ExplorerConfig explorerConfig;

    public FilePicker(Activity activity) {
        super(activity);
    }

    public FilePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView() {
        this.fileExplorer = new FileExplorer((Context)this.activity);
        return this.fileExplorer;
    }

    protected void initView() {
        super.initView();
        this.setHeight((int)((float)this.activity.getResources().getDisplayMetrics().heightPixels * 0.6f));
    }

    protected void initData() {
        super.initData();
        this.initialized = true;
        this.setExplorerConfig(this.explorerConfig);
        final ExplorerConfig config = this.fileExplorer.getExplorerConfig();
        config.setOnFileClickedListener(new OnFileClickedListener(){

            @Override
            public void onFileClicked(@NonNull File file) {
                if (config.getExplorerMode() == 1) {
                    FilePicker.this.dismiss();
                    config.getOnFilePickedListener().onFilePicked(file);
                }
            }
        });
        if (config.getExplorerMode() == 1) {
            this.okView.setVisibility(8);
        }
    }

    protected void onCancel() {
    }

    protected void onOk() {
        File currentFile = this.fileExplorer.getCurrentFile();
        DialogLog.print((Object)("picked directory: " + currentFile));
        if (this.fileExplorer.getExplorerConfig().getOnFilePickedListener() != null) {
            this.fileExplorer.getExplorerConfig().getOnFilePickedListener().onFilePicked(currentFile);
        }
    }

    public void setExplorerConfig(@Nullable ExplorerConfig config) {
        this.explorerConfig = config;
        if (this.initialized) {
            this.fileExplorer.load(config);
        }
    }

    public final File getCurrentFile() {
        return this.fileExplorer.getCurrentFile();
    }

    public final FileExplorer getFileExplorer() {
        return this.fileExplorer;
    }

    public final RecyclerView getFileListView() {
        return this.fileExplorer.getFileListView();
    }

    public final TextView getEmptyHintView() {
        return this.fileExplorer.getEmptyHintView();
    }

    public final RecyclerView getPathListView() {
        return this.fileExplorer.getPathListView();
    }
}

