/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import androidx.annotation.Dimension;
import androidx.core.content.ContextCompat;
import com.github.gzuliyujiang.filepicker.R;
import com.github.gzuliyujiang.filepicker.contract.OnFileClickedListener;
import com.github.gzuliyujiang.filepicker.contract.OnFileLoadedListener;
import com.github.gzuliyujiang.filepicker.contract.OnFilePickedListener;
import com.github.gzuliyujiang.filepicker.contract.OnPathClickedListener;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;

public class ExplorerConfig
implements Serializable {
    private final Context context;
    private File rootDir;
    private boolean loadAsync;
    private String[] allowExtensions = null;
    private int explorerMode = 1;
    private boolean showHomeDir = true;
    private boolean showUpDir = true;
    private boolean showHideDir = true;
    private int fileSort = 0;
    private int itemHeight = 40;
    private Drawable homeIcon;
    private Drawable upIcon;
    private Drawable folderIcon;
    private Drawable fileIcon;
    private OnFileLoadedListener onFileLoadedListener;
    private OnPathClickedListener onPathClickedListener;
    private OnFileClickedListener onFileClickedListener;
    private OnFilePickedListener onFilePickedListener;

    public ExplorerConfig(Context context) {
        this.context = context;
        this.homeIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_home);
        this.upIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_up);
        this.folderIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_folder);
        this.fileIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_file);
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public File getRootDir() {
        if (this.rootDir == null) {
            this.rootDir = Environment.getExternalStorageState().equals("mounted") ? Environment.getExternalStorageDirectory() : this.context.getFilesDir();
        }
        return this.rootDir;
    }

    public void setLoadAsync(boolean loadAsync) {
        this.loadAsync = loadAsync;
    }

    public boolean isLoadAsync() {
        return this.loadAsync;
    }

    public ExplorerConfig setItemHeight(@Dimension(unit=0) int itemHeight) {
        if (itemHeight < 10 || itemHeight > 100) {
            return this;
        }
        this.itemHeight = itemHeight;
        return this;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public ExplorerConfig setFileIcon(Drawable fileIcon) {
        if (fileIcon == null) {
            return this;
        }
        this.fileIcon = fileIcon;
        return this;
    }

    public Drawable getFileIcon() {
        return this.fileIcon;
    }

    public ExplorerConfig setFolderIcon(Drawable folderIcon) {
        if (folderIcon == null) {
            return this;
        }
        this.folderIcon = folderIcon;
        return this;
    }

    public Drawable getFolderIcon() {
        return this.folderIcon;
    }

    public ExplorerConfig setHomeIcon(Drawable homeIcon) {
        if (homeIcon == null) {
            return this;
        }
        this.homeIcon = homeIcon;
        return this;
    }

    public Drawable getHomeIcon() {
        return this.homeIcon;
    }

    public ExplorerConfig setUpIcon(Drawable upIcon) {
        if (upIcon == null) {
            return this;
        }
        this.upIcon = upIcon;
        return this;
    }

    public Drawable getUpIcon() {
        return this.upIcon;
    }

    public ExplorerConfig setAllowExtensions(String[] allowExtensions) {
        if (this.allowExtensions != null && Arrays.equals(this.allowExtensions, allowExtensions)) {
            return this;
        }
        this.allowExtensions = allowExtensions;
        return this;
    }

    public String[] getAllowExtensions() {
        return this.allowExtensions;
    }

    public int getExplorerMode() {
        return this.explorerMode;
    }

    public void setExplorerMode(int explorerMode) {
        this.explorerMode = explorerMode;
    }

    public ExplorerConfig setShowHomeDir(boolean showHomeDir) {
        if (this.showHomeDir == showHomeDir) {
            return this;
        }
        this.showHomeDir = showHomeDir;
        return this;
    }

    public boolean isShowHomeDir() {
        return this.showHomeDir;
    }

    public ExplorerConfig setShowUpDir(boolean showUpDir) {
        if (this.showUpDir == showUpDir) {
            return this;
        }
        this.showUpDir = showUpDir;
        return this;
    }

    public boolean isShowUpDir() {
        return this.showUpDir;
    }

    public ExplorerConfig setShowHideDir(boolean showHideDir) {
        if (this.showHideDir == showHideDir) {
            return this;
        }
        this.showHideDir = showHideDir;
        return this;
    }

    public boolean isShowHideDir() {
        return this.showHideDir;
    }

    public ExplorerConfig setFileSort(int fileSort) {
        if (this.fileSort == fileSort) {
            return this;
        }
        this.fileSort = fileSort;
        return this;
    }

    public int getFileSort() {
        return this.fileSort;
    }

    public ExplorerConfig setOnFileLoadedListener(OnFileLoadedListener listener) {
        this.onFileLoadedListener = listener;
        return this;
    }

    public OnFileLoadedListener getOnFileLoadedListener() {
        return this.onFileLoadedListener;
    }

    public ExplorerConfig setOnPathClickedListener(OnPathClickedListener listener) {
        this.onPathClickedListener = listener;
        return this;
    }

    public OnPathClickedListener getOnPathClickedListener() {
        return this.onPathClickedListener;
    }

    public OnFileClickedListener getOnFileClickedListener() {
        return this.onFileClickedListener;
    }

    public void setOnFileClickedListener(OnFileClickedListener onFileClickedListener) {
        this.onFileClickedListener = onFileClickedListener;
    }

    public OnFilePickedListener getOnFilePickedListener() {
        return this.onFilePickedListener;
    }

    public void setOnFilePickedListener(OnFilePickedListener onFilePickedListener) {
        this.onFilePickedListener = onFilePickedListener;
    }
}

