/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.basepicker.ConfirmPicker;
import com.github.gzuliyujiang.basepicker.PickerLog;
import com.github.gzuliyujiang.filepicker.FileExplorer;
import com.github.gzuliyujiang.filepicker.contract.OnFileClickedListener;
import com.github.gzuliyujiang.filepicker.contract.OnFilePickedListener;
import java.io.File;

public class FilePicker
extends ConfirmPicker {
    private int explorerMode = 1;
    private File initDir;
    private FileExplorer fileExplorer;
    private OnFilePickedListener onFilePickedListener;
    private boolean initialized = false;

    public FilePicker(Activity activity) {
        super(activity);
    }

    public FilePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView(@NonNull Activity activity) {
        this.fileExplorer = new FileExplorer((Context)activity);
        return this.fileExplorer;
    }

    protected void initData() {
        super.initData();
        this.initialized = true;
        if (this.explorerMode == 1) {
            this.okView.setVisibility(4);
        }
        this.setBodyHeight(300);
        this.setInitDir(this.explorerMode, this.initDir);
    }

    protected void onCancel() {
    }

    protected void onOk() {
        File currentFile = this.fileExplorer.getCurrentFile();
        PickerLog.print((Object)("picked directory: " + currentFile));
        if (this.onFilePickedListener != null) {
            this.onFilePickedListener.onFilePicked(currentFile);
        }
    }

    public void setInitDir(int explorerMode, File initDir) {
        this.explorerMode = explorerMode;
        this.initDir = initDir;
        if (this.initialized) {
            this.fileExplorer.setInitDir(explorerMode, initDir);
        }
    }

    public void setOnFilePickedListener(OnFilePickedListener listener) {
        this.onFilePickedListener = listener;
        this.fileExplorer.setOnFileClickedListener(new OnFileClickedListener(){

            @Override
            public void onFileClicked(@NonNull File file) {
                if (FilePicker.this.explorerMode == 1) {
                    FilePicker.this.dismiss();
                    FilePicker.this.onFilePickedListener.onFilePicked(file);
                }
            }
        });
    }

    public final File getCurrentFile() {
        return this.fileExplorer.getCurrentFile();
    }

    public final FileExplorer getFileExplorer() {
        return this.fileExplorer;
    }

    public final RecyclerView getFileListView() {
        return this.fileExplorer.getFileListView();
    }

    public final TextView getEmptyHintView() {
        return this.fileExplorer.getEmptyHintView();
    }

    public final View getBottomLineView() {
        return this.fileExplorer.getBottomLineView();
    }

    public final RecyclerView getPathListView() {
        return this.fileExplorer.getPathListView();
    }
}

