/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.qqtheme.framework.adapter.FileAdapter;
import cn.qqtheme.framework.adapter.PathAdapter;
import cn.qqtheme.framework.entity.FileItem;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.util.StorageUtils;
import cn.qqtheme.framework.widget.HorizontalListView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class FilePicker
extends ConfirmPopup<LinearLayout>
implements AdapterView.OnItemClickListener {
    public static final int DIRECTORY = 0;
    public static final int FILE = 1;
    private String initPath;
    private FileAdapter adapter = new FileAdapter();
    private PathAdapter pathAdapter = new PathAdapter();
    private TextView emptyView;
    private OnFilePickListener onFilePickListener;
    private int mode;
    private CharSequence emptyHint = Locale.getDefault().getDisplayLanguage().contains("\u4e2d\u6587") ? "<\u7a7a>" : "<Empty>";

    public FilePicker(Activity activity, int mode) {
        super(activity);
        this.setHalfScreen(true);
        try {
            this.initPath = StorageUtils.getDownloadPath();
        }
        catch (RuntimeException e) {
            this.initPath = StorageUtils.getInternalRootPath((Context)activity);
        }
        this.mode = mode;
        this.adapter.setOnlyListDir(mode == 0);
        this.adapter.setShowHideDir(false);
        this.adapter.setShowHomeDir(false);
        this.adapter.setShowUpDir(false);
    }

    @NonNull
    protected LinearLayout makeCenterView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setBackgroundColor(-1);
        ListView listView = new ListView((Context)this.activity);
        listView.setBackgroundColor(-1);
        listView.setDivider((Drawable)new ColorDrawable(-2236963));
        listView.setDividerHeight(1);
        listView.setCacheColorHint(0);
        listView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        listView.setAdapter((ListAdapter)this.adapter);
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        rootLayout.addView((View)listView);
        this.emptyView = new TextView((Context)this.activity);
        LinearLayout.LayoutParams txtParams = new LinearLayout.LayoutParams(-1, -1);
        txtParams.gravity = 17;
        this.emptyView.setLayoutParams((ViewGroup.LayoutParams)txtParams);
        this.emptyView.setGravity(17);
        this.emptyView.setVisibility(8);
        this.emptyView.setTextColor(-16777216);
        rootLayout.addView((View)this.emptyView);
        return rootLayout;
    }

    @Nullable
    protected View makeFooterView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        rootLayout.setOrientation(1);
        rootLayout.setBackgroundColor(-1);
        View lineView = new View((Context)this.activity);
        lineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
        lineView.setBackgroundColor(-2236963);
        rootLayout.addView(lineView);
        HorizontalListView pathView = new HorizontalListView((Context)this.activity);
        int height = ConvertUtils.toPx((Context)this.activity, (float)30.0f);
        pathView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, height));
        pathView.setAdapter((ListAdapter)this.pathAdapter);
        pathView.setBackgroundColor(-1);
        pathView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                FilePicker.this.refreshCurrentDirPath(FilePicker.this.pathAdapter.getItem(position));
            }
        });
        rootLayout.addView((View)pathView);
        return rootLayout;
    }

    public void setRootPath(String initPath) {
        this.initPath = initPath;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        this.adapter.setAllowExtensions(allowExtensions);
    }

    public void setShowUpDir(boolean showUpDir) {
        this.adapter.setShowUpDir(showUpDir);
    }

    public void setShowHomeDir(boolean showHomeDir) {
        this.adapter.setShowHomeDir(showHomeDir);
    }

    public void setShowHideDir(boolean showHideDir) {
        this.adapter.setShowHideDir(showHideDir);
    }

    public void setFileIcon(Drawable fileIcon) {
        this.adapter.setFileIcon(fileIcon);
    }

    public void setFolderIcon(Drawable folderIcon) {
        this.adapter.setFolderIcon(folderIcon);
    }

    public void setHomeIcon(Drawable homeIcon) {
        this.adapter.setHomeIcon(homeIcon);
    }

    public void setUpIcon(Drawable upIcon) {
        this.adapter.setUpIcon(upIcon);
    }

    public void setArrowIcon(Drawable arrowIcon) {
        this.pathAdapter.setArrowIcon(arrowIcon);
    }

    public void setItemHeight(int itemHeight) {
        this.adapter.setItemHeight(itemHeight);
    }

    public void setEmptyHint(CharSequence emptyHint) {
        this.emptyHint = emptyHint;
    }

    protected void setContentViewBefore() {
        boolean isPickFile = this.mode == 1;
        this.setCancelVisible(!isPickFile);
        if (isPickFile) {
            this.setSubmitText(this.activity.getString(0x1040000));
        } else {
            this.setSubmitText(this.activity.getString(17039370));
        }
    }

    protected void setContentViewAfter(View contentView) {
        this.refreshCurrentDirPath(this.initPath);
    }

    protected void onSubmit() {
        if (this.mode == 1) {
            LogUtils.verbose((String)"pick file canceled");
        } else {
            String currentPath = this.adapter.getCurrentPath();
            LogUtils.debug((String)("picked directory: " + currentPath));
            if (this.onFilePickListener != null) {
                this.onFilePickListener.onFilePicked(currentPath);
            }
        }
    }

    public void dismiss() {
        super.dismiss();
    }

    public FileAdapter getAdapter() {
        return this.adapter;
    }

    public PathAdapter getPathAdapter() {
        return this.pathAdapter;
    }

    public String getCurrentPath() {
        return this.adapter.getCurrentPath();
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
        FileItem fileItem = this.adapter.getItem(position);
        if (fileItem.isDirectory()) {
            this.refreshCurrentDirPath(fileItem.getPath());
        } else {
            String clickPath = fileItem.getPath();
            if (this.mode == 0) {
                LogUtils.warn((String)("not directory: " + clickPath));
            } else {
                this.dismiss();
                LogUtils.debug((String)("picked path: " + clickPath));
                if (this.onFilePickListener != null) {
                    this.onFilePickListener.onFilePicked(clickPath);
                }
            }
        }
    }

    private void refreshCurrentDirPath(String currentPath) {
        if (currentPath.equals("/")) {
            this.pathAdapter.updatePath("/");
        } else {
            this.pathAdapter.updatePath(currentPath);
        }
        this.adapter.loadData(currentPath);
        int adapterCount = this.adapter.getCount();
        if (this.adapter.isShowHomeDir()) {
            --adapterCount;
        }
        if (this.adapter.isShowUpDir()) {
            --adapterCount;
        }
        if (adapterCount < 1) {
            LogUtils.verbose((Object)((Object)this), (String)"no files, or dir is empty");
            this.emptyView.setVisibility(0);
            this.emptyView.setText(this.emptyHint);
        } else {
            LogUtils.verbose((Object)((Object)this), (String)("files or dirs count: " + adapterCount));
            this.emptyView.setVisibility(8);
        }
    }

    public void setOnFilePickListener(OnFilePickListener listener) {
        this.onFilePickListener = listener;
    }

    public static interface OnFilePickListener {
        public void onFilePicked(String var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

