/*
 * Decompiled with CFR 0.152.
 */
package com.github.guilhe.circularprogressview;

import android.animation.Animator;
import android.animation.FloatEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorRes;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.github.guilhe.circularprogressview.R;

public class CircularProgressView
extends View {
    private static final String TAG = CircularProgressView.class.getSimpleName();
    private static final float DEFAULT_VIEW_PADDING_DP = 10.0f;
    private static final float DEFAULT_SHADOW_PADDING_DP = 5.0f;
    private static final float DEFAULT_STROKE_THICKNESS_DP = 10.0f;
    private static final int DEFAULT_MAX_WIDTH_DP = 100;
    private static final int DEFAULT_MAX = 100;
    private static final int DEFAULT_STARTING_ANGLE = 275;
    private static final int DEFAULT_ANIMATION_MILLIS = 1000;
    private static final int DEFAULT_PROGRESS_COLOR = -16777216;
    private static final float DEFAULT_BACKGROUND_ALPHA = 0.3f;
    private static final TimeInterpolator DEFAULT_INTERPOLATOR = new DecelerateInterpolator();
    private int mMax;
    private boolean mShadowEnabled;
    private int mStartingAngle;
    private float mProgress;
    private float mProgressStrokeThickness;
    private int mProgressColor;
    private int mBackgroundColor;
    private RectF mProgressRectF;
    private RectF mShadowRectF;
    private Outline mOutline;
    private Paint mBackgroundPaint;
    private Paint mProgressPaint;
    private Paint mShadowPaint;
    private int mLastValidRawMeasuredDim;
    private float mLastValidStrokeThickness;
    private TimeInterpolator mInterpolator;
    private Animator mProgressAnimator;

    public CircularProgressView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircularProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircularProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @RequiresApi(api=21)
    public CircularProgressView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.mLastValidStrokeThickness = 10.0f;
        this.mInterpolator = DEFAULT_INTERPOLATOR;
        this.mProgressRectF = new RectF();
        this.mShadowRectF = new RectF();
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint = new Paint(1);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mShadowPaint = new Paint(1);
        this.mShadowPaint.setStyle(Paint.Style.STROKE);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircularProgressView, 0, 0);
            try {
                this.mMax = typedArray.getInt(R.styleable.CircularProgressView_max, 100);
                this.mShadowEnabled = typedArray.getBoolean(R.styleable.CircularProgressView_shadow, true);
                this.mStartingAngle = typedArray.getInteger(R.styleable.CircularProgressView_startingAngle, 275);
                this.mProgress = typedArray.getFloat(R.styleable.CircularProgressView_progress, 0.0f);
                this.mProgressStrokeThickness = typedArray.getDimension(R.styleable.CircularProgressView_progressBarThickness, (float)CircularProgressView.convertDpToPx(context, 10.0f));
                this.mProgressColor = typedArray.getInt(R.styleable.CircularProgressView_progressBarColor, -16777216);
                this.mBackgroundColor = typedArray.getInt(R.styleable.CircularProgressView_backgroundColor, this.mProgressColor);
            }
            finally {
                typedArray.recycle();
            }
        } else {
            this.mProgressStrokeThickness = CircularProgressView.convertDpToPx(context, 10.0f);
            this.mShadowEnabled = true;
            this.mMax = 100;
            this.mStartingAngle = 275;
            this.mBackgroundColor = this.mProgressColor = -16777216;
        }
        this.mBackgroundPaint.setColor(this.adjustAlpha(this.mBackgroundColor, 0.3f));
        this.mProgressPaint.setColor(this.mProgressColor);
        this.mShadowPaint.setColor(this.adjustAlpha(-16777216, 0.2f));
        this.setThickness(this.mProgressStrokeThickness, false);
    }

    public void setSize(int size) {
        this.getLayoutParams().height = size;
        this.requestLayout();
    }

    public void setStartingAngle(int angle) {
        this.mStartingAngle = angle;
        this.invalidate();
    }

    public int getStartingAngle() {
        return this.mStartingAngle;
    }

    public void setMax(int max) {
        this.mMax = max;
        this.invalidate();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setColor(int color) {
        this.setProgressColor(color);
        this.setBackgroundColor(color);
    }

    public void setColorResource(@ColorRes int resId) {
        this.setColor(ContextCompat.getColor((Context)this.getContext(), (int)resId));
    }

    @RequiresApi(api=26)
    public void setColor(Color color) {
        this.setColor(color.toArgb());
    }

    public void setProgressColor(int color) {
        this.mProgressColor = color;
        if (this.mBackgroundColor == -1) {
            this.setBackgroundColor(color);
        }
        this.mProgressPaint.setColor(color);
        this.invalidate();
    }

    public void setProgressColorResource(@ColorRes int resId) {
        this.setProgressColor(ContextCompat.getColor((Context)this.getContext(), (int)resId));
    }

    @RequiresApi(api=26)
    public void setProgressColor(Color color) {
        this.setProgressColor(color.toArgb());
    }

    public int getProgressColor() {
        return this.mProgressColor;
    }

    public void setBackgroundColor(int color) {
        this.mBackgroundColor = color;
        this.mBackgroundPaint.setColor(this.adjustAlpha(color, 0.3f));
        this.invalidate();
    }

    public void setShadowColorResource(@ColorRes int resId) {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)resId));
    }

    @RequiresApi(api=26)
    public void setBackgroundColor(Color color) {
        this.setBackgroundColor(color.toArgb());
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setShadowEnabled(boolean enable) {
        this.mShadowEnabled = enable;
        this.invalidate();
    }

    public boolean isShadowEnabled() {
        return this.mShadowEnabled;
    }

    public void setProgressStrokeThickness(float thickness) {
        this.setThickness(thickness, true);
    }

    private void setThickness(float thickness, boolean requestLayout) {
        this.mProgressStrokeThickness = thickness;
        this.mBackgroundPaint.setStrokeWidth(this.mProgressStrokeThickness);
        this.mProgressPaint.setStrokeWidth(this.mProgressStrokeThickness);
        this.mShadowPaint.setStrokeWidth(this.mProgressStrokeThickness);
        if (requestLayout) {
            this.requestLayout();
        }
    }

    public float getProgressStrokeThickness() {
        return this.mProgressStrokeThickness;
    }

    public void setProgress(float progress) {
        this.setProgress(progress, false);
    }

    public void setProgress(float progress, boolean animate) {
        this.setProgress(progress, animate, 1000L);
    }

    public void setProgress(float progress, boolean animate, long duration) {
        this.setProgress(progress, animate, duration, true);
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void resetProgress() {
        this.setProgress(0.0f);
    }

    public void resetProgress(boolean animate) {
        this.resetProgress(animate, 1000L);
    }

    public void resetProgress(boolean animate, long duration) {
        this.setProgress(0.0f, animate, duration, false);
    }

    public void setAnimationInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator == null ? DEFAULT_INTERPOLATOR : interpolator;
    }

    private void setProgress(float progress, boolean animate, long duration, boolean clockwise) {
        if (animate) {
            if (this.mProgressAnimator != null) {
                this.mProgressAnimator.cancel();
            }
            this.mProgressAnimator = this.getAnimator(this.getProgress(), clockwise ? (double)progress : 0.0, duration, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    CircularProgressView.this.setProgressValue(((Float)valueAnimator.getAnimatedValue()).floatValue());
                }
            });
            this.mProgressAnimator.start();
        } else {
            this.setProgressValue(progress);
        }
    }

    private void setProgressValue(float value) {
        this.mProgress = value;
        this.invalidate();
    }

    private ValueAnimator getAnimator(double current, double next, long duration, ValueAnimator.AnimatorUpdateListener updateListener) {
        ValueAnimator animator = new ValueAnimator();
        animator.setInterpolator(this.mInterpolator);
        animator.setDuration(duration);
        animator.setObjectValues(new Object[]{current, next});
        animator.setEvaluator((TypeEvaluator)new FloatEvaluator(){

            public Integer evaluate(float fraction, float startValue, float endValue) {
                return Math.round(startValue + (endValue - startValue) * fraction);
            }
        });
        animator.addUpdateListener(updateListener);
        return animator;
    }

    private int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getMode((int)heightMeasureSpec) != 0 ? View.MeasureSpec.getSize((int)heightMeasureSpec) : CircularProgressView.convertDpToPx(this.getContext(), 100.0f);
        int rawMeasuredDim = Math.max(Math.min(width, height), 0);
        float arcDim = this.mProgressStrokeThickness + (float)CircularProgressView.convertDpToPx(this.getContext(), 10.0f);
        this.mProgressRectF.set(arcDim, arcDim, (float)rawMeasuredDim - arcDim, (float)rawMeasuredDim - arcDim);
        if (this.mProgressRectF.width() <= this.mProgressStrokeThickness) {
            rawMeasuredDim = this.mLastValidRawMeasuredDim;
            this.mProgressRectF.set(arcDim, arcDim, (float)rawMeasuredDim - arcDim, (float)rawMeasuredDim - arcDim);
            this.setThickness(this.mLastValidStrokeThickness, false);
        }
        this.mLastValidRawMeasuredDim = rawMeasuredDim;
        this.mLastValidStrokeThickness = this.mProgressStrokeThickness;
        int shadowPadding = CircularProgressView.convertDpToPx(this.getContext(), 5.0f);
        this.mShadowRectF.set(this.mProgressRectF.left, (float)shadowPadding + this.mProgressRectF.top, this.mProgressRectF.right, (float)shadowPadding + this.mProgressRectF.bottom);
        this.setMeasuredDimension(rawMeasuredDim, rawMeasuredDim);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float angle = 360.0f * this.mProgress / (float)this.mMax;
        if (this.mShadowEnabled) {
            canvas.drawArc(this.mShadowRectF, (float)this.mStartingAngle, angle, false, this.mShadowPaint);
        }
        canvas.drawOval(this.mProgressRectF, this.mBackgroundPaint);
        canvas.drawArc(this.mProgressRectF, (float)this.mStartingAngle, angle, false, this.mProgressPaint);
    }

    private static int convertDpToPx(Context context, float dp) {
        return (int)(dp * context.getResources().getDisplayMetrics().density + 0.5f);
    }
}

