/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UrlUtils {
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);

    UrlUtils() {
    }

    public static Map<String, String> parseQueryString(String queryString) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString == null || queryString.equals("")) {
            return map;
        }
        for (String param : params = queryString.split("&")) {
            try {
                String[] keyValuePair = param.split("=", 2);
                String name = URLDecoder.decode(keyValuePair[0], "UTF-8");
                if (Objects.equals(name, "")) continue;
                String value = keyValuePair.length > 1 ? URLDecoder.decode(keyValuePair[1], "UTF-8") : "";
                map.put(name, value);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }
}

