/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonObject;
import growthbook.sdk.java.ExperimentHelper;
import growthbook.sdk.java.FeatureUsageCallback;
import growthbook.sdk.java.TrackingCallback;
import growthbook.sdk.java.multiusermode.util.TransformationUtil;
import growthbook.sdk.java.stickyBucketing.StickyAssignmentsDocument;
import growthbook.sdk.java.stickyBucketing.StickyBucketService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBContext {
    private static final Logger log = LoggerFactory.getLogger(GBContext.class);
    @Nullable
    private JsonObject features;
    @Nullable
    private Boolean enabled;
    @Nullable
    private String url;
    private Boolean isQaMode;
    private Boolean allowUrlOverride;
    @Nullable
    private TrackingCallback trackingCallback;
    @Nullable
    private FeatureUsageCallback featureUsageCallback;
    @Nullable
    private String attributesJson;
    private ExperimentHelper experimentHelper = new ExperimentHelper();
    @Nullable
    private JsonObject savedGroups;
    @Nullable
    private JsonObject attributes;
    @Nullable
    private String encryptionKey;
    @Nullable
    private Map<String, Integer> forcedVariationsMap;
    @Nullable
    private StickyBucketService stickyBucketService;
    @Nullable
    private Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs;
    @Nullable
    private List<String> stickyBucketIdentifierAttributes;

    public GBContext(@Nullable String attributesJson, @Nullable JsonObject attributes, @Nullable String featuresJson, @Nullable JsonObject features, @Nullable String encryptionKey, @Nullable Boolean enabled, Boolean isQaMode, @Nullable String url, Boolean allowUrlOverrides, @Nullable Map<String, Integer> forcedVariationsMap, @Nullable TrackingCallback trackingCallback, @Nullable FeatureUsageCallback featureUsageCallback, @Nullable StickyBucketService stickyBucketService, @Nullable Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs, @Nullable List<String> stickyBucketIdentifierAttributes, @Nullable JsonObject savedGroups) {
        this.encryptionKey = encryptionKey;
        this.attributesJson = attributesJson == null ? "{}" : attributesJson;
        JsonObject jsonObject = this.attributes = attributes == null ? new JsonObject() : attributes;
        if (featuresJson != null) {
            this.features = TransformationUtil.transformEncryptedFeatures(featuresJson, encryptionKey);
        }
        if (features != null) {
            this.features = features;
        }
        this.enabled = enabled == null ? true : enabled;
        this.isQaMode = isQaMode == null ? false : isQaMode;
        this.allowUrlOverride = allowUrlOverrides == null ? false : allowUrlOverrides;
        this.url = url;
        this.forcedVariationsMap = forcedVariationsMap == null ? new HashMap() : forcedVariationsMap;
        this.trackingCallback = trackingCallback;
        this.featureUsageCallback = featureUsageCallback;
        this.stickyBucketService = stickyBucketService;
        this.stickyBucketAssignmentDocs = stickyBucketAssignmentDocs;
        this.stickyBucketIdentifierAttributes = stickyBucketIdentifierAttributes;
        this.savedGroups = savedGroups;
    }

    public void setAttributesJson(String attributesJson) {
        this.attributesJson = attributesJson;
        if (attributesJson != null) {
            this.setAttributes(TransformationUtil.transformAttributes(attributesJson));
        }
    }

    public void setAttributes(@Nullable JsonObject attributes) {
        this.attributes = attributes == null ? new JsonObject() : attributes;
    }

    public void setFeaturesJson(String featuresJson) {
        if (featuresJson != null) {
            this.setFeatures(TransformationUtil.transformFeatures(featuresJson));
        }
    }

    public static GBContextBuilder builder() {
        return new CustomGBContextBuilder();
    }

    @Nullable
    public JsonObject getFeatures() {
        return this.features;
    }

    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public Boolean getIsQaMode() {
        return this.isQaMode;
    }

    public Boolean getAllowUrlOverride() {
        return this.allowUrlOverride;
    }

    @Nullable
    public TrackingCallback getTrackingCallback() {
        return this.trackingCallback;
    }

    @Nullable
    public FeatureUsageCallback getFeatureUsageCallback() {
        return this.featureUsageCallback;
    }

    @Nullable
    public String getAttributesJson() {
        return this.attributesJson;
    }

    public ExperimentHelper getExperimentHelper() {
        return this.experimentHelper;
    }

    @Nullable
    public JsonObject getSavedGroups() {
        return this.savedGroups;
    }

    @Nullable
    public JsonObject getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Nullable
    public Map<String, Integer> getForcedVariationsMap() {
        return this.forcedVariationsMap;
    }

    @Nullable
    public StickyBucketService getStickyBucketService() {
        return this.stickyBucketService;
    }

    @Nullable
    public Map<String, StickyAssignmentsDocument> getStickyBucketAssignmentDocs() {
        return this.stickyBucketAssignmentDocs;
    }

    @Nullable
    public List<String> getStickyBucketIdentifierAttributes() {
        return this.stickyBucketIdentifierAttributes;
    }

    public void setFeatures(@Nullable JsonObject features) {
        this.features = features;
    }

    public void setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public void setIsQaMode(Boolean isQaMode) {
        this.isQaMode = isQaMode;
    }

    public void setAllowUrlOverride(Boolean allowUrlOverride) {
        this.allowUrlOverride = allowUrlOverride;
    }

    public void setTrackingCallback(@Nullable TrackingCallback trackingCallback) {
        this.trackingCallback = trackingCallback;
    }

    public void setFeatureUsageCallback(@Nullable FeatureUsageCallback featureUsageCallback) {
        this.featureUsageCallback = featureUsageCallback;
    }

    public void setExperimentHelper(ExperimentHelper experimentHelper) {
        this.experimentHelper = experimentHelper;
    }

    public void setSavedGroups(@Nullable JsonObject savedGroups) {
        this.savedGroups = savedGroups;
    }

    public void setEncryptionKey(@Nullable String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setForcedVariationsMap(@Nullable Map<String, Integer> forcedVariationsMap) {
        this.forcedVariationsMap = forcedVariationsMap;
    }

    public void setStickyBucketService(@Nullable StickyBucketService stickyBucketService) {
        this.stickyBucketService = stickyBucketService;
    }

    public void setStickyBucketAssignmentDocs(@Nullable Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs) {
        this.stickyBucketAssignmentDocs = stickyBucketAssignmentDocs;
    }

    public void setStickyBucketIdentifierAttributes(@Nullable List<String> stickyBucketIdentifierAttributes) {
        this.stickyBucketIdentifierAttributes = stickyBucketIdentifierAttributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GBContext)) {
            return false;
        }
        GBContext other = (GBContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$isQaMode = this.getIsQaMode();
        Boolean other$isQaMode = other.getIsQaMode();
        if (this$isQaMode == null ? other$isQaMode != null : !((Object)this$isQaMode).equals(other$isQaMode)) {
            return false;
        }
        Boolean this$allowUrlOverride = this.getAllowUrlOverride();
        Boolean other$allowUrlOverride = other.getAllowUrlOverride();
        if (this$allowUrlOverride == null ? other$allowUrlOverride != null : !((Object)this$allowUrlOverride).equals(other$allowUrlOverride)) {
            return false;
        }
        JsonObject this$features = this.getFeatures();
        JsonObject other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !this$features.equals(other$features)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        TrackingCallback this$trackingCallback = this.getTrackingCallback();
        TrackingCallback other$trackingCallback = other.getTrackingCallback();
        if (this$trackingCallback == null ? other$trackingCallback != null : !this$trackingCallback.equals(other$trackingCallback)) {
            return false;
        }
        FeatureUsageCallback this$featureUsageCallback = this.getFeatureUsageCallback();
        FeatureUsageCallback other$featureUsageCallback = other.getFeatureUsageCallback();
        if (this$featureUsageCallback == null ? other$featureUsageCallback != null : !this$featureUsageCallback.equals(other$featureUsageCallback)) {
            return false;
        }
        String this$attributesJson = this.getAttributesJson();
        String other$attributesJson = other.getAttributesJson();
        if (this$attributesJson == null ? other$attributesJson != null : !this$attributesJson.equals(other$attributesJson)) {
            return false;
        }
        ExperimentHelper this$experimentHelper = this.getExperimentHelper();
        ExperimentHelper other$experimentHelper = other.getExperimentHelper();
        if (this$experimentHelper == null ? other$experimentHelper != null : !this$experimentHelper.equals(other$experimentHelper)) {
            return false;
        }
        JsonObject this$savedGroups = this.getSavedGroups();
        JsonObject other$savedGroups = other.getSavedGroups();
        if (this$savedGroups == null ? other$savedGroups != null : !this$savedGroups.equals(other$savedGroups)) {
            return false;
        }
        JsonObject this$attributes = this.getAttributes();
        JsonObject other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        String this$encryptionKey = this.getEncryptionKey();
        String other$encryptionKey = other.getEncryptionKey();
        if (this$encryptionKey == null ? other$encryptionKey != null : !this$encryptionKey.equals(other$encryptionKey)) {
            return false;
        }
        Map<String, Integer> this$forcedVariationsMap = this.getForcedVariationsMap();
        Map<String, Integer> other$forcedVariationsMap = other.getForcedVariationsMap();
        if (this$forcedVariationsMap == null ? other$forcedVariationsMap != null : !((Object)this$forcedVariationsMap).equals(other$forcedVariationsMap)) {
            return false;
        }
        StickyBucketService this$stickyBucketService = this.getStickyBucketService();
        StickyBucketService other$stickyBucketService = other.getStickyBucketService();
        if (this$stickyBucketService == null ? other$stickyBucketService != null : !this$stickyBucketService.equals(other$stickyBucketService)) {
            return false;
        }
        Map<String, StickyAssignmentsDocument> this$stickyBucketAssignmentDocs = this.getStickyBucketAssignmentDocs();
        Map<String, StickyAssignmentsDocument> other$stickyBucketAssignmentDocs = other.getStickyBucketAssignmentDocs();
        if (this$stickyBucketAssignmentDocs == null ? other$stickyBucketAssignmentDocs != null : !((Object)this$stickyBucketAssignmentDocs).equals(other$stickyBucketAssignmentDocs)) {
            return false;
        }
        List<String> this$stickyBucketIdentifierAttributes = this.getStickyBucketIdentifierAttributes();
        List<String> other$stickyBucketIdentifierAttributes = other.getStickyBucketIdentifierAttributes();
        return !(this$stickyBucketIdentifierAttributes == null ? other$stickyBucketIdentifierAttributes != null : !((Object)this$stickyBucketIdentifierAttributes).equals(other$stickyBucketIdentifierAttributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GBContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $isQaMode = this.getIsQaMode();
        result = result * 59 + ($isQaMode == null ? 43 : ((Object)$isQaMode).hashCode());
        Boolean $allowUrlOverride = this.getAllowUrlOverride();
        result = result * 59 + ($allowUrlOverride == null ? 43 : ((Object)$allowUrlOverride).hashCode());
        JsonObject $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : $features.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        TrackingCallback $trackingCallback = this.getTrackingCallback();
        result = result * 59 + ($trackingCallback == null ? 43 : $trackingCallback.hashCode());
        FeatureUsageCallback $featureUsageCallback = this.getFeatureUsageCallback();
        result = result * 59 + ($featureUsageCallback == null ? 43 : $featureUsageCallback.hashCode());
        String $attributesJson = this.getAttributesJson();
        result = result * 59 + ($attributesJson == null ? 43 : $attributesJson.hashCode());
        ExperimentHelper $experimentHelper = this.getExperimentHelper();
        result = result * 59 + ($experimentHelper == null ? 43 : $experimentHelper.hashCode());
        JsonObject $savedGroups = this.getSavedGroups();
        result = result * 59 + ($savedGroups == null ? 43 : $savedGroups.hashCode());
        JsonObject $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        String $encryptionKey = this.getEncryptionKey();
        result = result * 59 + ($encryptionKey == null ? 43 : $encryptionKey.hashCode());
        Map<String, Integer> $forcedVariationsMap = this.getForcedVariationsMap();
        result = result * 59 + ($forcedVariationsMap == null ? 43 : ((Object)$forcedVariationsMap).hashCode());
        StickyBucketService $stickyBucketService = this.getStickyBucketService();
        result = result * 59 + ($stickyBucketService == null ? 43 : $stickyBucketService.hashCode());
        Map<String, StickyAssignmentsDocument> $stickyBucketAssignmentDocs = this.getStickyBucketAssignmentDocs();
        result = result * 59 + ($stickyBucketAssignmentDocs == null ? 43 : ((Object)$stickyBucketAssignmentDocs).hashCode());
        List<String> $stickyBucketIdentifierAttributes = this.getStickyBucketIdentifierAttributes();
        result = result * 59 + ($stickyBucketIdentifierAttributes == null ? 43 : ((Object)$stickyBucketIdentifierAttributes).hashCode());
        return result;
    }

    public String toString() {
        return "GBContext(features=" + this.getFeatures() + ", enabled=" + this.getEnabled() + ", url=" + this.getUrl() + ", isQaMode=" + this.getIsQaMode() + ", allowUrlOverride=" + this.getAllowUrlOverride() + ", trackingCallback=" + this.getTrackingCallback() + ", featureUsageCallback=" + this.getFeatureUsageCallback() + ", attributesJson=" + this.getAttributesJson() + ", experimentHelper=" + this.getExperimentHelper() + ", savedGroups=" + this.getSavedGroups() + ", attributes=" + this.getAttributes() + ", encryptionKey=" + this.getEncryptionKey() + ", forcedVariationsMap=" + this.getForcedVariationsMap() + ", stickyBucketService=" + this.getStickyBucketService() + ", stickyBucketAssignmentDocs=" + this.getStickyBucketAssignmentDocs() + ", stickyBucketIdentifierAttributes=" + this.getStickyBucketIdentifierAttributes() + ")";
    }

    static class CustomGBContextBuilder
    extends GBContextBuilder {
        CustomGBContextBuilder() {
        }

        @Override
        public GBContext build() {
            GBContext context = super.build();
            context.setAttributesJson(context.attributesJson);
            return context;
        }
    }

    public static class GBContextBuilder {
        private String attributesJson;
        private JsonObject attributes;
        private String featuresJson;
        private JsonObject features;
        private String encryptionKey;
        private Boolean enabled;
        private Boolean isQaMode;
        private String url;
        private Boolean allowUrlOverrides;
        private Map<String, Integer> forcedVariationsMap;
        private TrackingCallback trackingCallback;
        private FeatureUsageCallback featureUsageCallback;
        private StickyBucketService stickyBucketService;
        private Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs;
        private List<String> stickyBucketIdentifierAttributes;
        private JsonObject savedGroups;

        GBContextBuilder() {
        }

        public GBContextBuilder attributesJson(@Nullable String attributesJson) {
            this.attributesJson = attributesJson;
            return this;
        }

        public GBContextBuilder attributes(@Nullable JsonObject attributes) {
            this.attributes = attributes;
            return this;
        }

        public GBContextBuilder featuresJson(@Nullable String featuresJson) {
            this.featuresJson = featuresJson;
            return this;
        }

        public GBContextBuilder features(@Nullable JsonObject features) {
            this.features = features;
            return this;
        }

        public GBContextBuilder encryptionKey(@Nullable String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public GBContextBuilder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public GBContextBuilder isQaMode(Boolean isQaMode) {
            this.isQaMode = isQaMode;
            return this;
        }

        public GBContextBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public GBContextBuilder allowUrlOverrides(Boolean allowUrlOverrides) {
            this.allowUrlOverrides = allowUrlOverrides;
            return this;
        }

        public GBContextBuilder forcedVariationsMap(@Nullable Map<String, Integer> forcedVariationsMap) {
            this.forcedVariationsMap = forcedVariationsMap;
            return this;
        }

        public GBContextBuilder trackingCallback(@Nullable TrackingCallback trackingCallback) {
            this.trackingCallback = trackingCallback;
            return this;
        }

        public GBContextBuilder featureUsageCallback(@Nullable FeatureUsageCallback featureUsageCallback) {
            this.featureUsageCallback = featureUsageCallback;
            return this;
        }

        public GBContextBuilder stickyBucketService(@Nullable StickyBucketService stickyBucketService) {
            this.stickyBucketService = stickyBucketService;
            return this;
        }

        public GBContextBuilder stickyBucketAssignmentDocs(@Nullable Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs) {
            this.stickyBucketAssignmentDocs = stickyBucketAssignmentDocs;
            return this;
        }

        public GBContextBuilder stickyBucketIdentifierAttributes(@Nullable List<String> stickyBucketIdentifierAttributes) {
            this.stickyBucketIdentifierAttributes = stickyBucketIdentifierAttributes;
            return this;
        }

        public GBContextBuilder savedGroups(@Nullable JsonObject savedGroups) {
            this.savedGroups = savedGroups;
            return this;
        }

        public GBContext build() {
            return new GBContext(this.attributesJson, this.attributes, this.featuresJson, this.features, this.encryptionKey, this.enabled, this.isQaMode, this.url, this.allowUrlOverrides, this.forcedVariationsMap, this.trackingCallback, this.featureUsageCallback, this.stickyBucketService, this.stickyBucketAssignmentDocs, this.stickyBucketIdentifierAttributes, this.savedGroups);
        }

        public String toString() {
            return "GBContext.GBContextBuilder(attributesJson=" + this.attributesJson + ", attributes=" + this.attributes + ", featuresJson=" + this.featuresJson + ", features=" + this.features + ", encryptionKey=" + this.encryptionKey + ", enabled=" + this.enabled + ", isQaMode=" + this.isQaMode + ", url=" + this.url + ", allowUrlOverrides=" + this.allowUrlOverrides + ", forcedVariationsMap=" + this.forcedVariationsMap + ", trackingCallback=" + this.trackingCallback + ", featureUsageCallback=" + this.featureUsageCallback + ", stickyBucketService=" + this.stickyBucketService + ", stickyBucketAssignmentDocs=" + this.stickyBucketAssignmentDocs + ", stickyBucketIdentifierAttributes=" + this.stickyBucketIdentifierAttributes + ", savedGroups=" + this.savedGroups + ")";
        }
    }
}

