/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.ConditionEvaluator;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentEvaluator;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.Feature;
import growthbook.sdk.java.FeatureEvalContext;
import growthbook.sdk.java.FeatureResult;
import growthbook.sdk.java.FeatureResultSource;
import growthbook.sdk.java.FeatureRule;
import growthbook.sdk.java.FeatureUsageCallback;
import growthbook.sdk.java.Filter;
import growthbook.sdk.java.GBContext;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.GrowthBookUtils;
import growthbook.sdk.java.IFeatureEvaluator;
import growthbook.sdk.java.ParentCondition;
import growthbook.sdk.java.TrackingCallback;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;

class FeatureEvaluator
implements IFeatureEvaluator {
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private final ExperimentEvaluator experimentEvaluator = new ExperimentEvaluator();
    private final FeatureEvalContext featureEvalContext = new FeatureEvalContext(null, new HashSet<String>());

    FeatureEvaluator() {
    }

    @Override
    public <ValueType> FeatureResult<ValueType> evaluateFeature(String key, GBContext context, Class<ValueType> valueTypeClass, JsonObject attributeOverrides) throws ClassCastException {
        this.featureEvalContext.setId(key);
        FeatureUsageCallback featureUsageCallback = context.getFeatureUsageCallback();
        FeatureResult emptyFeature = FeatureResult.builder().value(null).source(FeatureResultSource.UNKNOWN_FEATURE).build();
        try {
            JsonObject attributes;
            ValueType forcedValue;
            System.out.println("evaluateFeature: circular dependency detected:");
            if (this.featureEvalContext.getEvaluatedFeatures().contains(key)) {
                FeatureResult featureResultWhenCircularDependencyDetected = FeatureResult.builder().value(null).source(FeatureResultSource.CYCLIC_PREREQUISITE).build();
                if (featureUsageCallback != null) {
                    featureUsageCallback.onFeatureUsage(key, featureResultWhenCircularDependencyDetected);
                }
                return featureResultWhenCircularDependencyDetected;
            }
            this.featureEvalContext.getEvaluatedFeatures().add(key);
            if (context.getAllowUrlOverride().booleanValue() && (forcedValue = this.evaluateForcedFeatureValueFromUrl(key, context.getUrl(), valueTypeClass)) != null) {
                FeatureResult urlFeatureResult = FeatureResult.builder().value(forcedValue).source(FeatureResultSource.URL_OVERRIDE).build();
                if (featureUsageCallback != null) {
                    featureUsageCallback.onFeatureUsage(key, urlFeatureResult);
                }
                return urlFeatureResult;
            }
            JsonObject featuresJson = context.getFeatures();
            if (featuresJson == null || !featuresJson.has(key)) {
                if (featureUsageCallback != null) {
                    featureUsageCallback.onFeatureUsage(key, emptyFeature);
                }
                return emptyFeature;
            }
            JsonElement featureJson = featuresJson.get(key);
            FeatureResult defaultValueFeature = FeatureResult.builder().value(null).source(FeatureResultSource.DEFAULT_VALUE).build();
            if (featureJson == null) {
                System.out.println("featureJson is null");
                if (featureUsageCallback != null) {
                    featureUsageCallback.onFeatureUsage(key, defaultValueFeature);
                }
                return defaultValueFeature;
            }
            Feature feature = (Feature)this.jsonUtils.gson.fromJson(featureJson, Feature.class);
            if (feature == null) {
                if (featureUsageCallback != null) {
                    featureUsageCallback.onFeatureUsage(key, defaultValueFeature);
                }
                return defaultValueFeature;
            }
            if (feature.getRules() == null || feature.getRules().isEmpty()) {
                Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
                FeatureResult defaultValueFeatureForRules = FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
                if (featureUsageCallback != null) {
                    featureUsageCallback.onFeatureUsage(key, defaultValueFeatureForRules);
                }
                return defaultValueFeatureForRules;
            }
            String attributesJson = context.getAttributesJson();
            if (attributesJson == null) {
                attributesJson = "{}";
            }
            if ((attributes = context.getAttributes()) == null) {
                attributes = new JsonObject();
            }
            for (FeatureRule rule : feature.getRules()) {
                Experiment experiment;
                ExperimentResult result;
                ArrayList<Filter> filters;
                if (rule.getParentConditions() != null) {
                    for (ParentCondition parentCondition : rule.getParentConditions()) {
                        String attributesJsonString;
                        boolean evalCondition;
                        FeatureResult<ValueType> parentResult = this.evaluateFeature(parentCondition.getId(), context, valueTypeClass, attributeOverrides);
                        if (parentResult.getSource().equals((Object)FeatureResultSource.CYCLIC_PREREQUISITE)) {
                            FeatureResult featureResultWhenCircularDependencyDetected = FeatureResult.builder().value(null).source(FeatureResultSource.CYCLIC_PREREQUISITE).build();
                            if (featureUsageCallback != null) {
                                featureUsageCallback.onFeatureUsage(key, featureResultWhenCircularDependencyDetected);
                            }
                            return featureResultWhenCircularDependencyDetected;
                        }
                        HashMap<String, Object> evalObj = new HashMap<String, Object>();
                        if (parentResult.getValue() != null) {
                            evalObj.put("value", parentResult.getValue());
                        }
                        if ((evalCondition = this.conditionEvaluator.evaluateCondition(attributesJsonString = GrowthBookJsonUtils.getInstance().gson.toJson(evalObj), String.valueOf(parentCondition.getCondition())).booleanValue()) || !parentCondition.getGate().booleanValue()) continue;
                        System.out.println("Feature blocked by prerequisite");
                        FeatureResult featureResultWhenBlockedByPrerequisite = FeatureResult.builder().value(null).source(FeatureResultSource.PREREQUISITE).build();
                        if (featureUsageCallback != null) {
                            featureUsageCallback.onFeatureUsage(key, featureResultWhenBlockedByPrerequisite);
                        }
                        return featureResultWhenBlockedByPrerequisite;
                    }
                }
                if (GrowthBookUtils.isFilteredOut(filters = rule.getFilters(), attributes, context).booleanValue()) continue;
                if (rule.getForce() != null) {
                    String seed;
                    if (rule.getCondition() != null && !this.conditionEvaluator.evaluateCondition(attributesJson, rule.getCondition().toString()).booleanValue()) continue;
                    boolean gate1 = context.getStickyBucketService() != null;
                    boolean gate2 = !Boolean.TRUE.equals(rule.disableStickyBucketing);
                    boolean shouldFallbackAttributeBePassed = gate1 && gate2;
                    String fallback = shouldFallbackAttributeBePassed ? rule.getFallbackAttribute() : null;
                    String ruleKey = rule.getHashAttribute();
                    if (ruleKey == null) {
                        ruleKey = "id";
                    }
                    if ((seed = rule.getSeed()) == null) {
                        seed = key;
                    }
                    if (!GrowthBookUtils.isIncludedInRollout(attributes, seed, ruleKey, fallback, rule.getRange(), rule.getCoverage(), rule.getHashVersion(), context).booleanValue()) continue;
                    ArrayList trackData = rule.getTracks();
                    TrackingCallback trackingCallback = context.getTrackingCallback();
                    if (trackData != null && trackingCallback != null) {
                        trackData.forEach(t -> trackingCallback.onTrack(t.getExperiment(), t.getExperimentResult()));
                    }
                    if (rule.getRange() == null && rule.getCoverage() != null) {
                        String attributeValue = context.getAttributes().get(ruleKey) == null ? null : context.getAttributes().get(ruleKey).getAsString();
                        if (attributeValue == null || attributeValue.isEmpty()) continue;
                        Float hashFNV = GrowthBookUtils.hash(attributeValue, 1, key);
                        if (hashFNV == null) {
                            hashFNV = Float.valueOf(0.0f);
                        }
                        if (hashFNV.floatValue() > rule.getCoverage().floatValue()) continue;
                    }
                    Object value = GrowthBookJsonUtils.unwrap(rule.getForce());
                    FeatureResult forcedRuleFeatureValue = FeatureResult.builder().value(value).source(FeatureResultSource.FORCE).build();
                    if (featureUsageCallback != null) {
                        featureUsageCallback.onFeatureUsage(key, forcedRuleFeatureValue);
                    }
                    this.goOutFromCircularLoop();
                    return forcedRuleFeatureValue;
                }
                ArrayList variations = rule.getVariations();
                if (variations == null) continue;
                String experimentKey = rule.getKey();
                if (experimentKey == null) {
                    experimentKey = key;
                }
                if (!(result = this.experimentEvaluator.evaluateExperiment(experiment = Experiment.builder().key(experimentKey).coverage(rule.getCoverage()).weights(rule.getWeights()).hashAttribute(rule.getHashAttribute()).namespace(rule.getNamespace()).variations(rule.getVariations()).meta(rule.getMeta()).ranges(rule.getRanges()).name(rule.getName()).phase(rule.getPhase()).seed(rule.getSeed()).hashVersion(rule.getHashVersion()).filters(rule.getFilters()).variations(variations).minBucketVersion(rule.getMinBucketVersion()).bucketVersion(rule.getBucketVersion()).disableStickyBucketing(rule.getDisableStickyBucketing()).fallbackAttribute(rule.getFallbackAttribute()).build(), context, key, attributeOverrides)).getInExperiment().booleanValue() || result.getPassThrough() != null && result.getPassThrough().booleanValue()) continue;
                Object value = GrowthBookJsonUtils.unwrap(result.getValue());
                FeatureResult experimentFeatureResult = FeatureResult.builder().value(value).source(FeatureResultSource.EXPERIMENT).experiment(experiment).experimentResult(result).build();
                if (featureUsageCallback != null) {
                    featureUsageCallback.onFeatureUsage(key, experimentFeatureResult);
                }
                return experimentFeatureResult;
            }
            Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
            FeatureResult defaultValueFeatureResult = FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
            if (featureUsageCallback != null) {
                featureUsageCallback.onFeatureUsage(key, defaultValueFeatureResult);
            }
            return defaultValueFeatureResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return emptyFeature;
        }
    }

    @Nullable
    private <ValueType> ValueType evaluateForcedFeatureValueFromUrl(String key, @Nullable String urlString, Class<ValueType> valueTypeClass) {
        if (urlString == null) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            if (valueTypeClass.equals(Boolean.class)) {
                return (ValueType)GrowthBookUtils.getForcedBooleanValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(String.class)) {
                return (ValueType)GrowthBookUtils.getForcedStringValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Integer.class)) {
                return (ValueType)GrowthBookUtils.getForcedIntegerValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Float.class)) {
                return (ValueType)GrowthBookUtils.getForcedFloatValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Double.class)) {
                return (ValueType)GrowthBookUtils.getForcedDoubleValueFromUrl(key, url);
            }
            return GrowthBookUtils.getForcedSerializableValueFromUrl(key, url, valueTypeClass, this.jsonUtils.gson);
        }
        catch (ClassCastException | MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void goOutFromCircularLoop() {
        this.featureEvalContext.setId(null);
        this.featureEvalContext.getEvaluatedFeatures().clear();
    }
}

