/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.repository;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

public class LruETagCache {
    private final Cache<String, String> cache;

    public LruETagCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).build();
    }

    public String get(String url) {
        return (String)this.cache.getIfPresent((Object)url);
    }

    public void put(String url, String eTag) {
        if (eTag != null) {
            this.cache.put((Object)url, (Object)eTag);
        } else {
            this.cache.invalidate((Object)url);
        }
    }

    public void remove(String url) {
        this.cache.invalidate((Object)url);
    }

    public long size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

