/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.evaluators;

import com.google.gson.JsonObject;
import growthbook.sdk.java.evaluators.ConditionEvaluator;
import growthbook.sdk.java.evaluators.FeatureEvaluator;
import growthbook.sdk.java.evaluators.IExperimentEvaluator;
import growthbook.sdk.java.model.BucketRange;
import growthbook.sdk.java.model.Experiment;
import growthbook.sdk.java.model.ExperimentResult;
import growthbook.sdk.java.model.FeatureResult;
import growthbook.sdk.java.model.FeatureResultSource;
import growthbook.sdk.java.model.Filter;
import growthbook.sdk.java.model.GeneratedStickyBucketAssignmentDocModel;
import growthbook.sdk.java.model.HashAttributeAndHashValue;
import growthbook.sdk.java.model.Namespace;
import growthbook.sdk.java.model.ParentCondition;
import growthbook.sdk.java.model.StickyAssignmentsDocument;
import growthbook.sdk.java.model.StickyBucketVariation;
import growthbook.sdk.java.model.VariationMeta;
import growthbook.sdk.java.multiusermode.ExperimentTracker;
import growthbook.sdk.java.multiusermode.configurations.EvaluationContext;
import growthbook.sdk.java.multiusermode.usage.TrackingCallbackWithUser;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import growthbook.sdk.java.util.GrowthBookUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentEvaluator
implements IExperimentEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExperimentEvaluator.class);
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private final ExperimentTracker experimentTracker = new ExperimentTracker();

    @Override
    public <ValueType> ExperimentResult<ValueType> evaluateExperiment(Experiment<ValueType> experiment, EvaluationContext context, @Nullable String featureId) {
        TrackingCallbackWithUser trackingCallBackWithUser;
        Float hash;
        Integer hashVersion;
        String seed;
        HashAttributeAndHashValue hashAttribute;
        Integer forcedVariation;
        Boolean isEnabled;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (!(isEnabled = Optional.ofNullable(context.getOptions().getEnabled()).orElse(Boolean.FALSE)).booleanValue() || experimentVariations.size() < 2) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
        }
        Integer override = GrowthBookUtils.getQueryStringOverride(experiment.getKey(), context.getOptions().getUrl(), (Integer)experimentVariations.size());
        if (override != null) {
            return this.getExperimentResult(context, experiment, override, false, featureId, null, null);
        }
        Map<String, Integer> forcedVariations = this.getForcedVariations(context);
        if (forcedVariations == null) {
            forcedVariations = new HashMap<String, Integer>();
        }
        if ((forcedVariation = forcedVariations.get(experiment.getKey())) != null) {
            return this.getExperimentResult(context, experiment, forcedVariation, false, featureId, null, null);
        }
        if (experiment.getIsActive() != null && !experiment.getIsActive().booleanValue()) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
        }
        String fallBack = null;
        if (this.isStickyBucketingEnabledForExperiment(context, experiment)) {
            fallBack = experiment.getFallbackAttribute();
        }
        if ((hashAttribute = GrowthBookUtils.getHashAttribute(experiment.getHashAttribute(), fallBack, context.getUser().getAttributes())).getHashValue().isEmpty() || hashAttribute.getHashValue().equals("null")) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
        }
        int assigned = -1;
        boolean foundStickyBucket = false;
        boolean stickyBucketVersionIsBlocked = false;
        if (this.isStickyBucketingEnabledForExperiment(context, experiment)) {
            int bucketVersion = experiment.getBucketVersion() != null ? experiment.getBucketVersion() : 0;
            int minBucketVersion = experiment.getMinBucketVersion() != null ? experiment.getMinBucketVersion() : 0;
            ArrayList<VariationMeta> meta = experiment.getMeta() != null ? experiment.getMeta() : new ArrayList<VariationMeta>();
            StickyBucketVariation stickyBucketVariation = GrowthBookUtils.getStickyBucketVariation(context, experiment.getKey(), experiment.getHashAttribute(), experiment.getFallbackAttribute(), bucketVersion, minBucketVersion, meta);
            foundStickyBucket = stickyBucketVariation.getVariation() >= 0;
            assigned = stickyBucketVariation.getVariation();
            stickyBucketVersionIsBlocked = Boolean.TRUE.equals(stickyBucketVariation.getVersionIsBlocked());
        }
        if (!foundStickyBucket) {
            Boolean shouldEvaluate;
            Boolean isInNamespace;
            ArrayList<Filter> filters = experiment.getFilters();
            Namespace namespace = experiment.getNamespace();
            if (filters != null ? GrowthBookUtils.isFilteredOut(filters, context.getUser().getAttributes()) != false : namespace != null && (isInNamespace = GrowthBookUtils.inNameSpace(hashAttribute.getHashValue(), namespace)) == false) {
                return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
            }
            JsonObject conditionJson = experiment.getConditionJson();
            if (conditionJson != null && !(shouldEvaluate = this.conditionEvaluator.evaluateCondition(context.getUser().getAttributes(), conditionJson, context.getGlobal().getSavedGroups())).booleanValue()) {
                return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
            }
            ArrayList<ParentCondition> parenConditions = experiment.getParentConditions();
            if (parenConditions != null) {
                HashSet<String> evaluatedFeatures = new HashSet<String>(context.getStack().getEvaluatedFeatures());
                for (ParentCondition parentCondition : parenConditions) {
                    JsonObject attributesJson;
                    boolean evalCondition;
                    context.getStack().setEvaluatedFeatures(new HashSet<String>(evaluatedFeatures));
                    FeatureResult parentResult = new FeatureEvaluator().evaluateFeature(parentCondition.getId(), context, null);
                    if (parentResult.getSource() != null && parentResult.getSource().equals((Object)FeatureResultSource.CYCLIC_PREREQUISITE)) {
                        return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
                    }
                    HashMap<String, Object> evalObj = new HashMap<String, Object>();
                    if (parentResult.getValue() != null) {
                        evalObj.put("value", parentResult.getValue());
                    }
                    if (evalCondition = this.conditionEvaluator.evaluateCondition(attributesJson = GrowthBookJsonUtils.getInstance().gson.toJsonTree(evalObj).getAsJsonObject(), parentCondition.getCondition(), context.getGlobal().getSavedGroups()).booleanValue()) continue;
                    log.info("Feature blocked by prerequisite");
                    return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
                }
            }
        }
        if ((seed = experiment.getSeed()) == null) {
            seed = experiment.getKey();
        }
        if ((hashVersion = experiment.getHashVersion()) == null) {
            hashVersion = 1;
        }
        if ((hash = GrowthBookUtils.hash(hashAttribute.getHashValue(), hashVersion, seed)) == null) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
        }
        if (!foundStickyBucket) {
            ArrayList<BucketRange> bucketRanges;
            Float coverage;
            ArrayList<Float> weights = experiment.getWeights();
            if (weights == null) {
                weights = GrowthBookUtils.getEqualWeights(experiment.getVariations().size());
            }
            if ((coverage = experiment.getCoverage()) == null) {
                coverage = Float.valueOf(1.0f);
            }
            if ((bucketRanges = experiment.getRanges()) == null) {
                bucketRanges = GrowthBookUtils.getBucketRanges(experiment.getVariations().size(), coverage, weights);
            }
            assigned = GrowthBookUtils.chooseVariation(hash, bucketRanges);
        }
        if (stickyBucketVersionIsBlocked) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, true);
        }
        if (assigned < 0) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
        }
        Integer force = experiment.getForce();
        if (force != null) {
            return this.getExperimentResult(context, experiment, force, false, featureId, null, null);
        }
        if (Boolean.TRUE.equals(context.getOptions().getIsQaMode())) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null);
        }
        ExperimentResult<ValueType> result = this.getExperimentResult(context, experiment, assigned, true, featureId, hash, foundStickyBucket);
        if (this.isStickyBucketingEnabledForExperiment(context, experiment)) {
            HashMap<String, String> assignments = new HashMap<String, String>();
            assignments.put(GrowthBookUtils.getStickyBucketExperimentKey(experiment.getKey(), experiment.getBucketVersion()), result.getKey());
            GeneratedStickyBucketAssignmentDocModel docModel = GrowthBookUtils.generateStickyBucketAssignmentDoc(context.getUser().getStickyBucketAssignmentDocs(), hashAttribute.getHashAttribute(), hashAttribute.getHashValue(), assignments);
            if (docModel.isChanged()) {
                if (context.getUser().getStickyBucketAssignmentDocs() == null) {
                    context.getUser().setStickyBucketAssignmentDocs(new HashMap<String, StickyAssignmentsDocument>());
                }
                context.getUser().getStickyBucketAssignmentDocs().put(docModel.getKey(), docModel.getStickyAssignmentsDocument());
                if (context.getOptions().getStickyBucketService() != null) {
                    context.getOptions().getStickyBucketService().saveAssignments(docModel.getStickyAssignmentsDocument());
                }
            }
        }
        if (!this.isExperimentTracked(experiment, result) && (trackingCallBackWithUser = context.getOptions().getTrackingCallBackWithUser()) != null) {
            trackingCallBackWithUser.onTrack(experiment, result, context.getUser());
        }
        return result;
    }

    private <ValueType> ExperimentResult<ValueType> getExperimentResult(EvaluationContext context, Experiment<ValueType> experiment, Integer variationIndex, Boolean hashUsed, String featureId, @Nullable Float hashBucket, @Nullable Boolean stickyBucketUsed) {
        boolean inExperiment = true;
        Integer targetVariationIndex = variationIndex;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (targetVariationIndex < 0 || targetVariationIndex >= experimentVariations.size()) {
            targetVariationIndex = 0;
            inExperiment = false;
        }
        String fallBack = null;
        if (this.isStickyBucketingEnabledForExperiment(context, experiment)) {
            fallBack = experiment.getFallbackAttribute();
        }
        HashAttributeAndHashValue hashAttribute = GrowthBookUtils.getHashAttribute(experiment.getHashAttribute(), fallBack, context.getUser().getAttributes());
        ArrayList<Object> experimentMeta = new ArrayList();
        if (experiment.getMeta() != null) {
            experimentMeta = experiment.getMeta();
        }
        VariationMeta meta = null;
        if (experimentMeta.size() > targetVariationIndex) {
            meta = (VariationMeta)experimentMeta.get(targetVariationIndex);
        }
        String key = meta != null ? meta.getKey() : targetVariationIndex + "";
        String name = meta != null ? meta.getName() : null;
        Boolean passThrough = meta != null ? meta.getPassThrough() : null;
        Object targetValue = null;
        if (experiment.getVariations().size() > targetVariationIndex) {
            targetValue = experiment.getVariations().get(targetVariationIndex);
        }
        return ExperimentResult.builder().inExperiment(inExperiment).variationId(variationIndex).value(targetValue).hashAttribute(hashAttribute.getHashAttribute()).hashValue(hashAttribute.getHashValue()).key(key).featureId(featureId).hashUsed(hashUsed).stickyBucketUsed(stickyBucketUsed != null ? stickyBucketUsed : false).name(name).bucket(hashBucket).passThrough(passThrough).build();
    }

    private <ValueType> boolean isExperimentTracked(Experiment<ValueType> experiment, ExperimentResult<ValueType> result) {
        String experimentKey = experiment.getKey();
        String key = (result.getHashAttribute() != null ? result.getHashAttribute() : "") + (result.getHashValue() != null ? result.getHashValue() : "") + experimentKey + result.getVariationId();
        if (!this.experimentTracker.isExperimentTracked(key)) {
            this.experimentTracker.trackExperiment(key);
        }
        return false;
    }

    private <ValueType> boolean isStickyBucketingEnabledForExperiment(EvaluationContext context, Experiment<ValueType> experiment) {
        return context.getOptions().getStickyBucketService() != null && !Boolean.TRUE.equals(experiment.getDisableStickyBucketing());
    }

    private Map<String, Integer> getForcedVariations(EvaluationContext evaluationContext) {
        Map globalForcedVariations = evaluationContext.getGlobal() != null ? evaluationContext.getGlobal().getForcedVariations() : Collections.emptyMap();
        Map userForcedVariations = evaluationContext.getUser() != null ? evaluationContext.getUser().getForcedVariationsMap() : Collections.emptyMap();
        return GrowthBookUtils.mergeMaps(Arrays.asList(globalForcedVariations, userForcedVariations));
    }
}

