/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.sandbox;

import growthbook.sdk.java.sandbox.CacheMode;
import growthbook.sdk.java.sandbox.FileCachingManagerImpl;
import growthbook.sdk.java.sandbox.GbCacheManager;
import growthbook.sdk.java.sandbox.InMemoryCachingManagerImpl;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(CacheManagerFactory.class);

    public static GbCacheManager create(CacheMode mode, String explicitCacheDirOrNull) {
        if (mode == CacheMode.NONE) {
            return null;
        }
        if (mode == CacheMode.MEMORY) {
            return new InMemoryCachingManagerImpl();
        }
        if (mode == CacheMode.FILE) {
            FileCachingManagerImpl fileManager = CacheManagerFactory.tryCreateFileManager(explicitCacheDirOrNull);
            if (fileManager != null) {
                return fileManager;
            }
            log.warn("CacheMode.FILE requested but directory is not usable. Falling back to MEMORY.");
            return new InMemoryCachingManagerImpl();
        }
        FileCachingManagerImpl fileManager = CacheManagerFactory.tryCreateFileManager(explicitCacheDirOrNull);
        if (fileManager != null) {
            return fileManager;
        }
        return new InMemoryCachingManagerImpl();
    }

    private static FileCachingManagerImpl tryCreateFileManager(String explicitDir) {
        String resolved = CacheManagerFactory.resolveWritableDir(explicitDir);
        if (resolved == null) {
            return null;
        }
        try {
            return new FileCachingManagerImpl(resolved);
        }
        catch (RuntimeException ex) {
            log.warn("Failed to initialize file cache at {}: {}", (Object)resolved, (Object)ex.getMessage());
            return null;
        }
    }

    private static String resolveWritableDir(String explicitDir) {
        String p;
        String win;
        String mac;
        String p2;
        if (CacheManagerFactory.isWritableDir(explicitDir)) {
            return explicitDir;
        }
        String fromSysProp = System.getProperty("growthbook.cache.dir");
        if (CacheManagerFactory.isWritableDir(fromSysProp)) {
            return fromSysProp;
        }
        String xdg = System.getenv("XDG_CACHE_HOME");
        if (xdg != null && CacheManagerFactory.isWritableDir(p2 = Paths.get(xdg, "growthbook").toString())) {
            return p2;
        }
        String userHome = System.getProperty("user.home");
        if (userHome != null && CacheManagerFactory.isWritableDir(mac = Paths.get(userHome, "Library", "Caches", "growthbook").toString())) {
            return mac;
        }
        String localApp = System.getenv("LOCALAPPDATA");
        if (localApp != null && CacheManagerFactory.isWritableDir(win = Paths.get(localApp, "GrowthBook").toString())) {
            return win;
        }
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp != null && CacheManagerFactory.isWritableDir(p = Paths.get(tmp, "growthbook-cache").toString())) {
            return p;
        }
        return null;
    }

    private static boolean isWritableDir(String dir) {
        if (dir == null || dir.isEmpty()) {
            return false;
        }
        Path path = Paths.get(dir, new String[0]);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path);
        }
        catch (Exception e) {
            return false;
        }
    }
}

