/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.multiusermode.configurations;

import com.google.gson.JsonObject;
import growthbook.sdk.java.callback.FeatureRefreshCallback;
import growthbook.sdk.java.model.StickyAssignmentsDocument;
import growthbook.sdk.java.multiusermode.usage.FeatureUsageCallbackWithUser;
import growthbook.sdk.java.multiusermode.usage.TrackingCallbackWithUser;
import growthbook.sdk.java.multiusermode.util.TransformationUtil;
import growthbook.sdk.java.repository.FeatureRefreshStrategy;
import growthbook.sdk.java.sandbox.CacheMode;
import growthbook.sdk.java.sandbox.GbCacheManager;
import growthbook.sdk.java.stickyBucketing.InMemoryStickyBucketServiceImpl;
import growthbook.sdk.java.stickyBucketing.StickyBucketService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Options {
    private static final Logger log = LoggerFactory.getLogger(Options.class);
    @Nullable
    private Boolean enabled;
    private Boolean isQaMode;
    private Boolean isCacheDisabled;
    private Boolean allowUrlOverrides;
    @Nullable
    private String url;
    @Nullable
    private String apiHost;
    @Nullable
    private String clientKey;
    @Nullable
    private String decryptionKey;
    @Nullable
    private List<String> stickyBucketIdentifierAttributes;
    @Nullable
    private StickyBucketService stickyBucketService;
    @Nullable
    private TrackingCallbackWithUser trackingCallBackWithUser;
    @Nullable
    private FeatureUsageCallbackWithUser featureUsageCallbackWithUser;
    @Nullable
    private FeatureRefreshStrategy refreshStrategy;
    @Nullable
    private JsonObject globalAttributes;
    @Nullable
    private String attributesJson;
    @Nullable
    private Map<String, Object> globalForcedFeatureValues;
    @Nullable
    private Map<String, Integer> globalForcedVariationsMap;
    @Nullable
    private FeatureRefreshCallback featureRefreshCallback;
    @Nullable
    private GbCacheManager cacheManager;
    private CacheMode cacheMode;
    @Nullable
    private String cacheDirectory;

    public Options(@Nullable Boolean enabled, Boolean isQaMode, @Nullable Boolean isCacheDisabled, Boolean allowUrlOverrides, @Nullable String url, @Nullable String apiHost, @Nullable String clientKey, @Nullable String decryptionKey, @Nullable List<String> stickyBucketIdentifierAttributes, @Nullable StickyBucketService stickyBucketService, @Nullable TrackingCallbackWithUser trackingCallBackWithUser, @Nullable FeatureUsageCallbackWithUser featureUsageCallbackWithUser, @Nullable FeatureRefreshStrategy refreshStrategy, @Nullable FeatureRefreshCallback featureRefreshCallback, @Nullable JsonObject globalAttributes, @Nullable Map<String, Object> globalForcedFeatureValues, @Nullable Map<String, Integer> globalForcedVariationsMap, @Nullable GbCacheManager cacheManager, @Nullable CacheMode cacheMode, @Nullable String cacheDirectory) {
        this.enabled = enabled == null || enabled != false;
        this.isQaMode = isQaMode != null && isQaMode != false;
        this.isCacheDisabled = isCacheDisabled != null && isCacheDisabled != false;
        this.allowUrlOverrides = allowUrlOverrides != null && allowUrlOverrides != false;
        this.url = url;
        this.apiHost = apiHost;
        this.clientKey = clientKey;
        this.decryptionKey = decryptionKey;
        this.stickyBucketIdentifierAttributes = stickyBucketIdentifierAttributes;
        this.stickyBucketService = stickyBucketService;
        this.trackingCallBackWithUser = trackingCallBackWithUser;
        this.featureUsageCallbackWithUser = featureUsageCallbackWithUser;
        this.refreshStrategy = refreshStrategy;
        this.featureRefreshCallback = featureRefreshCallback;
        this.globalAttributes = globalAttributes;
        this.globalForcedFeatureValues = globalForcedFeatureValues;
        this.globalForcedVariationsMap = globalForcedVariationsMap;
        this.cacheManager = cacheManager;
        this.cacheMode = cacheMode == null ? CacheMode.AUTO : cacheMode;
        this.cacheDirectory = cacheDirectory;
    }

    public FeatureRefreshStrategy getRefreshingStrategy() {
        if (this.refreshStrategy == null) {
            return FeatureRefreshStrategy.STALE_WHILE_REVALIDATE;
        }
        return this.refreshStrategy;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode == null ? CacheMode.AUTO : this.cacheMode;
    }

    @Nullable
    public String getCacheDirectory() {
        return this.cacheDirectory;
    }

    @Nullable
    public StickyBucketService getStickyBucketService() {
        return this.stickyBucketService;
    }

    public void setInMemoryStickyBucketService() {
        this.setStickyBucketService(new InMemoryStickyBucketServiceImpl(new HashMap<String, StickyAssignmentsDocument>()));
    }

    public void setGlobalAttributes(@Nullable String attributesJson) {
        this.attributesJson = attributesJson;
        this.globalAttributes = TransformationUtil.transformAttributes(attributesJson);
    }

    public static OptionsBuilder builder() {
        return new OptionsBuilder();
    }

    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getIsQaMode() {
        return this.isQaMode;
    }

    public Boolean getIsCacheDisabled() {
        return this.isCacheDisabled;
    }

    public Boolean getAllowUrlOverrides() {
        return this.allowUrlOverrides;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getApiHost() {
        return this.apiHost;
    }

    @Nullable
    public String getClientKey() {
        return this.clientKey;
    }

    @Nullable
    public String getDecryptionKey() {
        return this.decryptionKey;
    }

    @Nullable
    public List<String> getStickyBucketIdentifierAttributes() {
        return this.stickyBucketIdentifierAttributes;
    }

    @Nullable
    public TrackingCallbackWithUser getTrackingCallBackWithUser() {
        return this.trackingCallBackWithUser;
    }

    @Nullable
    public FeatureUsageCallbackWithUser getFeatureUsageCallbackWithUser() {
        return this.featureUsageCallbackWithUser;
    }

    @Nullable
    public FeatureRefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    @Nullable
    public JsonObject getGlobalAttributes() {
        return this.globalAttributes;
    }

    @Nullable
    public String getAttributesJson() {
        return this.attributesJson;
    }

    @Nullable
    public Map<String, Object> getGlobalForcedFeatureValues() {
        return this.globalForcedFeatureValues;
    }

    @Nullable
    public Map<String, Integer> getGlobalForcedVariationsMap() {
        return this.globalForcedVariationsMap;
    }

    @Nullable
    public FeatureRefreshCallback getFeatureRefreshCallback() {
        return this.featureRefreshCallback;
    }

    @Nullable
    public GbCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
    }

    public void setIsQaMode(Boolean isQaMode) {
        this.isQaMode = isQaMode;
    }

    public void setIsCacheDisabled(Boolean isCacheDisabled) {
        this.isCacheDisabled = isCacheDisabled;
    }

    public void setAllowUrlOverrides(Boolean allowUrlOverrides) {
        this.allowUrlOverrides = allowUrlOverrides;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public void setApiHost(@Nullable String apiHost) {
        this.apiHost = apiHost;
    }

    public void setClientKey(@Nullable String clientKey) {
        this.clientKey = clientKey;
    }

    public void setDecryptionKey(@Nullable String decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    public void setStickyBucketIdentifierAttributes(@Nullable List<String> stickyBucketIdentifierAttributes) {
        this.stickyBucketIdentifierAttributes = stickyBucketIdentifierAttributes;
    }

    public void setStickyBucketService(@Nullable StickyBucketService stickyBucketService) {
        this.stickyBucketService = stickyBucketService;
    }

    public void setTrackingCallBackWithUser(@Nullable TrackingCallbackWithUser trackingCallBackWithUser) {
        this.trackingCallBackWithUser = trackingCallBackWithUser;
    }

    public void setFeatureUsageCallbackWithUser(@Nullable FeatureUsageCallbackWithUser featureUsageCallbackWithUser) {
        this.featureUsageCallbackWithUser = featureUsageCallbackWithUser;
    }

    public void setRefreshStrategy(@Nullable FeatureRefreshStrategy refreshStrategy) {
        this.refreshStrategy = refreshStrategy;
    }

    public void setAttributesJson(@Nullable String attributesJson) {
        this.attributesJson = attributesJson;
    }

    public void setGlobalForcedFeatureValues(@Nullable Map<String, Object> globalForcedFeatureValues) {
        this.globalForcedFeatureValues = globalForcedFeatureValues;
    }

    public void setGlobalForcedVariationsMap(@Nullable Map<String, Integer> globalForcedVariationsMap) {
        this.globalForcedVariationsMap = globalForcedVariationsMap;
    }

    public void setFeatureRefreshCallback(@Nullable FeatureRefreshCallback featureRefreshCallback) {
        this.featureRefreshCallback = featureRefreshCallback;
    }

    public void setCacheManager(@Nullable GbCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public void setCacheDirectory(@Nullable String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Options)) {
            return false;
        }
        Options other = (Options)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$isQaMode = this.getIsQaMode();
        Boolean other$isQaMode = other.getIsQaMode();
        if (this$isQaMode == null ? other$isQaMode != null : !((Object)this$isQaMode).equals(other$isQaMode)) {
            return false;
        }
        Boolean this$isCacheDisabled = this.getIsCacheDisabled();
        Boolean other$isCacheDisabled = other.getIsCacheDisabled();
        if (this$isCacheDisabled == null ? other$isCacheDisabled != null : !((Object)this$isCacheDisabled).equals(other$isCacheDisabled)) {
            return false;
        }
        Boolean this$allowUrlOverrides = this.getAllowUrlOverrides();
        Boolean other$allowUrlOverrides = other.getAllowUrlOverrides();
        if (this$allowUrlOverrides == null ? other$allowUrlOverrides != null : !((Object)this$allowUrlOverrides).equals(other$allowUrlOverrides)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$apiHost = this.getApiHost();
        String other$apiHost = other.getApiHost();
        if (this$apiHost == null ? other$apiHost != null : !this$apiHost.equals(other$apiHost)) {
            return false;
        }
        String this$clientKey = this.getClientKey();
        String other$clientKey = other.getClientKey();
        if (this$clientKey == null ? other$clientKey != null : !this$clientKey.equals(other$clientKey)) {
            return false;
        }
        String this$decryptionKey = this.getDecryptionKey();
        String other$decryptionKey = other.getDecryptionKey();
        if (this$decryptionKey == null ? other$decryptionKey != null : !this$decryptionKey.equals(other$decryptionKey)) {
            return false;
        }
        List<String> this$stickyBucketIdentifierAttributes = this.getStickyBucketIdentifierAttributes();
        List<String> other$stickyBucketIdentifierAttributes = other.getStickyBucketIdentifierAttributes();
        if (this$stickyBucketIdentifierAttributes == null ? other$stickyBucketIdentifierAttributes != null : !((Object)this$stickyBucketIdentifierAttributes).equals(other$stickyBucketIdentifierAttributes)) {
            return false;
        }
        StickyBucketService this$stickyBucketService = this.getStickyBucketService();
        StickyBucketService other$stickyBucketService = other.getStickyBucketService();
        if (this$stickyBucketService == null ? other$stickyBucketService != null : !this$stickyBucketService.equals(other$stickyBucketService)) {
            return false;
        }
        TrackingCallbackWithUser this$trackingCallBackWithUser = this.getTrackingCallBackWithUser();
        TrackingCallbackWithUser other$trackingCallBackWithUser = other.getTrackingCallBackWithUser();
        if (this$trackingCallBackWithUser == null ? other$trackingCallBackWithUser != null : !this$trackingCallBackWithUser.equals(other$trackingCallBackWithUser)) {
            return false;
        }
        FeatureUsageCallbackWithUser this$featureUsageCallbackWithUser = this.getFeatureUsageCallbackWithUser();
        FeatureUsageCallbackWithUser other$featureUsageCallbackWithUser = other.getFeatureUsageCallbackWithUser();
        if (this$featureUsageCallbackWithUser == null ? other$featureUsageCallbackWithUser != null : !this$featureUsageCallbackWithUser.equals(other$featureUsageCallbackWithUser)) {
            return false;
        }
        FeatureRefreshStrategy this$refreshStrategy = this.getRefreshStrategy();
        FeatureRefreshStrategy other$refreshStrategy = other.getRefreshStrategy();
        if (this$refreshStrategy == null ? other$refreshStrategy != null : !((Object)((Object)this$refreshStrategy)).equals((Object)other$refreshStrategy)) {
            return false;
        }
        JsonObject this$globalAttributes = this.getGlobalAttributes();
        JsonObject other$globalAttributes = other.getGlobalAttributes();
        if (this$globalAttributes == null ? other$globalAttributes != null : !this$globalAttributes.equals(other$globalAttributes)) {
            return false;
        }
        String this$attributesJson = this.getAttributesJson();
        String other$attributesJson = other.getAttributesJson();
        if (this$attributesJson == null ? other$attributesJson != null : !this$attributesJson.equals(other$attributesJson)) {
            return false;
        }
        Map<String, Object> this$globalForcedFeatureValues = this.getGlobalForcedFeatureValues();
        Map<String, Object> other$globalForcedFeatureValues = other.getGlobalForcedFeatureValues();
        if (this$globalForcedFeatureValues == null ? other$globalForcedFeatureValues != null : !((Object)this$globalForcedFeatureValues).equals(other$globalForcedFeatureValues)) {
            return false;
        }
        Map<String, Integer> this$globalForcedVariationsMap = this.getGlobalForcedVariationsMap();
        Map<String, Integer> other$globalForcedVariationsMap = other.getGlobalForcedVariationsMap();
        if (this$globalForcedVariationsMap == null ? other$globalForcedVariationsMap != null : !((Object)this$globalForcedVariationsMap).equals(other$globalForcedVariationsMap)) {
            return false;
        }
        FeatureRefreshCallback this$featureRefreshCallback = this.getFeatureRefreshCallback();
        FeatureRefreshCallback other$featureRefreshCallback = other.getFeatureRefreshCallback();
        if (this$featureRefreshCallback == null ? other$featureRefreshCallback != null : !this$featureRefreshCallback.equals(other$featureRefreshCallback)) {
            return false;
        }
        GbCacheManager this$cacheManager = this.getCacheManager();
        GbCacheManager other$cacheManager = other.getCacheManager();
        if (this$cacheManager == null ? other$cacheManager != null : !this$cacheManager.equals(other$cacheManager)) {
            return false;
        }
        CacheMode this$cacheMode = this.getCacheMode();
        CacheMode other$cacheMode = other.getCacheMode();
        if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
            return false;
        }
        String this$cacheDirectory = this.getCacheDirectory();
        String other$cacheDirectory = other.getCacheDirectory();
        return !(this$cacheDirectory == null ? other$cacheDirectory != null : !this$cacheDirectory.equals(other$cacheDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Options;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $isQaMode = this.getIsQaMode();
        result = result * 59 + ($isQaMode == null ? 43 : ((Object)$isQaMode).hashCode());
        Boolean $isCacheDisabled = this.getIsCacheDisabled();
        result = result * 59 + ($isCacheDisabled == null ? 43 : ((Object)$isCacheDisabled).hashCode());
        Boolean $allowUrlOverrides = this.getAllowUrlOverrides();
        result = result * 59 + ($allowUrlOverrides == null ? 43 : ((Object)$allowUrlOverrides).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $apiHost = this.getApiHost();
        result = result * 59 + ($apiHost == null ? 43 : $apiHost.hashCode());
        String $clientKey = this.getClientKey();
        result = result * 59 + ($clientKey == null ? 43 : $clientKey.hashCode());
        String $decryptionKey = this.getDecryptionKey();
        result = result * 59 + ($decryptionKey == null ? 43 : $decryptionKey.hashCode());
        List<String> $stickyBucketIdentifierAttributes = this.getStickyBucketIdentifierAttributes();
        result = result * 59 + ($stickyBucketIdentifierAttributes == null ? 43 : ((Object)$stickyBucketIdentifierAttributes).hashCode());
        StickyBucketService $stickyBucketService = this.getStickyBucketService();
        result = result * 59 + ($stickyBucketService == null ? 43 : $stickyBucketService.hashCode());
        TrackingCallbackWithUser $trackingCallBackWithUser = this.getTrackingCallBackWithUser();
        result = result * 59 + ($trackingCallBackWithUser == null ? 43 : $trackingCallBackWithUser.hashCode());
        FeatureUsageCallbackWithUser $featureUsageCallbackWithUser = this.getFeatureUsageCallbackWithUser();
        result = result * 59 + ($featureUsageCallbackWithUser == null ? 43 : $featureUsageCallbackWithUser.hashCode());
        FeatureRefreshStrategy $refreshStrategy = this.getRefreshStrategy();
        result = result * 59 + ($refreshStrategy == null ? 43 : ((Object)((Object)$refreshStrategy)).hashCode());
        JsonObject $globalAttributes = this.getGlobalAttributes();
        result = result * 59 + ($globalAttributes == null ? 43 : $globalAttributes.hashCode());
        String $attributesJson = this.getAttributesJson();
        result = result * 59 + ($attributesJson == null ? 43 : $attributesJson.hashCode());
        Map<String, Object> $globalForcedFeatureValues = this.getGlobalForcedFeatureValues();
        result = result * 59 + ($globalForcedFeatureValues == null ? 43 : ((Object)$globalForcedFeatureValues).hashCode());
        Map<String, Integer> $globalForcedVariationsMap = this.getGlobalForcedVariationsMap();
        result = result * 59 + ($globalForcedVariationsMap == null ? 43 : ((Object)$globalForcedVariationsMap).hashCode());
        FeatureRefreshCallback $featureRefreshCallback = this.getFeatureRefreshCallback();
        result = result * 59 + ($featureRefreshCallback == null ? 43 : $featureRefreshCallback.hashCode());
        GbCacheManager $cacheManager = this.getCacheManager();
        result = result * 59 + ($cacheManager == null ? 43 : $cacheManager.hashCode());
        CacheMode $cacheMode = this.getCacheMode();
        result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
        String $cacheDirectory = this.getCacheDirectory();
        result = result * 59 + ($cacheDirectory == null ? 43 : $cacheDirectory.hashCode());
        return result;
    }

    public String toString() {
        return "Options(enabled=" + this.getEnabled() + ", isQaMode=" + this.getIsQaMode() + ", isCacheDisabled=" + this.getIsCacheDisabled() + ", allowUrlOverrides=" + this.getAllowUrlOverrides() + ", url=" + this.getUrl() + ", apiHost=" + this.getApiHost() + ", clientKey=" + this.getClientKey() + ", decryptionKey=" + this.getDecryptionKey() + ", stickyBucketIdentifierAttributes=" + this.getStickyBucketIdentifierAttributes() + ", stickyBucketService=" + this.getStickyBucketService() + ", trackingCallBackWithUser=" + this.getTrackingCallBackWithUser() + ", featureUsageCallbackWithUser=" + this.getFeatureUsageCallbackWithUser() + ", refreshStrategy=" + (Object)((Object)this.getRefreshStrategy()) + ", globalAttributes=" + this.getGlobalAttributes() + ", attributesJson=" + this.getAttributesJson() + ", globalForcedFeatureValues=" + this.getGlobalForcedFeatureValues() + ", globalForcedVariationsMap=" + this.getGlobalForcedVariationsMap() + ", featureRefreshCallback=" + this.getFeatureRefreshCallback() + ", cacheManager=" + this.getCacheManager() + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ", cacheDirectory=" + this.getCacheDirectory() + ")";
    }

    public static class OptionsBuilder {
        private Boolean enabled;
        private Boolean isQaMode;
        private Boolean isCacheDisabled;
        private Boolean allowUrlOverrides;
        private String url;
        private String apiHost;
        private String clientKey;
        private String decryptionKey;
        private List<String> stickyBucketIdentifierAttributes;
        private StickyBucketService stickyBucketService;
        private TrackingCallbackWithUser trackingCallBackWithUser;
        private FeatureUsageCallbackWithUser featureUsageCallbackWithUser;
        private FeatureRefreshStrategy refreshStrategy;
        private FeatureRefreshCallback featureRefreshCallback;
        private JsonObject globalAttributes;
        private Map<String, Object> globalForcedFeatureValues;
        private Map<String, Integer> globalForcedVariationsMap;
        private GbCacheManager cacheManager;
        private CacheMode cacheMode;
        private String cacheDirectory;

        OptionsBuilder() {
        }

        public OptionsBuilder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OptionsBuilder isQaMode(Boolean isQaMode) {
            this.isQaMode = isQaMode;
            return this;
        }

        public OptionsBuilder isCacheDisabled(@Nullable Boolean isCacheDisabled) {
            this.isCacheDisabled = isCacheDisabled;
            return this;
        }

        public OptionsBuilder allowUrlOverrides(Boolean allowUrlOverrides) {
            this.allowUrlOverrides = allowUrlOverrides;
            return this;
        }

        public OptionsBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public OptionsBuilder apiHost(@Nullable String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public OptionsBuilder clientKey(@Nullable String clientKey) {
            this.clientKey = clientKey;
            return this;
        }

        public OptionsBuilder decryptionKey(@Nullable String decryptionKey) {
            this.decryptionKey = decryptionKey;
            return this;
        }

        public OptionsBuilder stickyBucketIdentifierAttributes(@Nullable List<String> stickyBucketIdentifierAttributes) {
            this.stickyBucketIdentifierAttributes = stickyBucketIdentifierAttributes;
            return this;
        }

        public OptionsBuilder stickyBucketService(@Nullable StickyBucketService stickyBucketService) {
            this.stickyBucketService = stickyBucketService;
            return this;
        }

        public OptionsBuilder trackingCallBackWithUser(@Nullable TrackingCallbackWithUser trackingCallBackWithUser) {
            this.trackingCallBackWithUser = trackingCallBackWithUser;
            return this;
        }

        public OptionsBuilder featureUsageCallbackWithUser(@Nullable FeatureUsageCallbackWithUser featureUsageCallbackWithUser) {
            this.featureUsageCallbackWithUser = featureUsageCallbackWithUser;
            return this;
        }

        public OptionsBuilder refreshStrategy(@Nullable FeatureRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        public OptionsBuilder featureRefreshCallback(@Nullable FeatureRefreshCallback featureRefreshCallback) {
            this.featureRefreshCallback = featureRefreshCallback;
            return this;
        }

        public OptionsBuilder globalAttributes(@Nullable JsonObject globalAttributes) {
            this.globalAttributes = globalAttributes;
            return this;
        }

        public OptionsBuilder globalForcedFeatureValues(@Nullable Map<String, Object> globalForcedFeatureValues) {
            this.globalForcedFeatureValues = globalForcedFeatureValues;
            return this;
        }

        public OptionsBuilder globalForcedVariationsMap(@Nullable Map<String, Integer> globalForcedVariationsMap) {
            this.globalForcedVariationsMap = globalForcedVariationsMap;
            return this;
        }

        public OptionsBuilder cacheManager(@Nullable GbCacheManager cacheManager) {
            this.cacheManager = cacheManager;
            return this;
        }

        public OptionsBuilder cacheMode(@Nullable CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this;
        }

        public OptionsBuilder cacheDirectory(@Nullable String cacheDirectory) {
            this.cacheDirectory = cacheDirectory;
            return this;
        }

        public Options build() {
            return new Options(this.enabled, this.isQaMode, this.isCacheDisabled, this.allowUrlOverrides, this.url, this.apiHost, this.clientKey, this.decryptionKey, this.stickyBucketIdentifierAttributes, this.stickyBucketService, this.trackingCallBackWithUser, this.featureUsageCallbackWithUser, this.refreshStrategy, this.featureRefreshCallback, this.globalAttributes, this.globalForcedFeatureValues, this.globalForcedVariationsMap, this.cacheManager, this.cacheMode, this.cacheDirectory);
        }

        public String toString() {
            return "Options.OptionsBuilder(enabled=" + this.enabled + ", isQaMode=" + this.isQaMode + ", isCacheDisabled=" + this.isCacheDisabled + ", allowUrlOverrides=" + this.allowUrlOverrides + ", url=" + this.url + ", apiHost=" + this.apiHost + ", clientKey=" + this.clientKey + ", decryptionKey=" + this.decryptionKey + ", stickyBucketIdentifierAttributes=" + this.stickyBucketIdentifierAttributes + ", stickyBucketService=" + this.stickyBucketService + ", trackingCallBackWithUser=" + this.trackingCallBackWithUser + ", featureUsageCallbackWithUser=" + this.featureUsageCallbackWithUser + ", refreshStrategy=" + (Object)((Object)this.refreshStrategy) + ", featureRefreshCallback=" + this.featureRefreshCallback + ", globalAttributes=" + this.globalAttributes + ", globalForcedFeatureValues=" + this.globalForcedFeatureValues + ", globalForcedVariationsMap=" + this.globalForcedVariationsMap + ", cacheManager=" + this.cacheManager + ", cacheMode=" + (Object)((Object)this.cacheMode) + ", cacheDirectory=" + this.cacheDirectory + ")";
        }
    }
}

