/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.internal.services;

import java.math.BigInteger;
import java.util.List;

class MathUtils {
    private static final BigInteger INIT32 = new BigInteger("811c9dc5", 16);
    private static final BigInteger PRIME32 = new BigInteger("01000193", 16);
    private static final BigInteger MOD32 = new BigInteger("2").pow(32);

    MathUtils() {
    }

    public static BigInteger fnv1a_32(byte[] data) {
        BigInteger hash = INIT32;
        for (byte b : data) {
            hash = hash.xor(BigInteger.valueOf(b & 0xFF));
            hash = hash.multiply(PRIME32).mod(MOD32);
        }
        return hash;
    }

    public static float clamp(float value, float lowerRange, float upperRange) {
        if (value > upperRange) {
            return upperRange;
        }
        if (value < lowerRange) {
            return lowerRange;
        }
        return value;
    }

    public static float sum(List<Float> items) {
        float total = 0.0f;
        for (float item : items) {
            total += item;
        }
        return total;
    }
}

