/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.player.util;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import net.pubnative.player.util.HttpTools;

public class CacheManager {
    static String TAG = CacheManager.class.getSimpleName();

    public static void put(Context context, String url, final CacheProgressListener listener) {
        block3: {
            File file = new File(context.getCacheDir(), String.valueOf(url.hashCode()));
            HttpTools.NetworkRequestListener networkListener = new HttpTools.NetworkRequestListener(){

                @Override
                public void onRequestSuccess() {
                    Log.d((String)TAG, (String)"Cache Request success");
                    listener.onCacheSuccess();
                }

                @Override
                public void onRequestFailed(Throwable t) {
                    Log.d((String)TAG, (String)"Cache Request failed", (Throwable)t);
                    listener.onCacheFailed(t);
                }
            };
            if (!file.exists()) {
                try {
                    file.createNewFile();
                    HttpTools.downloadFile(url, file, networkListener);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    listener.onCacheFailed(e);
                    if (!file.exists()) break block3;
                    file.delete();
                }
            }
        }
    }

    public static File get(Context context, String url) {
        File file = new File(context.getCacheDir(), String.valueOf(url.hashCode()));
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static boolean has(Context context, String url) {
        return CacheManager.get(context, url) != null;
    }

    public static interface CacheProgressListener {
        public void onCacheSuccess();

        public void onCacheFailed(Throwable var1);
    }
}

