/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.statusbarcompat.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.support.v4.graphics.ColorUtils;
import android.view.View;
import android.view.Window;
import per.goweii.statusbarcompat.StatusBarCompat;

public class LuminanceUtils {
    public static boolean isLight(double luminance) {
        return luminance >= 0.382;
    }

    public static double calcLuminance(int color) {
        return ColorUtils.calculateLuminance((int)color);
    }

    public static double calcLuminanceByCapture(Window window) {
        Bitmap bitmap = LuminanceUtils.captureStatusBar(window);
        double luminance = LuminanceUtils.calcBitmapLuminance(bitmap);
        bitmap.recycle();
        return luminance;
    }

    private static Bitmap captureStatusBar(Window window) {
        View decor = window.getDecorView();
        int w = decor.getMeasuredWidth();
        int h = StatusBarCompat.getHeight(window.getContext());
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        decor.draw(canvas);
        return bitmap;
    }

    private static double calcBitmapLuminance(Bitmap bitmap) {
        if (bitmap == null) {
            return 0.0;
        }
        if (bitmap.isRecycled()) {
            return 0.0;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (w == 0 || h == 0) {
            return 0.0;
        }
        int y_m = h / 2;
        int x_m = w / 2;
        int light = 0;
        int dark = 0;
        for (int x = 0; x < w; ++x) {
            float f = (float)x / (float)w;
            int y_t2b = (int)((float)h * f);
            int y_b2t = h - y_t2b - 1;
            if (LuminanceUtils.isLight(bitmap.getPixel(x, y_t2b))) {
                ++light;
            } else {
                ++dark;
            }
            if (LuminanceUtils.isLight(bitmap.getPixel(x, y_b2t))) {
                ++light;
            } else {
                ++dark;
            }
            if (LuminanceUtils.isLight(bitmap.getPixel(x, y_m))) {
                ++light;
            } else {
                ++dark;
            }
            if (x != x_m) continue;
            for (int y = 0; y < h; ++y) {
                if (LuminanceUtils.isLight(bitmap.getPixel(x, y))) {
                    ++light;
                    continue;
                }
                ++dark;
            }
        }
        return dark > light ? 0.0 : 1.0;
    }

    private static boolean isLight(int color) {
        return LuminanceUtils.isLight(LuminanceUtils.calcLuminance(color));
    }
}

