/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.statusbarcompat.compat;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import per.goweii.statusbarcompat.compat.OsCompat;
import per.goweii.statusbarcompat.utils.DarkModeUtils;

public class OsCompatFlyme
implements OsCompat {
    @Override
    public boolean isDarkIconMode(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return false;
        }
        return FlymeStatusBarUtils.isStatusBarDarkIcon((Activity)activity);
    }

    @Override
    public boolean isDarkIconMode(@NonNull Activity activity) {
        return FlymeStatusBarUtils.isStatusBarDarkIcon(activity);
    }

    @Override
    public boolean isDarkIconMode(@NonNull Window window) {
        return FlymeStatusBarUtils.isStatusBarDarkIcon(window);
    }

    @Override
    public void setDarkIconMode(@NonNull Fragment fragment, boolean darkIconMode) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        FlymeStatusBarUtils.setStatusBarDarkIcon((Activity)activity, darkIconMode);
    }

    @Override
    public void setDarkIconMode(@NonNull Activity activity, boolean darkIconMode) {
        FlymeStatusBarUtils.setStatusBarDarkIcon(activity, darkIconMode);
    }

    @Override
    public void setDarkIconMode(@NonNull Window window, boolean darkIconMode) {
        FlymeStatusBarUtils.setStatusBarDarkIcon(window, darkIconMode);
    }

    private static class FlymeStatusBarUtils {
        private FlymeStatusBarUtils() {
        }

        private static boolean isStatusBarDarkIcon(Activity activity) {
            return FlymeStatusBarUtils.isStatusBarDarkIcon(activity.getWindow());
        }

        private static void setStatusBarDarkIcon(Activity activity, boolean dark) {
            if (MethodHolder.mSetStatusBarDarkIcon != null) {
                try {
                    MethodHolder.mSetStatusBarDarkIcon.invoke((Object)activity, dark);
                }
                catch (Exception e) {
                    FlymeStatusBarUtils.setStatusBarDarkIcon(activity.getWindow(), dark);
                }
            } else {
                FlymeStatusBarUtils.setStatusBarDarkIcon(activity.getWindow(), dark);
            }
        }

        private static boolean isStatusBarDarkIcon(Window window) {
            if (Build.VERSION.SDK_INT >= 23) {
                return DarkModeUtils.isDarkIconMode(window);
            }
            return FlymeStatusBarUtils.isMeizuStatusBarDarkIcon(window.getAttributes());
        }

        private static void setStatusBarDarkIcon(Window window, boolean dark) {
            if (Build.VERSION.SDK_INT >= 23) {
                DarkModeUtils.setDarkIconMode(window, dark);
            } else {
                FlymeStatusBarUtils.setMeizuStatusBarDarkIcon(window.getAttributes(), dark);
            }
        }

        private static boolean isMeizuStatusBarDarkIcon(WindowManager.LayoutParams winParams) {
            try {
                Field f = winParams.getClass().getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                f.setAccessible(true);
                int darkFlag = f.getInt(winParams);
                Field f2 = winParams.getClass().getDeclaredField("meizuFlags");
                f2.setAccessible(true);
                int meizuFlags = f2.getInt(winParams);
                return darkFlag == (darkFlag & meizuFlags);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return false;
        }

        private static void setMeizuStatusBarDarkIcon(WindowManager.LayoutParams winParams, boolean dark) {
            try {
                int meizuFlags;
                Field f = winParams.getClass().getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                f.setAccessible(true);
                int bits = f.getInt(winParams);
                Field f2 = winParams.getClass().getDeclaredField("meizuFlags");
                f2.setAccessible(true);
                int oldFlags = meizuFlags = f2.getInt(winParams);
                meizuFlags = dark ? (meizuFlags |= bits) : (meizuFlags &= ~bits);
                if (oldFlags != meizuFlags) {
                    f2.setInt(winParams, meizuFlags);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private static class MethodHolder {
            private static Method mSetStatusBarDarkIcon;

            private MethodHolder() {
            }

            static {
                try {
                    mSetStatusBarDarkIcon = Activity.class.getMethod("setStatusBarDarkIcon", Boolean.TYPE);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

