/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.burred;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import per.goweii.burred.BitmapProcessor;
import per.goweii.burred.DefaultSnapshotInterceptor;
import per.goweii.burred.FastBlur;
import per.goweii.burred.GaussianBlur;
import per.goweii.burred.IBlur;
import per.goweii.burred.Utils;

public final class Blurred {
    private static final Float MAX_FPS = Float.valueOf(60.0f);
    private static IBlur sBlur;
    private static ExecutorService sExecutor;
    private long mLastFrameTime = 0L;
    private float mPercent = 0.0f;
    private float mRadius = 0.0f;
    private float mScale = 1.0f;
    private boolean mAntiAlias = false;
    private boolean mKeepSize = false;
    private boolean mFitIntoViewXY = false;
    private boolean mRecycleOriginal = false;
    private float mMaxFps = MAX_FPS.floatValue();
    private ViewTreeObserver.OnPreDrawListener mOnPreDrawListener = null;
    private ViewTreeObserver.OnDrawListener mOnDrawListener = null;
    private int mBackgroundColor = 0;
    private int mForegroundColor = 0;
    private Bitmap mOriginalBitmap = null;
    private View mViewFrom = null;
    private ImageView mViewInto = null;
    private SnapshotInterceptor mSnapshotInterceptor = null;
    private FpsListener mFpsListener = null;
    private Listener mListener = null;
    private Callback mCallback = null;
    private Handler mCallbackHandler = null;

    public static void init(Context context) {
        if (sBlur == null) {
            sBlur = Build.VERSION.SDK_INT >= 17 ? GaussianBlur.get(context) : FastBlur.get();
        }
    }

    public static void recycle() {
        if (sBlur != null) {
            sBlur.recycle();
            sBlur = null;
        }
        BitmapProcessor.get().realTimeMode(false);
        if (sExecutor != null) {
            if (!sExecutor.isShutdown()) {
                sExecutor.shutdown();
            }
            sExecutor = null;
        }
    }

    public static void realTimeMode(boolean realTimeMode) {
        IBlur iBlur = Blurred.requireBlur();
        if (iBlur instanceof GaussianBlur) {
            GaussianBlur gaussianBlur = (GaussianBlur)sBlur;
            gaussianBlur.realTimeMode(realTimeMode);
        }
        BitmapProcessor.get().realTimeMode(realTimeMode);
    }

    private static IBlur requireBlur() {
        return Utils.requireNonNull(sBlur, "Blurred\u672a\u521d\u59cb\u5316");
    }

    private static ExecutorService requireExecutor() {
        if (sExecutor == null || sExecutor.isShutdown()) {
            sExecutor = Executors.newSingleThreadExecutor();
        }
        return sExecutor;
    }

    public static Blurred with(Bitmap original) {
        return new Blurred().bitmap(original);
    }

    public static Blurred with(View view) {
        return new Blurred().view(view);
    }

    public void reset() {
        this.mMaxFps = MAX_FPS.floatValue();
        this.mPercent = 0.0f;
        this.mRadius = 0.0f;
        this.mScale = 1.0f;
        this.mKeepSize = false;
        this.mAntiAlias = false;
        this.mFitIntoViewXY = false;
        this.mRecycleOriginal = false;
        this.mOriginalBitmap = null;
        if (this.mViewFrom != null) {
            if (this.mOnPreDrawListener != null) {
                this.mViewFrom.getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
                this.mOnPreDrawListener = null;
            }
            this.mViewFrom = null;
        }
        this.mViewInto = null;
        this.mBackgroundColor = 0;
        this.mForegroundColor = 0;
    }

    public Blurred view(View view) {
        this.reset();
        this.mViewFrom = view;
        return this;
    }

    public Blurred bitmap(Bitmap original) {
        this.reset();
        this.mOriginalBitmap = original;
        return this;
    }

    public Blurred suggestConfig() {
        this.mMaxFps = 60.0f;
        this.mPercent = 0.0f;
        this.mRadius = 10.0f;
        this.mScale = 8.0f;
        this.mKeepSize = false;
        this.mAntiAlias = false;
        this.mFitIntoViewXY = false;
        this.mRecycleOriginal = false;
        return this;
    }

    public Blurred backgroundColor(int color) {
        this.mBackgroundColor = color;
        return this;
    }

    public Blurred foregroundColor(int color) {
        this.mForegroundColor = color;
        return this;
    }

    public Blurred percent(float percent) {
        this.mPercent = percent;
        return this;
    }

    public Blurred radius(float radius) {
        this.mRadius = radius;
        return this;
    }

    public Blurred scale(float scale) {
        this.mScale = scale;
        return this;
    }

    public Blurred maxFps(float maxFps) {
        this.mMaxFps = maxFps;
        return this;
    }

    public Blurred keepSize(boolean keepSize) {
        this.mKeepSize = keepSize;
        return this;
    }

    public Blurred fitIntoViewXY(boolean fit) {
        this.mFitIntoViewXY = fit;
        return this;
    }

    public Blurred antiAlias(boolean antiAlias) {
        this.mAntiAlias = antiAlias;
        return this;
    }

    public Blurred recycleOriginal(boolean recycleOriginal) {
        this.mRecycleOriginal = recycleOriginal;
        return this;
    }

    public Blurred snapshotInterceptor(SnapshotInterceptor interceptor) {
        this.mSnapshotInterceptor = interceptor;
        return this;
    }

    public Blurred fpsListener(FpsListener listener) {
        this.mFpsListener = listener;
        return this;
    }

    public Blurred listener(Listener listener) {
        this.mListener = listener;
        return this;
    }

    public Bitmap blur() {
        Bitmap blurredBitmap;
        float radius;
        float scale;
        if (this.mViewFrom == null && this.mOriginalBitmap == null) {
            throw new NullPointerException("\u5f85\u6a21\u7ccaView\u548cBitmap\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (this.mListener != null) {
            this.mListener.begin();
        }
        float f = scale = this.mScale <= 0.0f ? 1.0f : this.mScale;
        float f2 = this.mPercent <= 0.0f ? this.mRadius : (radius = (float)Math.min(this.mViewFrom != null ? this.mViewFrom.getWidth() : this.mOriginalBitmap.getWidth(), this.mViewFrom != null ? this.mViewFrom.getHeight() : this.mOriginalBitmap.getHeight()) * this.mPercent);
        if (this.mViewFrom == null) {
            blurredBitmap = Blurred.requireBlur().process(this.mOriginalBitmap, radius, scale, this.mKeepSize, this.mRecycleOriginal);
        } else {
            if (radius > 25.0f) {
                scale /= radius / 25.0f;
                radius = 25.0f;
            }
            SnapshotInterceptor snapshotInterceptor = this.checkSnapshotInterceptor();
            Bitmap bitmap = snapshotInterceptor.snapshot(this.mViewFrom, this.mBackgroundColor, this.mForegroundColor, scale, this.mAntiAlias);
            blurredBitmap = Blurred.requireBlur().process(bitmap, radius, 1.0f, this.mKeepSize, this.mRecycleOriginal);
        }
        if (this.mListener != null) {
            this.mListener.end();
        }
        return blurredBitmap;
    }

    public void blur(Callback callback) {
        Utils.requireNonNull(callback, "Callback\u4e0d\u80fd\u4e3a\u7a7a");
        this.mCallback = callback;
        this.mCallbackHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Blurred.this.mCallbackHandler = null;
                Blurred.this.mCallback.down((Bitmap)msg.obj);
            }
        };
        Blurred.requireExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = Blurred.this.blur();
                Message msg = Blurred.this.mCallbackHandler.obtainMessage();
                msg.obj = bitmap;
                Blurred.this.mCallbackHandler.sendMessage(msg);
            }
        });
    }

    public void blur(ImageView into) {
        Utils.requireNonNull(this.mViewFrom, "\u5b9e\u65f6\u9ad8\u65af\u6a21\u7cca\u65f6\u5f85\u6a21\u7ccaView\u4e0d\u80fd\u4e3a\u7a7a");
        Utils.requireNonNull(into, "ImageView\u4e0d\u80fd\u4e3a\u7a7a");
        this.mViewInto = into;
        if (this.mOnPreDrawListener == null) {
            this.mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    if (Blurred.this.mViewInto == null) {
                        return true;
                    }
                    long currFrameTime = System.currentTimeMillis();
                    float fps = 1000.0f / (float)(currFrameTime - Blurred.this.mLastFrameTime);
                    if (fps > Blurred.this.mMaxFps) {
                        return true;
                    }
                    Blurred.this.mLastFrameTime = currFrameTime;
                    if (Blurred.this.mFpsListener != null) {
                        Blurred.this.mFpsListener.currFps(fps);
                    }
                    Blurred.realTimeMode(true);
                    Blurred.this.keepSize(false);
                    Blurred.this.recycleOriginal(true);
                    Bitmap blur = Blurred.this.blur();
                    Bitmap clip = BitmapProcessor.get().clip(blur, Blurred.this.mViewFrom, Blurred.this.mViewInto, Blurred.this.mFitIntoViewXY, Blurred.this.mAntiAlias);
                    blur.recycle();
                    Blurred.this.mViewInto.setImageBitmap(clip);
                    return true;
                }
            };
            this.mViewFrom.getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
        }
    }

    private SnapshotInterceptor checkSnapshotInterceptor() {
        if (this.mSnapshotInterceptor == null) {
            this.mSnapshotInterceptor = new DefaultSnapshotInterceptor();
        }
        return this.mSnapshotInterceptor;
    }

    public static interface FpsListener {
        public void currFps(float var1);
    }

    public static interface Listener {
        public void begin();

        public void end();
    }

    public static interface Callback {
        public void down(Bitmap var1);
    }

    public static interface SnapshotInterceptor {
        public Bitmap snapshot(View var1, int var2, int var3, float var4, boolean var5);
    }
}

