/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.burred;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.view.View;
import android.widget.ImageView;

class BitmapProcessor {
    private static BitmapProcessor INSTANCE = null;
    private boolean mRealTimeMode = false;
    private PaintFlagsDrawFilter mFilter = null;
    private Paint mPaint = null;
    private Canvas mCanvas = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BitmapProcessor get() {
        if (INSTANCE != null) return INSTANCE;
        Class<BitmapProcessor> clazz = BitmapProcessor.class;
        synchronized (BitmapProcessor.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new BitmapProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private BitmapProcessor() {
    }

    void realTimeMode(boolean realTimeMode) {
        this.mRealTimeMode = realTimeMode;
        if (this.mRealTimeMode) {
            this.prepare();
        } else {
            this.recycle();
        }
    }

    private void prepare() {
        if (this.mFilter == null) {
            this.mFilter = new PaintFlagsDrawFilter(0, 3);
        }
        if (this.mPaint == null) {
            this.mPaint = new Paint();
        }
        if (this.mCanvas == null) {
            this.mCanvas = new Canvas();
        }
    }

    private void recycle() {
        this.mFilter = null;
        this.mPaint = null;
        this.mCanvas = null;
    }

    private Canvas reuseOrCreateCanvas() {
        Canvas canvas;
        if (this.mRealTimeMode) {
            this.prepare();
            canvas = this.mCanvas;
        } else {
            canvas = new Canvas();
        }
        return canvas;
    }

    private PaintFlagsDrawFilter reuseOrCreateFilter() {
        PaintFlagsDrawFilter filter;
        if (this.mRealTimeMode) {
            this.prepare();
            filter = this.mFilter;
        } else {
            filter = new PaintFlagsDrawFilter(0, 3);
        }
        return filter;
    }

    private Paint reuseOrCreatePaint() {
        Paint paint;
        if (this.mRealTimeMode) {
            this.prepare();
            paint = this.mPaint;
        } else {
            paint = new Paint();
        }
        return paint;
    }

    Bitmap snapshot(View from, int bgColor, int fgColor, float scale, boolean antiAlias) {
        float newScale = scale > 0.0f ? scale : 1.0f;
        int w = (int)((float)from.getWidth() * newScale);
        int h = (int)((float)from.getHeight() * newScale);
        Bitmap output = Bitmap.createBitmap((int)(w <= 0 ? 1 : w), (int)(h <= 0 ? 1 : h), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = this.reuseOrCreateCanvas();
        canvas.setBitmap(output);
        if (antiAlias) {
            canvas.setDrawFilter((DrawFilter)this.reuseOrCreateFilter());
        } else {
            canvas.setDrawFilter(null);
        }
        canvas.save();
        canvas.scale(newScale, newScale);
        if (bgColor != 0) {
            canvas.drawColor(bgColor);
        }
        from.draw(canvas);
        if (fgColor != 0) {
            canvas.drawColor(fgColor);
        }
        canvas.restore();
        return output;
    }

    Bitmap clip(Bitmap bitmap, View from, ImageView into, boolean fitXY, boolean antiAlias) {
        float s;
        int[] lf = new int[2];
        from.getLocationOnScreen(lf);
        int[] lt = new int[2];
        into.getLocationOnScreen(lt);
        int bw = bitmap.getWidth();
        int bh = bitmap.getHeight();
        float sx = (float)bw / (float)from.getWidth();
        float sh = (float)bh / (float)from.getHeight();
        Rect rf = new Rect((int)((float)(lt[0] - lf[0]) * sx), (int)((float)(lt[1] - lf[1]) * sh), (int)((float)(lt[0] - lf[0]) * sx + (float)into.getWidth() * sx), (int)((float)(lt[1] - lf[1]) * sh + (float)into.getHeight() * sh));
        Rect rt = new Rect(0, 0, into.getWidth(), into.getHeight());
        if (!fitXY && (s = Math.max((float)into.getWidth() / (float)rf.width(), (float)into.getHeight() / (float)rf.height())) > 1.0f) {
            rt.right = rf.width();
            rt.bottom = rf.height();
        }
        Bitmap output = Bitmap.createBitmap((int)rt.width(), (int)rt.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = this.reuseOrCreateCanvas();
        canvas.setBitmap(output);
        if (antiAlias) {
            canvas.setDrawFilter((DrawFilter)this.reuseOrCreateFilter());
        } else {
            canvas.setDrawFilter(null);
        }
        Paint paint = null;
        if (antiAlias) {
            paint = this.reuseOrCreatePaint();
            paint.setXfermode(null);
            paint.setAntiAlias(true);
        }
        canvas.drawBitmap(bitmap, rf, rt, paint);
        return output;
    }

    Bitmap scaleBitmap(Bitmap bitmap, float scale) {
        return this.scaleBitmap(bitmap, scale, true);
    }

    Bitmap scaleBitmap(Bitmap bitmap, float scale, boolean antiAlias) {
        int iw = bitmap.getWidth();
        int ih = bitmap.getHeight();
        int ow = (int)((float)iw * scale);
        int oh = (int)((float)ih * scale);
        return this.scaleBitmap(bitmap, ow, oh, antiAlias);
    }

    Bitmap scaleBitmap(Bitmap bitmap, int w, int h) {
        return this.scaleBitmap(bitmap, w, h, true);
    }

    Bitmap scaleBitmap(Bitmap bitmap, int w, int h, boolean antiAlias) {
        Bitmap.Config newConfig;
        Bitmap.Config config = bitmap.getConfig();
        switch (config) {
            case RGB_565: {
                newConfig = Bitmap.Config.RGB_565;
                break;
            }
            case ALPHA_8: {
                newConfig = Bitmap.Config.ALPHA_8;
                break;
            }
            default: {
                newConfig = Bitmap.Config.ARGB_8888;
            }
        }
        Bitmap output = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)newConfig);
        Canvas canvas = this.reuseOrCreateCanvas();
        canvas.setBitmap(output);
        if (antiAlias) {
            canvas.setDrawFilter((DrawFilter)this.reuseOrCreateFilter());
        } else {
            canvas.setDrawFilter(null);
        }
        Paint paint = null;
        if (antiAlias) {
            paint = this.reuseOrCreatePaint();
            paint.setXfermode(null);
            paint.setAntiAlias(true);
        }
        canvas.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(0, 0, w, h), paint);
        return output;
    }

    private static class StopDrawException
    extends Exception {
        private StopDrawException() {
        }
    }
}

