/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository.http;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.gm.repository.http.CharacterHandler;
import com.gm.repository.http.GlobalHttpHandler;
import com.gm.repository.utils.ZipHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import timber.log.Timber;

@Singleton
public class RequestInterceptor
implements Interceptor {
    private final Level printLevel;
    private GlobalHttpHandler mHandler;

    @Inject
    public RequestInterceptor(@Nullable GlobalHttpHandler handler, @Nullable Level level) {
        this.mHandler = handler;
        this.printLevel = level == null ? Level.ALL : level;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        long t2;
        Response originalResponse;
        boolean logRequest;
        Request request = chain.request();
        boolean bl = logRequest = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.REQUEST;
        if (logRequest) {
            boolean hasRequestBody = request.body() != null;
            Timber.w((String)"HTTP REQUEST >>>%n \u300c %s \u300d%nParams : \u300c %s \u300d%nConnection : \u300c %s \u300d%nHeaders : %n\u300c %s \u300d", (Object[])new Object[]{this.getTag(request), hasRequestBody ? RequestInterceptor.parseParams(request.newBuilder().build().body()) : "Null", chain.connection(), request.headers()});
        }
        boolean logResponse = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.RESPONSE;
        long t1 = logResponse ? System.nanoTime() : 0L;
        try {
            originalResponse = chain.proceed(request);
        }
        catch (Exception e) {
            Timber.w((String)("Http Error: " + e), (Object[])new Object[0]);
            throw e;
        }
        long l = t2 = logResponse ? System.nanoTime() : 0L;
        if (logResponse) {
            String bodySize = originalResponse.body().contentLength() != -1L ? originalResponse.body().contentLength() + "-byte" : "unknown-length";
            Timber.w((String)"HTTP RESPONSE in [ %d-ms ] , [ %s ] >>>%n%s", (Object[])new Object[]{TimeUnit.NANOSECONDS.toMillis(t2 - t1), bodySize, originalResponse.headers()});
        }
        String bodyString = this.printResult(request, originalResponse.newBuilder().build(), logResponse);
        if (this.mHandler != null) {
            return this.mHandler.onHttpResultResponse(bodyString, chain, originalResponse);
        }
        return originalResponse;
    }

    public static String parseParams(RequestBody body) throws UnsupportedEncodingException {
        if (RequestInterceptor.isParseable(body.contentType())) {
            try {
                Buffer requestbuffer = new Buffer();
                body.writeTo((BufferedSink)requestbuffer);
                Charset charset = Charset.forName("UTF-8");
                MediaType contentType = body.contentType();
                if (contentType != null) {
                    charset = contentType.charset(charset);
                }
                return URLDecoder.decode(requestbuffer.readString(charset), RequestInterceptor.convertCharset(charset));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "This params isn't parsed";
    }

    public static boolean isParseable(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return mediaType.toString().toLowerCase(Locale.ROOT).contains("text") || RequestInterceptor.isJson(mediaType) || RequestInterceptor.isForm(mediaType) || RequestInterceptor.isHtml(mediaType) || RequestInterceptor.isXml(mediaType);
    }

    public static boolean isJson(MediaType mediaType) {
        return mediaType.toString().toLowerCase(Locale.ROOT).contains("json");
    }

    public static boolean isXml(MediaType mediaType) {
        return mediaType.toString().toLowerCase(Locale.ROOT).contains("xml");
    }

    public static boolean isHtml(MediaType mediaType) {
        return mediaType.toString().toLowerCase(Locale.ROOT).contains("html");
    }

    public static boolean isForm(MediaType mediaType) {
        return mediaType.toString().toLowerCase(Locale.ROOT).contains("x-www-form-urlencoded");
    }

    public static String convertCharset(Charset charset) {
        String s = charset.toString();
        int i = s.indexOf("[");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1, s.length() - 1);
    }

    @Nullable
    private String printResult(Request request, Response response, boolean logResponse) throws IOException {
        ResponseBody responseBody = response.body();
        String bodyString = null;
        if (RequestInterceptor.isParseable(responseBody.contentType())) {
            try {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.buffer();
                String encoding = response.headers().get("Content-Encoding");
                Buffer clone = buffer.clone();
                bodyString = this.parseContent(responseBody, encoding, clone);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (logResponse) {
                Timber.w((String)"HTTP RESPONSE >>>%n\u300c %s \u300d%nResponse Content:%n%s", (Object[])new Object[]{this.getTag(request), RequestInterceptor.isJson(responseBody.contentType()) ? CharacterHandler.jsonFormat(bodyString) : (RequestInterceptor.isXml(responseBody.contentType()) ? CharacterHandler.xmlFormat(bodyString) : bodyString)});
            }
        } else if (logResponse) {
            Timber.w((String)"HTTP RESPONSE >>>%n\u300c %s \u300d%n%s", (Object[])new Object[]{this.getTag(request), "This result isn't parsed"});
        }
        return bodyString;
    }

    private String getTag(Request request) {
        return String.format(" [%s] \u300c %s \u300d", request.method(), request.url().toString());
    }

    private String parseContent(ResponseBody responseBody, String encoding, Buffer clone) {
        Charset charset = Charset.forName("UTF-8");
        MediaType contentType = responseBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            return ZipHelper.decompressForGzip(clone.readByteArray(), RequestInterceptor.convertCharset(charset));
        }
        if (encoding != null && encoding.equalsIgnoreCase("zlib")) {
            return ZipHelper.decompressToStringForZlib(clone.readByteArray(), RequestInterceptor.convertCharset(charset));
        }
        return clone.readString(charset);
    }

    public static enum Level {
        NONE,
        REQUEST,
        RESPONSE,
        ALL;

    }
}

