/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository.di.module;

import android.app.Application;
import com.gm.repository.IRepositoryManager;
import com.gm.repository.RepositoryManager;
import com.gm.repository.cache.Cache;
import com.gm.repository.cache.CacheType;
import com.gm.repository.di.module.DatabaseModule;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import io.rx_cache2.internal.RxCache;
import javax.inject.Singleton;
import retrofit2.Retrofit;

@Module
public class RepositoryModule {
    private Application mApplication;

    public RepositoryModule(Application application) {
        this.mApplication = application;
    }

    @Singleton
    @Provides
    IRepositoryManager provideRepositoryManager(Lazy<Retrofit> retrofit, Lazy<RxCache> rxCache, Cache.Factory cacheFactory, DatabaseModule.RoomConfiguration roomConfiguration) {
        return new RepositoryManager(this.mApplication, retrofit, rxCache, cacheFactory, roomConfiguration);
    }

    @Singleton
    @Provides
    Cache<String, Object> provideExtras(Cache.Factory cacheFactory) {
        return cacheFactory.build(CacheType.EXTRAS_CACHE_TYPE);
    }
}

