/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository;

import android.app.Application;
import android.content.Context;
import com.gm.repository.ConfigRepository;
import com.gm.repository.IRepository;
import com.gm.repository.di.component.DaggerRepositoryComponent;
import com.gm.repository.di.component.RepositoryComponent;
import com.gm.repository.di.module.ClientModule;
import com.gm.repository.di.module.RepositoryConfigModule;
import com.gm.repository.di.module.RepositoryModule;
import com.gm.repository.utils.ManifestRepositoryParser;
import com.gm.repository.utils.Preconditions;
import java.util.List;

public class RepositoryInjector
implements IRepository {
    private Application mApplication;
    private List<ConfigRepository> mConfigRepositories;
    private RepositoryComponent mRepositoryComponent;
    private RepositoryModule mRepositoryModule;

    public RepositoryInjector(Context context) {
        this.mConfigRepositories = new ManifestRepositoryParser(context).parse();
    }

    public void onCreate(Application application) {
        this.mApplication = application;
        if (this.mRepositoryModule == null) {
            this.mRepositoryModule = new RepositoryModule(this.mApplication);
        }
        this.mRepositoryComponent = DaggerRepositoryComponent.builder().repositoryModule(this.mRepositoryModule).clientModule(new ClientModule(this.mApplication)).repositoryConfigModule(this.getRepositoryConfigModule((Context)this.mApplication, this.mConfigRepositories)).build();
        this.mRepositoryComponent.inject(this);
    }

    public void onTerminate(Application application) {
        this.mRepositoryModule = null;
        this.mRepositoryComponent = null;
        this.mConfigRepositories = null;
        this.mApplication = null;
    }

    private RepositoryConfigModule getRepositoryConfigModule(Context context, List<ConfigRepository> configRepositories) {
        RepositoryConfigModule.Builder builder = RepositoryConfigModule.builder();
        for (ConfigRepository repository : configRepositories) {
            repository.applyOptions(context, builder);
        }
        return builder.application(this.mApplication).build();
    }

    @Override
    public RepositoryComponent getRepositoryComponent() {
        Preconditions.checkNotNull(this.mRepositoryComponent, "%s cannot be null,first call %s#onCreate(Application) in %s#onCreate()", RepositoryComponent.class.getName(), this.getClass().getName(), this.mApplication.getClass().getName());
        return this.mRepositoryComponent;
    }

    @Override
    public RepositoryModule getRepositoryModule() {
        Preconditions.checkNotNull(this.mRepositoryComponent, "%s cannot be null,first call %s#onCreate(Application) in %s#onCreate()", RepositoryModule.class.getName(), this.getClass().getName(), this.mApplication.getClass().getName());
        return this.mRepositoryModule;
    }
}

