/*
 * Decompiled with CFR 0.152.
 */
package com.gm.lifecycle.delegate;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.os.Process;
import android.support.design.widget.Snackbar;
import android.view.View;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.simple.eventbus.EventBus;
import org.simple.eventbus.Subscriber;
import org.simple.eventbus.ThreadMode;
import timber.log.Timber;

@Singleton
public final class AppManager {
    public static final String APPMANAGER_MESSAGE = "appmanager_message";
    public static final String IS_NOT_ADD_ACTIVITY_LIST = "is_not_add_activity_list";
    public static final int START_ACTIVITY = 5000;
    public static final int SHOW_SNACKBAR = 5001;
    public static final int KILL_ALL = 5002;
    public static final int APP_EXIT = 5003;
    protected final String TAG = this.getClass().getSimpleName();
    public List<Activity> mActivityList;
    private Application mApplication;
    private Activity mCurrentActivity;
    private HandleListener mHandleListener;

    @Inject
    public AppManager(Application application) {
        this.mApplication = application;
        EventBus.getDefault().register((Object)this);
    }

    public static void post(Message msg) {
        EventBus.getDefault().post((Object)msg, APPMANAGER_MESSAGE);
    }

    @Subscriber(tag="appmanager_message", mode=ThreadMode.MAIN)
    public void onReceive(Message message) {
        switch (message.what) {
            case 5000: {
                if (message.obj == null) break;
                this.dispatchStart(message);
                break;
            }
            case 5001: {
                if (message.obj == null) break;
                this.showSnackbar((String)message.obj, message.arg1 != 0);
                break;
            }
            case 5002: {
                this.killAll();
                break;
            }
            case 5003: {
                this.appExit();
                break;
            }
            default: {
                Timber.tag((String)this.TAG).w("The message.what not match", new Object[0]);
            }
        }
        if (this.mHandleListener != null) {
            this.mHandleListener.handleMessage(this, message);
        }
    }

    private void dispatchStart(Message message) {
        if (message.obj instanceof Intent) {
            this.startActivity((Intent)message.obj);
        } else if (message.obj instanceof Class) {
            this.startActivity((Class)message.obj);
        }
    }

    public HandleListener getHandleListener() {
        return this.mHandleListener;
    }

    public void setHandleListener(HandleListener handleListener) {
        this.mHandleListener = handleListener;
    }

    public void showSnackbar(String message, boolean isLong) {
        if (this.getCurrentActivity() == null) {
            Timber.tag((String)this.TAG).w("mCurrentActivity == null when showSnackbar(String,boolean)", new Object[0]);
            return;
        }
        View view = this.getCurrentActivity().getWindow().getDecorView().findViewById(0x1020002);
        Snackbar.make((View)view, (CharSequence)message, (int)(isLong ? 0 : -1)).show();
    }

    public void startActivity(Intent intent) {
        if (this.getTopActivity() == null) {
            Timber.tag((String)this.TAG).w("mCurrentActivity == null when startActivity(Intent)", new Object[0]);
            intent.setFlags(0x10000000);
            this.mApplication.startActivity(intent);
            return;
        }
        this.getTopActivity().startActivity(intent);
    }

    public void startActivity(Class activityClass) {
        this.startActivity(new Intent((Context)this.mApplication, activityClass));
    }

    public void release() {
        EventBus.getDefault().unregister((Object)this);
        this.mActivityList.clear();
        this.mHandleListener = null;
        this.mActivityList = null;
        this.mCurrentActivity = null;
        this.mApplication = null;
    }

    public Activity getCurrentActivity() {
        return this.mCurrentActivity != null ? this.mCurrentActivity : null;
    }

    public void setCurrentActivity(Activity currentActivity) {
        this.mCurrentActivity = currentActivity;
    }

    public Activity getTopActivity() {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when getTopActivity()", new Object[0]);
            return null;
        }
        return this.mActivityList.size() > 0 ? this.mActivityList.get(this.mActivityList.size() - 1) : null;
    }

    public List<Activity> getActivityList() {
        if (this.mActivityList == null) {
            this.mActivityList = new LinkedList<Activity>();
        }
        return this.mActivityList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivity(Activity activity) {
        if (this.mActivityList == null) {
            this.mActivityList = new LinkedList<Activity>();
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (!this.mActivityList.contains(activity)) {
                this.mActivityList.add(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivity(Activity activity) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when removeActivity(Activity)", new Object[0]);
            return;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (this.mActivityList.contains(activity)) {
                this.mActivityList.remove(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity removeActivity(int location) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when removeActivity(int)", new Object[0]);
            return null;
        }
        Class<AppManager> clazz = AppManager.class;
        synchronized (AppManager.class) {
            if (location > 0 && location < this.mActivityList.size()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mActivityList.remove(location);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public void killActivity(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when killActivity(Class)", new Object[0]);
            return;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            activity.finish();
        }
    }

    public boolean activityInstanceIsLive(Activity activity) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when activityInstanceIsLive(Activity)", new Object[0]);
            return false;
        }
        return this.mActivityList.contains(activity);
    }

    public boolean activityClassIsLive(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when activityClassIsLive(Class)", new Object[0]);
            return false;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            return true;
        }
        return false;
    }

    public Activity findActivity(Class<?> activityClass) {
        if (this.mActivityList == null) {
            Timber.tag((String)this.TAG).w("mActivityList == null when findActivity(Class)", new Object[0]);
            return null;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            return activity;
        }
        return null;
    }

    public void killAll() {
        Iterator<Activity> iterator = this.getActivityList().iterator();
        while (iterator.hasNext()) {
            Activity next = iterator.next();
            iterator.remove();
            next.finish();
        }
    }

    public void killAll(Class<?> ... excludeActivityClasses) {
        List<Class<?>> excludeList = Arrays.asList(excludeActivityClasses);
        Iterator<Activity> iterator = this.getActivityList().iterator();
        while (iterator.hasNext()) {
            Activity next = iterator.next();
            if (excludeList.contains(next.getClass())) continue;
            iterator.remove();
            next.finish();
        }
    }

    public void killAll(String ... excludeActivityName) {
        List<String> excludeList = Arrays.asList(excludeActivityName);
        Iterator<Activity> iterator = this.getActivityList().iterator();
        while (iterator.hasNext()) {
            Activity next = iterator.next();
            if (excludeList.contains(next.getClass().getName())) continue;
            iterator.remove();
            next.finish();
        }
    }

    public void appExit() {
        try {
            this.killAll();
            Process.killProcess((int)Process.myPid());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface HandleListener {
        public void handleMessage(AppManager var1, Message var2);
    }
}

