/*
 * Decompiled with CFR 0.152.
 */
package com.gm.lifecycle.delegate;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.gm.lifecycle.ConfigLifecycle;
import com.gm.lifecycle.delegate.ActivityDelegate;
import com.gm.lifecycle.delegate.ActivityDelegateImpl;
import com.gm.lifecycle.delegate.AppManager;
import com.gm.lifecycle.delegate.FragmentLifecycle;
import com.gm.lifecycle.delegate.IActivity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import timber.log.Timber;

@Singleton
public class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private AppManager mAppManager;
    private Application mApplication;
    private Map<String, Object> mExtras;
    private FragmentManager.FragmentLifecycleCallbacks mFragmentLifecycle;
    private List<FragmentManager.FragmentLifecycleCallbacks> mFragmentLifecycles;

    @Inject
    public ActivityLifecycle(AppManager appManager, Application application, Map<String, Object> extras) {
        this.mAppManager = appManager;
        this.mApplication = application;
        this.mExtras = extras;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Timber.w((String)"%s ---> onActivityCreated", (Object[])new Object[]{activity});
        boolean isNotAdd = false;
        if (activity.getIntent() != null) {
            isNotAdd = activity.getIntent().getBooleanExtra("is_not_add_activity_list", false);
        }
        if (!isNotAdd) {
            this.mAppManager.addActivity(activity);
        }
        if (activity instanceof IActivity && activity.getIntent() != null) {
            ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
            if (activityDelegate == null) {
                activityDelegate = new ActivityDelegateImpl(activity);
                activity.getIntent().putExtra("activity_delegate", (Parcelable)activityDelegate);
            }
            activityDelegate.onCreate(savedInstanceState);
        }
        this.registerFragmentCallbacks(activity);
    }

    public void onActivityStarted(Activity activity) {
        Timber.w((String)"%s ---> onActivityStarted", (Object[])new Object[]{activity});
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onStart();
        }
    }

    public void onActivityResumed(Activity activity) {
        Timber.w((String)"%s ---> onActivityResumed", (Object[])new Object[]{activity});
        this.mAppManager.setCurrentActivity(activity);
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onResume();
        }
    }

    public void onActivityPaused(Activity activity) {
        Timber.w((String)"%s ---> onActivityPaused", (Object[])new Object[]{activity});
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onPause();
        }
    }

    public void onActivityStopped(Activity activity) {
        ActivityDelegate activityDelegate;
        Timber.w((String)"%s ---> onActivityStopped", (Object[])new Object[]{activity});
        if (this.mAppManager.getCurrentActivity() == activity) {
            this.mAppManager.setCurrentActivity(null);
        }
        if ((activityDelegate = this.fetchActivityDelegate(activity)) != null) {
            activityDelegate.onStop();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        Timber.w((String)"%s ---> onActivitySaveInstanceState", (Object[])new Object[]{activity});
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onSaveInstanceState(outState);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        Timber.w((String)"%s ---> onActivityDestroyed", (Object[])new Object[]{activity});
        this.mAppManager.removeActivity(activity);
        ActivityDelegate activityDelegate = this.fetchActivityDelegate(activity);
        if (activityDelegate != null) {
            activityDelegate.onDestroy();
            activity.getIntent().removeExtra("activity_delegate");
        }
    }

    private void registerFragmentCallbacks(Activity activity) {
        boolean useFragment;
        boolean bl = useFragment = !(activity instanceof IActivity) || ((IActivity)activity).useFragment();
        if (activity instanceof FragmentActivity && useFragment) {
            if (this.mFragmentLifecycle == null) {
                this.mFragmentLifecycle = new FragmentLifecycle();
            }
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(this.mFragmentLifecycle, true);
            if (this.mFragmentLifecycles == null && this.mExtras.containsKey(ConfigLifecycle.class.getName())) {
                this.mFragmentLifecycles = new ArrayList<FragmentManager.FragmentLifecycleCallbacks>();
                List lifecycles = (List)this.mExtras.get(ConfigLifecycle.class.getName());
                for (ConfigLifecycle lifecycle : lifecycles) {
                    lifecycle.injectFragmentLifecycle((Context)this.mApplication, this.mFragmentLifecycles);
                }
                this.mExtras.remove(ConfigLifecycle.class.getName());
            }
            for (FragmentManager.FragmentLifecycleCallbacks fragmentLifecycle : this.mFragmentLifecycles) {
                ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(fragmentLifecycle, true);
            }
        }
    }

    private ActivityDelegate fetchActivityDelegate(Activity activity) {
        ActivityDelegate activityDelegate = null;
        if (activity instanceof IActivity && activity.getIntent() != null) {
            activity.getIntent().setExtrasClassLoader(this.getClass().getClassLoader());
            activityDelegate = (ActivityDelegate)activity.getIntent().getParcelableExtra("activity_delegate");
        }
        return activityDelegate;
    }
}

