/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Schema;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class McpTool
extends BaseTool {
    McpSchema.Tool mcpTool;
    McpSyncClient mcpSession;
    McpSessionManager mcpSessionManager;
    ObjectMapper objectMapper;

    public McpTool(McpSchema.Tool mcpTool, McpSyncClient mcpSession, McpSessionManager mcpSessionManager) {
        this(mcpTool, mcpSession, mcpSessionManager, JsonBaseModel.getMapper());
    }

    public McpTool(McpSchema.Tool mcpTool, McpSyncClient mcpSession, McpSessionManager mcpSessionManager, ObjectMapper objectMapper) {
        super(mcpTool == null ? "" : mcpTool.name(), mcpTool == null ? "" : (mcpTool.description().isEmpty() ? "" : mcpTool.description()));
        if (mcpTool == null) {
            throw new IllegalArgumentException("mcpTool cannot be null");
        }
        if (mcpSession == null) {
            throw new IllegalArgumentException("mcpSession cannot be null");
        }
        if (objectMapper == null) {
            throw new IllegalArgumentException("objectMapper cannot be null");
        }
        this.mcpTool = mcpTool;
        this.mcpSession = mcpSession;
        this.mcpSessionManager = mcpSessionManager;
        this.objectMapper = objectMapper;
    }

    public McpSyncClient getMcpSession() {
        return this.mcpSession;
    }

    public Schema toGeminiSchema(McpSchema.JsonSchema openApiSchema) {
        return Schema.fromJson((String)this.objectMapper.valueToTree((Object)openApiSchema).toString());
    }

    private void reintializeSession() {
        this.mcpSession = this.mcpSessionManager.createSession();
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        return Optional.of(FunctionDeclaration.builder().name(this.name()).description(this.description()).parameters(this.toGeminiSchema(this.mcpTool.inputSchema())).build());
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        return Single.fromCallable(() -> {
            McpSchema.CallToolResult callResult = this.mcpSession.callTool(new McpSchema.CallToolRequest(this.name(), (Map)ImmutableMap.copyOf((Map)args)));
            return McpTool.wrapCallResult(this.objectMapper, this.name(), callResult);
        }).retryWhen(errors -> errors.delay(100L, TimeUnit.MILLISECONDS).take(3L).doOnNext(error -> {
            System.err.println("Retrying callTool due to: " + error);
            this.reintializeSession();
        }));
    }

    static Map<String, Object> wrapCallResult(ObjectMapper objectMapper, String mcpToolName, McpSchema.CallToolResult callResult) {
        if (callResult == null) {
            return ImmutableMap.of((Object)"error", (Object)"MCP framework error: CallToolResult was null");
        }
        List contents = callResult.content();
        Boolean isToolError = callResult.isError();
        if (isToolError != null && isToolError.booleanValue()) {
            McpSchema.TextContent textContent;
            Object e;
            Object errorMessage = "Tool execution failed.";
            if (contents != null && !contents.isEmpty() && (e = contents.get(0)) instanceof McpSchema.TextContent && (textContent = (McpSchema.TextContent)e).text() != null && !textContent.text().isEmpty()) {
                errorMessage = (String)errorMessage + " Details: " + textContent.text();
            }
            return ImmutableMap.of((Object)"error", (Object)errorMessage);
        }
        if (contents == null || contents.isEmpty()) {
            return ImmutableMap.of();
        }
        ArrayList<String> textOutputs = new ArrayList<String>();
        for (McpSchema.Content content : contents) {
            McpSchema.TextContent textContent;
            if (!(content instanceof McpSchema.TextContent) || (textContent = (McpSchema.TextContent)content).text() == null) continue;
            textOutputs.add(textContent.text());
        }
        if (textOutputs.isEmpty()) {
            return ImmutableMap.of((Object)"error", (Object)("Tool '" + mcpToolName + "' returned content that is not TextContent."), (Object)"content_details", (Object)contents.toString());
        }
        ArrayList resultMaps = new ArrayList();
        for (String textOutput : textOutputs) {
            try {
                resultMaps.add((Map)objectMapper.readValue(textOutput, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
            catch (JsonProcessingException e) {
                resultMaps.add(ImmutableMap.of((Object)"text", (Object)textOutput));
            }
        }
        return ImmutableMap.of((Object)"text_output", resultMaps);
    }
}

