/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.applicationintegrationtoolset;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.adk.tools.applicationintegrationtoolset.ConnectionsClient;
import com.google.adk.tools.applicationintegrationtoolset.IntegrationConnectorTool;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class IntegrationClient {
    String project;
    String location;
    String integration;
    List<String> triggers;
    String connection;
    Map<String, List<String>> entityOperations;
    List<String> actions;
    private final IntegrationConnectorTool.HttpExecutor httpExecutor;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    IntegrationClient(String project, String location, String integration, List<String> triggers, String connection, Map<String, List<String>> entityOperations, List<String> actions, IntegrationConnectorTool.HttpExecutor httpExecutor) {
        this.project = project;
        this.location = location;
        this.integration = integration;
        this.triggers = triggers;
        this.connection = connection;
        this.entityOperations = entityOperations;
        this.actions = actions;
        this.httpExecutor = httpExecutor;
        if (!Strings.isNullOrEmpty((String)connection)) {
            this.validate();
        }
    }

    private void validate() {
        if (this.entityOperations == null && this.actions == null) {
            throw new IllegalArgumentException("No entity operations or actions provided. Please provide at least one of them.");
        }
        if (this.entityOperations != null) {
            Preconditions.checkArgument((!this.entityOperations.isEmpty() ? 1 : 0) != 0, (Object)"entityOperations map cannot be empty");
            for (Map.Entry<String, List<String>> entry : this.entityOperations.entrySet()) {
                String key = entry.getKey();
                List<String> value = entry.getValue();
                Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"Enitity in entityOperations map cannot be null or empty");
                Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Operations for entity '%s' cannot be null", (Object)key);
                for (String str : value) {
                    Preconditions.checkArgument((str != null && !str.isEmpty() ? 1 : 0) != 0, (String)"Operation for entity '%s' cannot be null or empty", (Object)key);
                }
            }
        }
        if (this.actions != null) {
            Preconditions.checkArgument((!this.actions.isEmpty() ? 1 : 0) != 0, (Object)"Actions list cannot be empty");
            Preconditions.checkArgument((boolean)this.actions.stream().allMatch(Objects::nonNull), (Object)"Actions list cannot contain null values");
            Preconditions.checkArgument((boolean)this.actions.stream().noneMatch(String::isEmpty), (Object)"Actions list cannot contain empty strings");
        }
    }

    String generateOpenApiSpec() throws Exception {
        String url = String.format("https://%s-integrations.googleapis.com/v1/projects/%s/locations/%s:generateOpenApiSpec", this.location, this.project, this.location);
        String jsonRequestBody = OBJECT_MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)"apiTriggerResources", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"integrationResource", (Object)this.integration, (Object)"triggerId", Arrays.asList(this.triggers))), (Object)"fileFormat", (Object)"JSON"));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + this.httpExecutor.getToken()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonRequestBody)).build();
        HttpResponse<String> response = this.httpExecutor.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            throw new Exception("Error fetching OpenAPI spec. Status: " + response.statusCode());
        }
        return response.body();
    }

    ObjectNode getOpenApiSpecForConnection(String toolName, String toolInstructions) throws IOException, InterruptedException {
        String integrationName = "ExecuteConnection";
        ConnectionsClient connectionsClient = this.createConnectionsClient();
        ImmutableMap<String, Object> baseSpecMap = ConnectionsClient.getConnectorBaseSpec();
        ObjectNode connectorSpec = (ObjectNode)OBJECT_MAPPER.valueToTree(baseSpecMap);
        ObjectNode paths = (ObjectNode)connectorSpec.path("paths");
        ObjectNode schemas = (ObjectNode)connectorSpec.path("components").path("schemas");
        if (this.entityOperations != null) {
            for (Map.Entry<String, List<String>> entry : this.entityOperations.entrySet()) {
                ConnectionsClient.EntitySchemaAndOperations schemaInfo;
                String entity = entry.getKey();
                List<String> operations = entry.getValue();
                try {
                    schemaInfo = connectionsClient.getEntitySchemaAndOperations(entity);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Operation was interrupted while getting entity schema", e);
                }
                Map<String, Object> schemaMap = schemaInfo.schema;
                List<String> supportedOperations = schemaInfo.operations;
                if (operations == null || operations.isEmpty()) {
                    operations = supportedOperations;
                }
                String jsonSchemaAsString = OBJECT_MAPPER.writeValueAsString(schemaMap);
                String entityLower = entity.toLowerCase(Locale.ROOT);
                schemas.set("connectorInputPayload_" + entityLower, OBJECT_MAPPER.valueToTree(connectionsClient.connectorPayload(schemaMap)));
                block17: for (String operation : operations) {
                    String operationLower = operation.toLowerCase(Locale.ROOT);
                    String path = String.format("/v2/projects/%s/locations/%s/integrations/%s:execute?triggerId=api_trigger/%s#%s_%s", this.project, this.location, "ExecuteConnection", "ExecuteConnection", operationLower, entityLower);
                    switch (operationLower) {
                        case "create": {
                            paths.set(path, OBJECT_MAPPER.valueToTree(ConnectionsClient.createOperation(entityLower, toolName, toolInstructions)));
                            schemas.set("create_" + entityLower + "_Request", OBJECT_MAPPER.valueToTree(ConnectionsClient.createOperationRequest(entityLower)));
                            continue block17;
                        }
                        case "update": {
                            paths.set(path, OBJECT_MAPPER.valueToTree(ConnectionsClient.updateOperation(entityLower, toolName, toolInstructions)));
                            schemas.set("update_" + entityLower + "_Request", OBJECT_MAPPER.valueToTree(ConnectionsClient.updateOperationRequest(entityLower)));
                            continue block17;
                        }
                        case "delete": {
                            paths.set(path, OBJECT_MAPPER.valueToTree(ConnectionsClient.deleteOperation(entityLower, toolName, toolInstructions)));
                            schemas.set("delete_" + entityLower + "_Request", OBJECT_MAPPER.valueToTree(ConnectionsClient.deleteOperationRequest()));
                            continue block17;
                        }
                        case "list": {
                            paths.set(path, OBJECT_MAPPER.valueToTree(ConnectionsClient.listOperation(entityLower, jsonSchemaAsString, toolName, toolInstructions)));
                            schemas.set("list_" + entityLower + "_Request", OBJECT_MAPPER.valueToTree(ConnectionsClient.listOperationRequest()));
                            continue block17;
                        }
                        case "get": {
                            paths.set(path, OBJECT_MAPPER.valueToTree(ConnectionsClient.getOperation(entityLower, jsonSchemaAsString, toolName, toolInstructions)));
                            schemas.set("get_" + entityLower + "_Request", OBJECT_MAPPER.valueToTree(ConnectionsClient.getOperationRequest()));
                            continue block17;
                        }
                    }
                    throw new IllegalArgumentException("Invalid operation: " + operation + " for entity: " + entity);
                }
            }
        } else if (this.actions != null) {
            for (String action : this.actions) {
                ObjectNode actionDetails = (ObjectNode)OBJECT_MAPPER.valueToTree((Object)connectionsClient.getActionSchema(action));
                JsonNode inputSchemaNode = actionDetails.path("inputSchema");
                JsonNode outputSchemaNode = actionDetails.path("outputSchema");
                String actionDisplayName = actionDetails.path("displayName").asText("").replace(" ", "");
                String operation = "EXECUTE_ACTION";
                Map inputSchemaMap = (Map)OBJECT_MAPPER.treeToValue((TreeNode)inputSchemaNode, Map.class);
                Map outputSchemaMap = (Map)OBJECT_MAPPER.treeToValue((TreeNode)outputSchemaNode, Map.class);
                if (Objects.equals(action, "ExecuteCustomQuery")) {
                    schemas.set(actionDisplayName + "_Request", OBJECT_MAPPER.valueToTree(ConnectionsClient.executeCustomQueryRequest()));
                    operation = "EXECUTE_QUERY";
                } else {
                    schemas.set(actionDisplayName + "_Request", OBJECT_MAPPER.valueToTree(ConnectionsClient.actionRequest(actionDisplayName)));
                    schemas.set("connectorInputPayload_" + actionDisplayName, OBJECT_MAPPER.valueToTree(connectionsClient.connectorPayload(inputSchemaMap)));
                }
                schemas.set("connectorOutputPayload_" + actionDisplayName, OBJECT_MAPPER.valueToTree(connectionsClient.connectorPayload(outputSchemaMap)));
                schemas.set(actionDisplayName + "_Response", OBJECT_MAPPER.valueToTree(ConnectionsClient.actionResponse(actionDisplayName)));
                String path = String.format("/v2/projects/%s/locations/%s/integrations/%s:execute?triggerId=api_trigger/%s#%s", this.project, this.location, "ExecuteConnection", "ExecuteConnection", action);
                paths.set(path, OBJECT_MAPPER.valueToTree(ConnectionsClient.getActionOperation(action, operation, actionDisplayName, toolName, toolInstructions)));
            }
        } else {
            throw new IllegalArgumentException("No entity operations or actions provided. Please provide at least one of them.");
        }
        return connectorSpec;
    }

    String getOperationIdFromPathUrl(String openApiSchemaString, String pathUrl) throws Exception {
        JsonNode topLevelNode = OBJECT_MAPPER.readTree(openApiSchemaString);
        JsonNode specNode = topLevelNode.path("openApiSpec");
        if (specNode.isMissingNode() || !specNode.isTextual()) {
            throw new IllegalArgumentException("Failed to get OpenApiSpec, please check the project and region for the integration.");
        }
        JsonNode rootNode = OBJECT_MAPPER.readTree(specNode.asText());
        JsonNode paths = rootNode.path("paths");
        Iterator pathsFields = paths.fields();
        while (pathsFields.hasNext()) {
            Map.Entry pathEntry = (Map.Entry)pathsFields.next();
            String currentPath = (String)pathEntry.getKey();
            if (!currentPath.equals(pathUrl)) continue;
            JsonNode pathItem = (JsonNode)pathEntry.getValue();
            Iterator methods = pathItem.fields();
            while (methods.hasNext()) {
                Map.Entry methodEntry = (Map.Entry)methods.next();
                JsonNode operationNode = (JsonNode)methodEntry.getValue();
                if (!operationNode.has("operationId")) continue;
                return operationNode.path("operationId").asText();
            }
        }
        throw new Exception("Could not find operationId for pathUrl: " + pathUrl);
    }

    ConnectionsClient createConnectionsClient() {
        return new ConnectionsClient(this.project, this.location, this.connection, this.httpExecutor, OBJECT_MAPPER);
    }
}

