/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.adk.JsonBaseModel;
import com.google.adk.models.AutoValue_LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.LiveConnectConfig;
import com.google.genai.types.Part;
import com.google.genai.types.Schema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LlmRequest
extends JsonBaseModel {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="contents")
    public abstract List<Content> contents();

    @JsonProperty(value="config")
    public abstract Optional<GenerateContentConfig> config();

    @JsonProperty(value="liveConnectConfig")
    public abstract LiveConnectConfig liveConnectConfig();

    @JsonIgnore
    public abstract Map<String, BaseTool> tools();

    @JsonIgnore
    public Optional<String> getFirstSystemInstruction() {
        return this.config().flatMap(GenerateContentConfig::systemInstruction).flatMap(content -> content.parts().flatMap(partList -> partList.stream().findFirst())).flatMap(Part::text);
    }

    @JsonIgnore
    public ImmutableList<String> getSystemInstructions() {
        return this.config().flatMap(GenerateContentConfig::systemInstruction).flatMap(Content::parts).map(partList -> (ImmutableList)partList.stream().map(Part::text).flatMap(Optional::stream).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    public static Builder builder() {
        return new AutoValue_LlmRequest.Builder().tools((Map<String, BaseTool>)ImmutableMap.of()).contents((List<Content>)ImmutableList.of()).liveConnectConfig(LiveConnectConfig.builder().build());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return LlmRequest.builder();
        }

        @JsonProperty(value="model")
        @CanIgnoreReturnValue
        public abstract Builder model(String var1);

        @JsonProperty(value="contents")
        @CanIgnoreReturnValue
        public abstract Builder contents(List<Content> var1);

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public abstract Builder config(GenerateContentConfig var1);

        public abstract Optional<GenerateContentConfig> config();

        @JsonProperty(value="liveConnectConfig")
        @CanIgnoreReturnValue
        public abstract Builder liveConnectConfig(LiveConnectConfig var1);

        abstract LiveConnectConfig liveConnectConfig();

        @CanIgnoreReturnValue
        abstract Builder tools(Map<String, BaseTool> var1);

        abstract Map<String, BaseTool> tools();

        @CanIgnoreReturnValue
        public final Builder appendInstructions(List<String> instructions) {
            if (instructions.isEmpty()) {
                return this;
            }
            GenerateContentConfig config = this.config().orElse(GenerateContentConfig.builder().build());
            ImmutableList.Builder parts = ImmutableList.builder();
            if (config.systemInstruction().isPresent()) {
                parts.addAll((Iterable)((Content)config.systemInstruction().get()).parts().orElse(ImmutableList.of()));
            }
            parts.addAll((Iterable)instructions.stream().map(instruction -> Part.builder().text(instruction).build()).collect(ImmutableList.toImmutableList()));
            this.config(config.toBuilder().systemInstruction(Content.builder().parts((List)parts.build()).role(config.systemInstruction().map(c -> c.role().orElse("user")).orElse("user")).build()).build());
            LiveConnectConfig liveConfig = this.liveConnectConfig();
            ImmutableList.Builder livePartsBuilder = ImmutableList.builder();
            if (liveConfig.systemInstruction().isPresent()) {
                livePartsBuilder.addAll((Iterable)((Content)liveConfig.systemInstruction().get()).parts().orElse(ImmutableList.of()));
            }
            livePartsBuilder.addAll((Iterable)instructions.stream().map(instruction -> Part.builder().text(instruction).build()).collect(ImmutableList.toImmutableList()));
            return this.liveConnectConfig(liveConfig.toBuilder().systemInstruction(Content.builder().parts((List)livePartsBuilder.build()).role(liveConfig.systemInstruction().map(c -> c.role().orElse("user")).orElse("user")).build()).build());
        }

        @CanIgnoreReturnValue
        public final Builder appendTools(List<BaseTool> tools) {
            if (tools.isEmpty()) {
                return this;
            }
            return this.tools((Map<String, BaseTool>)ImmutableMap.builder().putAll((Map)Stream.concat(tools.stream(), this.tools().values().stream()).collect(ImmutableMap.toImmutableMap(BaseTool::name, tool -> tool, (tool1, tool2) -> {
                throw new IllegalArgumentException(String.format("Duplicate tool name: %s", tool1.name()));
            }))).buildOrThrow());
        }

        @CanIgnoreReturnValue
        public final Builder outputSchema(Schema schema) {
            GenerateContentConfig config = this.config().orElse(GenerateContentConfig.builder().build());
            return this.config(config.toBuilder().responseSchema(schema).responseMimeType("application/json").build());
        }

        public abstract LlmRequest build();
    }
}

