/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.google.adk.models.VertexCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_VertexCredentials
extends VertexCredentials {
    private final Optional<String> project;
    private final Optional<String> location;
    private final Optional<GoogleCredentials> credentials;

    private AutoValue_VertexCredentials(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials) {
        this.project = project;
        this.location = location;
        this.credentials = credentials;
    }

    @Override
    public Optional<String> project() {
        return this.project;
    }

    @Override
    public Optional<String> location() {
        return this.location;
    }

    @Override
    public Optional<GoogleCredentials> credentials() {
        return this.credentials;
    }

    public String toString() {
        return "VertexCredentials{project=" + this.project + ", location=" + this.location + ", credentials=" + this.credentials + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VertexCredentials) {
            VertexCredentials that = (VertexCredentials)o;
            return this.project.equals(that.project()) && this.location.equals(that.location()) && this.credentials.equals(that.credentials());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.project.hashCode();
        h$ *= 1000003;
        h$ ^= this.location.hashCode();
        h$ *= 1000003;
        return h$ ^= this.credentials.hashCode();
    }

    static final class Builder
    extends VertexCredentials.Builder {
        private Optional<String> project = Optional.empty();
        private Optional<String> location = Optional.empty();
        private Optional<GoogleCredentials> credentials = Optional.empty();

        Builder() {
        }

        @Override
        public VertexCredentials.Builder setProject(Optional<String> project) {
            if (project == null) {
                throw new NullPointerException("Null project");
            }
            this.project = project;
            return this;
        }

        @Override
        public VertexCredentials.Builder setProject(@Nullable String project) {
            this.project = Optional.ofNullable(project);
            return this;
        }

        @Override
        public VertexCredentials.Builder setLocation(Optional<String> location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public VertexCredentials.Builder setLocation(@Nullable String location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @Override
        public VertexCredentials.Builder setCredentials(Optional<GoogleCredentials> credentials) {
            if (credentials == null) {
                throw new NullPointerException("Null credentials");
            }
            this.credentials = credentials;
            return this;
        }

        @Override
        public VertexCredentials.Builder setCredentials(@Nullable GoogleCredentials credentials) {
            this.credentials = Optional.ofNullable(credentials);
            return this;
        }

        @Override
        public VertexCredentials build() {
            return new AutoValue_VertexCredentials(this.project, this.location, this.credentials);
        }
    }
}

