/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web;

import com.google.adk.agents.BaseAgent;
import com.google.adk.web.AgentLoader;
import com.google.adk.web.config.AgentLoadingProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AgentCompilerLoader
implements AgentLoader {
    private static final Logger logger = LoggerFactory.getLogger(AgentCompilerLoader.class);
    private final AgentLoadingProperties properties;
    private Path compiledAgentsOutputDir;
    private final String adkCoreJarPathForCompilation;

    @Override
    public String getLoaderType() {
        return "Compiled Java Agents";
    }

    @Override
    public boolean supportsHotReloading() {
        return false;
    }

    public AgentCompilerLoader(AgentLoadingProperties properties) {
        this.properties = properties;
        this.adkCoreJarPathForCompilation = this.locateAndPrepareAdkCoreJar();
    }

    private String locateAndPrepareAdkCoreJar() {
        block16: {
            try {
                File adkJar;
                int firstSeparator;
                URL agentClassUrl = BaseAgent.class.getProtectionDomain().getCodeSource().getLocation();
                if (agentClassUrl == null) {
                    logger.warn("Could not get location for BaseAgent.class. ADK Core JAR might not be found.");
                    return "";
                }
                logger.debug("BaseAgent.class loaded from: {}", (Object)agentClassUrl);
                if ("file".equals(agentClassUrl.getProtocol())) {
                    Path path = Paths.get(agentClassUrl.toURI());
                    if (path.toString().endsWith(".jar") && Files.exists(path, new LinkOption[0])) {
                        logger.debug("ADK Core JAR (or where BaseAgent resides) found directly on classpath: {}", (Object)path.toAbsolutePath());
                        return path.toAbsolutePath().toString();
                    }
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        logger.debug("BaseAgent.class found in directory (e.g., target/classes): {}. This path will be part of classloader introspection.", (Object)path.toAbsolutePath());
                        return "";
                    }
                    break block16;
                }
                if (!"jar".equals(agentClassUrl.getProtocol())) break block16;
                String urlPath = agentClassUrl.getPath();
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring("file:".length());
                }
                if ((firstSeparator = urlPath.indexOf("!/")) == -1) {
                    logger.warn("Malformed JAR URL for BaseAgent.class: {}", (Object)agentClassUrl);
                    return "";
                }
                String mainJarPath = urlPath.substring(0, firstSeparator);
                String nestedPath = urlPath.substring(firstSeparator);
                if (nestedPath.startsWith("!/BOOT-INF/lib/") && nestedPath.contains("google-adk-")) {
                    int nestedJarStartInPath = "!/BOOT-INF/lib/".length();
                    int nestedJarEndInPath = nestedPath.indexOf("!/", nestedJarStartInPath);
                    if (nestedJarEndInPath <= 0) break block16;
                    String nestedJarName = nestedPath.substring(nestedJarStartInPath, nestedJarEndInPath);
                    String nestedJarUrlString = "jar:file:" + mainJarPath + "!/BOOT-INF/lib/" + nestedJarName;
                    Path tempFile = Files.createTempFile("adk-core-extracted-", ".jar", new FileAttribute[0]);
                    try (InputStream is = new URL(nestedJarUrlString).openStream();){
                        Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    tempFile.toFile().deleteOnExit();
                    logger.debug("Extracted ADK Core JAR '{}' from nested location to: {}", (Object)nestedJarName, (Object)tempFile.toAbsolutePath());
                    return tempFile.toAbsolutePath().toString();
                }
                if (mainJarPath.contains("google-adk-") && mainJarPath.endsWith(".jar") && (adkJar = new File(mainJarPath)).exists()) {
                    logger.debug("ADK Core JAR identified as the outer JAR: {}", (Object)adkJar.getAbsolutePath());
                    return adkJar.getAbsolutePath();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to locate or extract ADK Core JAR", (Throwable)e);
            }
        }
        logger.warn("ADK Core JAR could not be reliably located for compilation via locateAndPrepareAdkCoreJar. Relying on classloader introspection.");
        return "";
    }

    @Override
    public Map<String, BaseAgent> loadAgents() throws IOException {
        if (this.properties.getSourceDir() == null || this.properties.getSourceDir().isEmpty()) {
            logger.info("Agent source directory (adk.agents.source-dir) not configured. No dynamic agents will be loaded.");
            return Collections.emptyMap();
        }
        Path agentsSourceRoot = Paths.get(this.properties.getSourceDir(), new String[0]);
        if (!Files.isDirectory(agentsSourceRoot, new LinkOption[0])) {
            logger.warn("Agent source directory does not exist: {}", (Object)agentsSourceRoot);
            return Collections.emptyMap();
        }
        this.compiledAgentsOutputDir = Files.createTempDirectory("adk-compiled-agents-", new FileAttribute[0]);
        this.compiledAgentsOutputDir.toFile().deleteOnExit();
        logger.debug("Compiling agents from {} to {}", (Object)agentsSourceRoot, (Object)this.compiledAgentsOutputDir);
        HashMap<String, BaseAgent> loadedAgents = new HashMap<String, BaseAgent>();
        try (Stream<Path> stream = Files.list(agentsSourceRoot);){
            List entries = stream.collect(Collectors.toList());
            for (Path entry : entries) {
                String agentUnitName;
                List<Object> javaFilesToCompile = new ArrayList();
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    agentUnitName = entry.getFileName().toString();
                    logger.debug("Processing agent sources from directory: {}", (Object)agentUnitName);
                    try (Stream<Path> javaFilesStream = Files.walk(entry, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".java") && Files.isRegularFile(p, new LinkOption[0]));){
                        javaFilesToCompile = javaFilesStream.map(p -> p.toAbsolutePath().toString()).collect(Collectors.toList());
                    }
                } else if (Files.isRegularFile(entry, new LinkOption[0]) && entry.getFileName().toString().endsWith(".java")) {
                    String fileName = entry.getFileName().toString();
                    agentUnitName = fileName.substring(0, fileName.length() - ".java".length());
                    logger.debug("Processing agent source file: {}", (Object)entry.getFileName());
                    javaFilesToCompile.add(entry.toAbsolutePath().toString());
                } else {
                    logger.trace("Skipping non-agent entry in agent source root: {}", (Object)entry.getFileName());
                    continue;
                }
                if (javaFilesToCompile.isEmpty()) {
                    logger.debug("No .java files found for agent unit: {}", (Object)agentUnitName);
                    continue;
                }
                Path unitSpecificOutputDir = this.compiledAgentsOutputDir.resolve(agentUnitName);
                Files.createDirectories(unitSpecificOutputDir, new FileAttribute[0]);
                boolean compilationSuccess = this.compileSourcesWithECJ(javaFilesToCompile, unitSpecificOutputDir);
                if (compilationSuccess) {
                    try {
                        ArrayList<URL> classLoaderUrls = new ArrayList<URL>();
                        classLoaderUrls.add(unitSpecificOutputDir.toUri().toURL());
                        URLClassLoader agentClassLoader = new URLClassLoader(classLoaderUrls.toArray(new URL[0]), AgentCompilerLoader.class.getClassLoader());
                        Files.walk(unitSpecificOutputDir, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".class")).forEach(classFile -> {
                            try {
                                String relativePath = unitSpecificOutputDir.relativize((Path)classFile).toString();
                                String className = relativePath.substring(0, relativePath.length() - ".class".length()).replace(File.separatorChar, '.');
                                Class<?> loadedClass = agentClassLoader.loadClass(className);
                                Field rootAgentField = null;
                                try {
                                    rootAgentField = loadedClass.getField("ROOT_AGENT");
                                }
                                catch (NoSuchFieldException e) {
                                    return;
                                }
                                if (Modifier.isStatic(rootAgentField.getModifiers()) && BaseAgent.class.isAssignableFrom(rootAgentField.getType())) {
                                    BaseAgent agentInstance = (BaseAgent)rootAgentField.get(null);
                                    if (agentInstance != null) {
                                        if (loadedAgents.containsKey(agentInstance.name())) {
                                            logger.warn("Found another agent with name {}. This will overwrite the original agent loaded with this name from unit {} using class {}", new Object[]{agentInstance.name(), agentUnitName, className});
                                        }
                                        loadedAgents.put(agentInstance.name(), agentInstance);
                                        logger.debug("Successfully loaded agent '{}' from unit: {} using class {}", new Object[]{agentInstance.name(), agentUnitName, className});
                                    } else {
                                        logger.warn("ROOT_AGENT field in class {} from unit {} was null", (Object)className, (Object)agentUnitName);
                                    }
                                }
                            }
                            catch (ClassNotFoundException | IllegalAccessException e) {
                                logger.error("Error loading or accessing agent from class file {} for unit {}", new Object[]{classFile, agentUnitName, e});
                            }
                            catch (Exception e) {
                                logger.error("Unexpected error processing class file {} for unit {}", new Object[]{classFile, agentUnitName, e});
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error("Error during class loading setup for unit {}: {}", new Object[]{agentUnitName, e.getMessage(), e});
                    }
                    continue;
                }
                logger.error("Compilation failed for agent unit: {}", (Object)agentUnitName);
            }
        }
        return loadedAgents;
    }

    private boolean compileSourcesWithECJ(List<String> javaFilePaths, Path outputDir) {
        ArrayList<String> ecjArgs = new ArrayList<String>();
        ecjArgs.add("-17");
        ecjArgs.add("-nowarn");
        ecjArgs.add("-d");
        ecjArgs.add(outputDir.toAbsolutePath().toString());
        LinkedHashSet<String> classpathEntries = new LinkedHashSet<String>();
        logger.debug("Attempting to derive ECJ classpath from classloader hierarchy...");
        int classLoaderCount = 0;
        for (ClassLoader currentClassLoader = AgentCompilerLoader.class.getClassLoader(); currentClassLoader != null; currentClassLoader = currentClassLoader.getParent()) {
            logger.debug("Inspecting classloader ({}) : {}", (Object)(++classLoaderCount), (Object)currentClassLoader.getClass().getName());
            if (!(currentClassLoader instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)currentClassLoader).getURLs();
            logger.debug("  Found {} URLs in URLClassLoader {}", (Object)urls.length, (Object)currentClassLoader.getClass().getName());
            for (URL url : urls) {
                try {
                    if ("file".equals(url.getProtocol())) {
                        String path = Paths.get(url.toURI()).toString();
                        classpathEntries.add(path);
                        logger.trace("    Added to ECJ classpath: {}", (Object)path);
                        continue;
                    }
                    logger.debug("    Skipping non-file URL from classloader {}: {}", (Object)currentClassLoader.getClass().getName(), (Object)url);
                }
                catch (IllegalArgumentException | URISyntaxException e) {
                    logger.warn("    Could not convert URL to path or add to classpath from {}: {} (Error: {})", new Object[]{currentClassLoader.getClass().getName(), url, e.getMessage()});
                }
                catch (Exception e) {
                    logger.warn("    Unexpected error converting URL to path from {}: {} (Error: {})", new Object[]{currentClassLoader.getClass().getName(), url, e.getMessage(), e});
                }
            }
        }
        if (classpathEntries.isEmpty()) {
            logger.warn("No classpath entries derived from classloader hierarchy. Falling back to System.getProperty(\"java.class.path\").");
            String systemClasspath = System.getProperty("java.class.path");
            if (systemClasspath != null && !systemClasspath.isEmpty()) {
                logger.debug("Using system classpath for ECJ (fallback): {}", (Object)systemClasspath);
                classpathEntries.addAll(Arrays.asList(systemClasspath.split(File.pathSeparator)));
            } else {
                logger.error("System classpath (java.class.path) is also null or empty.");
            }
        }
        if (this.adkCoreJarPathForCompilation != null && !this.adkCoreJarPathForCompilation.isEmpty()) {
            if (!classpathEntries.contains(this.adkCoreJarPathForCompilation)) {
                logger.debug("Adding ADK Core JAR path explicitly to ECJ classpath: {}", (Object)this.adkCoreJarPathForCompilation);
                classpathEntries.add(this.adkCoreJarPathForCompilation);
            } else {
                logger.debug("ADK Core JAR path ({}) already found in derived ECJ classpath.", (Object)this.adkCoreJarPathForCompilation);
            }
        } else if (classpathEntries.stream().noneMatch(p -> p.contains("google-adk"))) {
            logger.error("ADK Core JAR path is missing and no 'google-adk' JAR found in derived classpath. Compilation will likely fail to find BaseAgent.");
        }
        if (this.properties.getCompileClasspath() != null && !this.properties.getCompileClasspath().isEmpty()) {
            String userClasspath = this.properties.getCompileClasspath();
            logger.info("Appending user-defined classpath (adk.agents.compile-classpath) to ECJ: {}", (Object)userClasspath);
            classpathEntries.addAll(Arrays.asList(userClasspath.split(File.pathSeparator)));
        }
        if (classpathEntries.isEmpty()) {
            logger.error("ECJ Classpath is empty after all attempts. Compilation will fail.");
            return false;
        }
        String effectiveClasspath = classpathEntries.stream().collect(Collectors.joining(File.pathSeparator));
        ecjArgs.add("-cp");
        ecjArgs.add(effectiveClasspath);
        logger.debug("Constructed ECJ classpath with {} entries", (Object)classpathEntries.size());
        logger.debug("Final effective ECJ classpath: {}", (Object)effectiveClasspath);
        ecjArgs.addAll(javaFilePaths);
        logger.debug("ECJ Args: {}", (Object)String.join((CharSequence)" ", ecjArgs));
        PrintWriter outWriter = new PrintWriter(System.out, true);
        PrintWriter errWriter = new PrintWriter(System.err, true);
        boolean success = BatchCompiler.compile((String[])ecjArgs.toArray(new String[0]), (PrintWriter)outWriter, (PrintWriter)errWriter, null);
        if (!success) {
            logger.error("ECJ Compilation failed. See console output for details.");
        }
        return success;
    }
}

