/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.ui.DefaultTrackNameProvider;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TrackNameProvider;
import com.google.android.exoplayer2.util.Assertions;
import java.util.Arrays;

public class TrackSelectionView
extends LinearLayout {
    private final int selectableItemBackgroundResourceId;
    private final LayoutInflater inflater;
    private final CheckedTextView disableView;
    private final CheckedTextView defaultView;
    private final ComponentListener componentListener;
    private boolean allowAdaptiveSelections;
    private TrackNameProvider trackNameProvider;
    private CheckedTextView[][] trackViews;
    private DefaultTrackSelector trackSelector;
    private int rendererIndex;
    private TrackGroupArray trackGroups;
    private boolean isDisabled;
    @Nullable
    private DefaultTrackSelector.SelectionOverride override;

    public static Pair<AlertDialog, TrackSelectionView> getDialog(Activity activity, CharSequence title, DefaultTrackSelector trackSelector, int rendererIndex) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        LayoutInflater dialogInflater = LayoutInflater.from((Context)builder.getContext());
        View dialogView = dialogInflater.inflate(R.layout.exo_track_selection_dialog, null);
        TrackSelectionView selectionView = (TrackSelectionView)dialogView.findViewById(R.id.exo_track_selection_view);
        selectionView.init(trackSelector, rendererIndex);
        DialogInterface.OnClickListener okClickListener = (dialog, which) -> selectionView.applySelection();
        AlertDialog dialog2 = builder.setTitle(title).setView(dialogView).setPositiveButton(17039370, okClickListener).setNegativeButton(0x1040000, null).create();
        return Pair.create((Object)dialog2, (Object)((Object)selectionView));
    }

    public TrackSelectionView(Context context) {
        this(context, null);
    }

    public TrackSelectionView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TrackSelectionView(Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributeArray = context.getTheme().obtainStyledAttributes(new int[]{16843534});
        this.selectableItemBackgroundResourceId = attributeArray.getResourceId(0, 0);
        attributeArray.recycle();
        this.inflater = LayoutInflater.from((Context)context);
        this.componentListener = new ComponentListener();
        this.trackNameProvider = new DefaultTrackNameProvider(this.getResources());
        this.disableView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.disableView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.disableView.setText(R.string.exo_track_selection_none);
        this.disableView.setEnabled(false);
        this.disableView.setFocusable(true);
        this.disableView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.disableView.setVisibility(8);
        this.addView((View)this.disableView);
        this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
        this.defaultView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.defaultView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.defaultView.setText(R.string.exo_track_selection_auto);
        this.defaultView.setEnabled(false);
        this.defaultView.setFocusable(true);
        this.defaultView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.addView((View)this.defaultView);
    }

    public void setAllowAdaptiveSelections(boolean allowAdaptiveSelections) {
        if (this.allowAdaptiveSelections != allowAdaptiveSelections) {
            this.allowAdaptiveSelections = allowAdaptiveSelections;
            this.updateViews();
        }
    }

    public void setShowDisableOption(boolean showDisableOption) {
        this.disableView.setVisibility(showDisableOption ? 0 : 8);
    }

    public void setTrackNameProvider(TrackNameProvider trackNameProvider) {
        this.trackNameProvider = (TrackNameProvider)Assertions.checkNotNull((Object)trackNameProvider);
        this.updateViews();
    }

    public void init(DefaultTrackSelector trackSelector, int rendererIndex) {
        this.trackSelector = trackSelector;
        this.rendererIndex = rendererIndex;
        this.updateViews();
    }

    private void updateViews() {
        MappingTrackSelector.MappedTrackInfo trackInfo;
        for (int i = this.getChildCount() - 1; i >= 3; --i) {
            this.removeViewAt(i);
        }
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = trackInfo = this.trackSelector == null ? null : this.trackSelector.getCurrentMappedTrackInfo();
        if (this.trackSelector == null || trackInfo == null) {
            this.disableView.setEnabled(false);
            this.defaultView.setEnabled(false);
            return;
        }
        this.disableView.setEnabled(true);
        this.defaultView.setEnabled(true);
        this.trackGroups = trackInfo.getTrackGroups(this.rendererIndex);
        DefaultTrackSelector.Parameters parameters = this.trackSelector.getParameters();
        this.isDisabled = parameters.getRendererDisabled(this.rendererIndex);
        this.override = parameters.getSelectionOverride(this.rendererIndex, this.trackGroups);
        this.trackViews = new CheckedTextView[this.trackGroups.length][];
        for (int groupIndex = 0; groupIndex < this.trackGroups.length; ++groupIndex) {
            TrackGroup group = this.trackGroups.get(groupIndex);
            boolean enableAdaptiveSelections = this.allowAdaptiveSelections && this.trackGroups.get((int)groupIndex).length > 1 && trackInfo.getAdaptiveSupport(this.rendererIndex, groupIndex, false) != 0;
            this.trackViews[groupIndex] = new CheckedTextView[group.length];
            for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                if (trackIndex == 0) {
                    this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
                }
                int trackViewLayoutId = enableAdaptiveSelections ? 0x1090010 : 17367055;
                CheckedTextView trackView = (CheckedTextView)this.inflater.inflate(trackViewLayoutId, (ViewGroup)this, false);
                trackView.setBackgroundResource(this.selectableItemBackgroundResourceId);
                trackView.setText((CharSequence)this.trackNameProvider.getTrackName(group.getFormat(trackIndex)));
                if (trackInfo.getTrackSupport(this.rendererIndex, groupIndex, trackIndex) == 4) {
                    trackView.setFocusable(true);
                    trackView.setTag((Object)Pair.create((Object)groupIndex, (Object)trackIndex));
                    trackView.setOnClickListener((View.OnClickListener)this.componentListener);
                } else {
                    trackView.setFocusable(false);
                    trackView.setEnabled(false);
                }
                this.trackViews[groupIndex][trackIndex] = trackView;
                this.addView((View)trackView);
            }
        }
        this.updateViewStates();
    }

    private void updateViewStates() {
        this.disableView.setChecked(this.isDisabled);
        this.defaultView.setChecked(!this.isDisabled && this.override == null);
        for (int i = 0; i < this.trackViews.length; ++i) {
            for (int j = 0; j < this.trackViews[i].length; ++j) {
                this.trackViews[i][j].setChecked(this.override != null && this.override.groupIndex == i && this.override.containsTrack(j));
            }
        }
    }

    private void applySelection() {
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.trackSelector.buildUponParameters();
        parametersBuilder.setRendererDisabled(this.rendererIndex, this.isDisabled);
        if (this.override != null) {
            parametersBuilder.setSelectionOverride(this.rendererIndex, this.trackGroups, this.override);
        } else {
            parametersBuilder.clearSelectionOverrides(this.rendererIndex);
        }
        this.trackSelector.setParameters(parametersBuilder);
    }

    private void onClick(View view) {
        if (view == this.disableView) {
            this.onDisableViewClicked();
        } else if (view == this.defaultView) {
            this.onDefaultViewClicked();
        } else {
            this.onTrackViewClicked(view);
        }
        this.updateViewStates();
    }

    private void onDisableViewClicked() {
        this.isDisabled = true;
        this.override = null;
    }

    private void onDefaultViewClicked() {
        this.isDisabled = false;
        this.override = null;
    }

    private void onTrackViewClicked(View view) {
        this.isDisabled = false;
        Pair tag = (Pair)view.getTag();
        int groupIndex = (Integer)tag.first;
        int trackIndex = (Integer)tag.second;
        if (this.override == null || this.override.groupIndex != groupIndex || !this.allowAdaptiveSelections) {
            this.override = new DefaultTrackSelector.SelectionOverride(groupIndex, new int[]{trackIndex});
        } else {
            int overrideLength = this.override.length;
            int[] overrideTracks = this.override.tracks;
            if (((CheckedTextView)view).isChecked()) {
                if (overrideLength == 1) {
                    this.override = null;
                    this.isDisabled = true;
                } else {
                    int[] tracks = TrackSelectionView.getTracksRemoving(overrideTracks, trackIndex);
                    this.override = new DefaultTrackSelector.SelectionOverride(groupIndex, tracks);
                }
            } else {
                int[] tracks = TrackSelectionView.getTracksAdding(overrideTracks, trackIndex);
                this.override = new DefaultTrackSelector.SelectionOverride(groupIndex, tracks);
            }
        }
    }

    private static int[] getTracksAdding(int[] tracks, int addedTrack) {
        tracks = Arrays.copyOf(tracks, tracks.length + 1);
        tracks[tracks.length - 1] = addedTrack;
        return tracks;
    }

    private static int[] getTracksRemoving(int[] tracks, int removedTrack) {
        int[] newTracks = new int[tracks.length - 1];
        int trackCount = 0;
        for (int track : tracks) {
            if (track == removedTrack) continue;
            newTracks[trackCount++] = track;
        }
        return newTracks;
    }

    private class ComponentListener
    implements View.OnClickListener {
        private ComponentListener() {
        }

        public void onClick(View view) {
            TrackSelectionView.this.onClick(view);
        }
    }
}

