/*
 * Decompiled with CFR 0.152.
 */
package io.testcontainers.arangodb.cluster;

import io.testcontainers.arangodb.cluster.ArangoCluster;
import io.testcontainers.arangodb.cluster.ArangoClusterContainer;
import io.testcontainers.arangodb.containers.ArangoContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class ArangoClusterBuilder {
    public static final String LATEST = "latest";
    private static final String IMAGE = "arangodb";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"arangodb");
    public static final int COORDINATOR_PORT_DEFAULT = 8529;
    public static final int DBSERVER_PORT_DEFAULT = 8515;
    public static final int AGENCY_PORT_DEFAULT = 8500;
    private static final int AGENCY_NODES_DEFAULT = 3;
    private static final int DBSERVER_NODES_DEFAULT = 2;
    private static final int COORDINATOR_NODES_DEFAULT = 2;
    private int agentNodes = 3;
    private int databaseNodes = 2;
    private int coordinatorNodes = 2;
    private int agentPortFrom = 8500;
    private int dbserverPortFrom = 8515;
    private int coordinatorPortFrom = 8529;
    private DockerImageName dockerImageName;
    private boolean exposeAgents = false;
    private boolean exposeDBServers = false;

    private ArangoClusterBuilder() {
    }

    public ArangoClusterBuilder withExposedAgentNodes() {
        this.exposeAgents = true;
        return this;
    }

    public ArangoClusterBuilder withExposedDBServerNodes() {
        this.exposeDBServers = true;
        return this;
    }

    public ArangoClusterBuilder withAgentNodes(int agentNodes) {
        this.agentNodes = agentNodes;
        return this;
    }

    public ArangoClusterBuilder withDatabaseNodes(int databaseNodes) {
        this.databaseNodes = databaseNodes;
        return this;
    }

    public ArangoClusterBuilder withCoordinatorNodes(int coordinatorNodes) {
        this.coordinatorNodes = coordinatorNodes;
        return this;
    }

    public ArangoClusterBuilder withAgentPortFrom(int agentPortFrom) {
        this.agentPortFrom = agentPortFrom;
        return this;
    }

    public ArangoClusterBuilder withDBServerPortFrom(int dbserverPortFrom) {
        this.dbserverPortFrom = dbserverPortFrom;
        return this;
    }

    public ArangoClusterBuilder withCoordinatorPortFrom(int coordinatorPortFrom) {
        this.coordinatorPortFrom = coordinatorPortFrom;
        return this;
    }

    protected ArangoClusterBuilder withVersion(String version) {
        this.dockerImageName = DockerImageName.parse((String)IMAGE).withTag(version);
        return this;
    }

    protected ArangoClusterBuilder withVersion(DockerImageName imageName) {
        this.dockerImageName = imageName;
        imageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        return this;
    }

    public static ArangoClusterBuilder builder(String imageVersion) {
        return new ArangoClusterBuilder().withVersion(imageVersion);
    }

    public static ArangoClusterBuilder builder(DockerImageName imageName) {
        return new ArangoClusterBuilder().withVersion(imageName);
    }

    public static ArangoCluster buildDefault(String imageVersion) {
        return new ArangoClusterBuilder().withVersion(imageVersion).build();
    }

    public static ArangoCluster buildDefault(DockerImageName imageName) {
        return new ArangoClusterBuilder().withVersion(imageName).build();
    }

    public static ArangoCluster buildDefault(String imageVersion, int exposeCoordinatorPort) {
        return new ArangoClusterBuilder().withVersion(imageVersion).withCoordinatorPortFrom(exposeCoordinatorPort).build();
    }

    public static ArangoCluster buildDefault(DockerImageName imageName, int exposeCoordinatorPort) {
        return new ArangoClusterBuilder().withVersion(imageName).withCoordinatorPortFrom(exposeCoordinatorPort).build();
    }

    public ArangoCluster build() {
        return this.build(Network.newNetwork());
    }

    public ArangoCluster build(Network network) {
        return new ArangoCluster(this.buildContainers(network));
    }

    public List<ArangoClusterContainer> buildContainers() {
        return this.buildContainers(Network.newNetwork());
    }

    public List<ArangoClusterContainer> buildContainers(Network network) {
        int port;
        String alias;
        int i;
        if (this.dockerImageName == null) {
            throw new UnsupportedOperationException("Image version can not be empty!");
        }
        if (this.agentNodes % 2 != 1) {
            throw new UnsupportedOperationException("Agent nodes must be odd number!");
        }
        if (this.databaseNodes < 2) {
            throw new IllegalArgumentException("Database nodes can not be less 2");
        }
        if (this.coordinatorNodes < 2) {
            throw new IllegalArgumentException("Coordinator nodes can not be less 2");
        }
        String version = this.dockerImageName.getVersionPart();
        ArrayList<ArangoClusterContainer> agents = new ArrayList<ArangoClusterContainer>(this.agentNodes);
        ArrayList<ArangoClusterContainer> databases = new ArrayList<ArangoClusterContainer>(this.databaseNodes);
        ArrayList<ArangoClusterContainer> coordinators = new ArrayList<ArangoClusterContainer>(this.coordinatorNodes);
        String aliasLead = ArangoClusterContainer.NodeType.AGENT_LEADER.getAlias();
        int portLead = this.agentPortFrom;
        ArangoClusterContainer leader = ArangoClusterContainer.agent(aliasLead, portLead, version, this.agentNodes, true, this.exposeAgents);
        leader.withAgentEndpoints(Collections.singletonList(leader.getEndpoint()));
        agents.add(leader);
        for (i = 1; i < this.agentNodes; ++i) {
            alias = ArangoClusterContainer.NodeType.AGENT.getAlias(i);
            port = this.agentPortFrom + i;
            ArangoClusterContainer agent = (ArangoClusterContainer)ArangoClusterContainer.agent(alias, port, version, this.agentNodes, false, this.exposeAgents).withAgentEndpoints(Collections.singletonList(leader.getEndpoint())).dependsOn(new Startable[]{leader});
            agents.add(agent);
        }
        for (i = 0; i < this.databaseNodes; ++i) {
            alias = ArangoClusterContainer.NodeType.DBSERVER.getAlias(i);
            port = this.dbserverPortFrom + i;
            ArangoContainer database = (ArangoContainer)ArangoClusterContainer.dbserver(alias, port, version, this.exposeDBServers).withAgentEndpoints(Collections.singletonList(leader.getEndpoint())).dependsOn(agents);
            databases.add((ArangoClusterContainer)database);
        }
        for (i = 0; i < this.coordinatorNodes; ++i) {
            alias = ArangoClusterContainer.NodeType.COORDINATOR.getAlias(i);
            port = this.coordinatorPortFrom + i;
            ArangoContainer coordinator = (ArangoContainer)ArangoClusterContainer.coordinator(alias, port, version).withAgentEndpoints(Collections.singletonList(leader.getEndpoint())).dependsOn(databases);
            coordinators.add((ArangoClusterContainer)coordinator);
        }
        return Collections.unmodifiableList(Stream.of(agents, databases, coordinators).flatMap(Collection::stream).map(c -> (ArangoClusterContainer)c.withNetwork(network)).sorted(Comparator.comparing(ArangoClusterContainer::getType)).collect(Collectors.toList()));
    }
}

