/*
 * Decompiled with CFR 0.152.
 */
package com.konovalov.vad.webrtc;

import com.konovalov.vad.webrtc.config.FrameSize;
import com.konovalov.vad.webrtc.config.Mode;
import com.konovalov.vad.webrtc.config.SampleRate;
import com.konovalov.vad.webrtc.utils.AudioUtils;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0010\u0014\n\u0002\u0010\u0017\n\u0002\b\b\u0018\u0000 ;2\u00020\u0001:\u0001;B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0016J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J\u000e\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u000202J\u000e\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u000203J\u000e\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u000204J\u0011\u00105\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u0019H\u0082 J\t\u00106\u001a\u00020\u0019H\u0082 J+\u00107\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t2\b\u00108\u001a\u0004\u0018\u000104H\u0082 J\u0019\u00109\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\tH\u0082 J\u0010\u0010:\u001a\u00020\u00112\u0006\u00101\u001a\u000204H\u0002R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\n\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000RB\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050(0'2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050(0'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006<"}, d2={"Lcom/konovalov/vad/webrtc/VadWebRTC;", "Ljava/io/Closeable;", "sampleRate", "Lcom/konovalov/vad/webrtc/config/SampleRate;", "frameSize", "Lcom/konovalov/vad/webrtc/config/FrameSize;", "mode", "Lcom/konovalov/vad/webrtc/config/Mode;", "speechDurationMs", "", "silenceDurationMs", "(Lcom/konovalov/vad/webrtc/config/SampleRate;Lcom/konovalov/vad/webrtc/config/FrameSize;Lcom/konovalov/vad/webrtc/config/Mode;II)V", "getFrameSize", "()Lcom/konovalov/vad/webrtc/config/FrameSize;", "setFrameSize", "(Lcom/konovalov/vad/webrtc/config/FrameSize;)V", "isInitiated", "", "maxSilenceFramesCount", "maxSpeechFramesCount", "getMode", "()Lcom/konovalov/vad/webrtc/config/Mode;", "setMode", "(Lcom/konovalov/vad/webrtc/config/Mode;)V", "nativeHandle", "", "getSampleRate", "()Lcom/konovalov/vad/webrtc/config/SampleRate;", "setSampleRate", "(Lcom/konovalov/vad/webrtc/config/SampleRate;)V", "getSilenceDurationMs", "()I", "setSilenceDurationMs", "(I)V", "silenceFramesCount", "getSpeechDurationMs", "setSpeechDurationMs", "speechFramesCount", "<set-?>", "", "", "supportedParameters", "getSupportedParameters", "()Ljava/util/Map;", "checkState", "", "close", "isContinuousSpeech", "isSpeech", "audioData", "", "", "", "nativeDestroy", "nativeInit", "nativeIsSpeech", "audio", "nativeSetMode", "predict", "Companion", "android-vad-webrtc-v2.0.9_release"})
public final class VadWebRTC
implements Closeable {
    private static final Companion Companion = new Companion(null);
    private Map<SampleRate, ? extends Set<? extends FrameSize>> supportedParameters;
    private boolean isInitiated;
    private long nativeHandle;
    private int speechFramesCount;
    private int silenceFramesCount;
    private int maxSpeechFramesCount;
    private int maxSilenceFramesCount;
    private SampleRate sampleRate;
    private FrameSize frameSize;
    private Mode mode;
    private int speechDurationMs;
    private int silenceDurationMs;

    public VadWebRTC(SampleRate sampleRate, FrameSize frameSize, Mode mode, int n, int n2) {
        long l;
        Intrinsics.checkNotNullParameter((Object)((Object)sampleRate), (String)"sampleRate");
        Intrinsics.checkNotNullParameter((Object)((Object)frameSize), (String)"frameSize");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FrameSize frameSize2 = FrameSize.FRAME_SIZE_160;
        Pair pair = TuplesKt.to((Object)((Object)SampleRate.SAMPLE_RATE_8K), (Object)SetsKt.setOf((Object[])new FrameSize[]{FrameSize.FRAME_SIZE_80, frameSize2, FrameSize.FRAME_SIZE_240}));
        FrameSize frameSize3 = FrameSize.FRAME_SIZE_320;
        FrameSize frameSize4 = FrameSize.FRAME_SIZE_480;
        frameSize2 = TuplesKt.to((Object)((Object)SampleRate.SAMPLE_RATE_16K), (Object)SetsKt.setOf((Object[])new FrameSize[]{frameSize2, frameSize3, frameSize4}));
        FrameSize frameSize5 = FrameSize.FRAME_SIZE_960;
        frameSize3 = TuplesKt.to((Object)((Object)SampleRate.SAMPLE_RATE_32K), (Object)SetsKt.setOf((Object[])new FrameSize[]{frameSize3, FrameSize.FRAME_SIZE_640, frameSize5}));
        frameSize4 = TuplesKt.to((Object)((Object)SampleRate.SAMPLE_RATE_48K), (Object)SetsKt.setOf((Object[])new FrameSize[]{frameSize4, frameSize5, FrameSize.FRAME_SIZE_1440}));
        this.supportedParameters = MapsKt.mapOf((Pair[])new Pair[]{pair, frameSize2, frameSize3, frameSize4});
        this.nativeHandle = -1L;
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
        this.mode = mode;
        this.speechDurationMs = n;
        this.silenceDurationMs = n2;
        this.nativeHandle = l = this.nativeInit();
        boolean bl = l != -1L && l != 0L;
        VadWebRTC vadWebRTC = this;
        vadWebRTC.isInitiated = bl;
        vadWebRTC.setSampleRate(sampleRate);
        vadWebRTC.setFrameSize(frameSize);
        vadWebRTC.setMode(mode);
        vadWebRTC.setSilenceDurationMs(n2);
        vadWebRTC.setSpeechDurationMs(n);
    }

    public /* synthetic */ VadWebRTC(SampleRate sampleRate, FrameSize frameSize, Mode mode, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n = 0;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        this(sampleRate, frameSize, mode, n, n2);
    }

    private final boolean isContinuousSpeech(boolean n) {
        if (n) {
            n = this.speechFramesCount;
            int n2 = this.maxSpeechFramesCount;
            if (n <= n2) {
                this.speechFramesCount = n + 1;
            }
            if (this.speechFramesCount > n2) {
                this.silenceFramesCount = 0;
                return true;
            }
        } else {
            n = this.silenceFramesCount;
            int n3 = this.maxSilenceFramesCount;
            if (n <= n3) {
                this.silenceFramesCount = n + 1;
            }
            if (this.silenceFramesCount > n3) {
                this.speechFramesCount = 0;
                return false;
            }
            if (this.speechFramesCount > this.maxSpeechFramesCount) {
                return true;
            }
        }
        return false;
    }

    private final boolean predict(short[] sArray) {
        VadWebRTC vadWebRTC = this;
        vadWebRTC.checkState();
        VadWebRTC vadWebRTC2 = this;
        int n = vadWebRTC2.sampleRate.getValue();
        return vadWebRTC.nativeIsSpeech(vadWebRTC.nativeHandle, n, vadWebRTC2.frameSize.getValue(), sArray);
    }

    private final void checkState() {
        if (this.isInitiated) {
            return;
        }
        throw new IllegalArgumentException("You can't use Vad after closing session!");
    }

    private final native long nativeInit();

    private final native boolean nativeSetMode(long var1, int var3);

    private final native boolean nativeIsSpeech(long var1, int var3, int var4, short[] var5);

    private final native void nativeDestroy(long var1);

    static {
        System.loadLibrary("vad_jni");
    }

    public final Map<SampleRate, Set<FrameSize>> getSupportedParameters() {
        return this.supportedParameters;
    }

    public final boolean isSpeech(short[] sArray) {
        VadWebRTC vadWebRTC = this;
        Intrinsics.checkNotNullParameter((Object)sArray, (String)"audioData");
        return vadWebRTC.isContinuousSpeech(vadWebRTC.predict(sArray));
    }

    public final boolean isSpeech(byte[] byArray) {
        VadWebRTC vadWebRTC = this;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"audioData");
        return vadWebRTC.isContinuousSpeech(vadWebRTC.predict(AudioUtils.INSTANCE.toShortArray(byArray)));
    }

    public final boolean isSpeech(float[] fArray) {
        VadWebRTC vadWebRTC = this;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"audioData");
        return vadWebRTC.isContinuousSpeech(vadWebRTC.predict(AudioUtils.INSTANCE.toShortArray(fArray)));
    }

    public final SampleRate getSampleRate() {
        return this.sampleRate;
    }

    public final void setSampleRate(SampleRate sampleRate) {
        Intrinsics.checkNotNullParameter((Object)((Object)sampleRate), (String)"sampleRate");
        if (((VadWebRTC)((Object)string)).supportedParameters.containsKey((Object)sampleRate)) {
            ((VadWebRTC)((Object)string)).sampleRate = sampleRate;
            return;
        }
        String string = "VAD doesn't support Sample Rate:" + (Object)((Object)sampleRate) + '!';
        throw new IllegalArgumentException(string.toString());
    }

    public final FrameSize getFrameSize() {
        return this.frameSize;
    }

    public final void setFrameSize(FrameSize frameSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)frameSize), (String)"frameSize");
        Set<? extends FrameSize> set = ((VadWebRTC)((Object)string)).supportedParameters.get((Object)((VadWebRTC)((Object)string)).sampleRate);
        if (set != null ? set.contains((Object)frameSize) : false) {
            ((VadWebRTC)((Object)string)).frameSize = frameSize;
            return;
        }
        String string = "VAD doesn't support Sample rate:" + (Object)((Object)((VadWebRTC)((Object)string)).sampleRate) + " and Frame Size:" + (Object)((Object)frameSize) + '!';
        throw new IllegalArgumentException(string.toString());
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(Mode mode) {
        VadWebRTC vadWebRTC = this;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        vadWebRTC.mode = mode;
        vadWebRTC.checkState();
        long l = vadWebRTC.nativeHandle;
        int n = mode.getValue();
        this.nativeSetMode(l, n);
    }

    public final int getSpeechDurationMs() {
        return this.speechDurationMs;
    }

    public final void setSpeechDurationMs(int n) {
        if (n >= 0 && n < 300001) {
            VadWebRTC vadWebRTC = this;
            vadWebRTC.speechDurationMs = n;
            vadWebRTC.maxSpeechFramesCount = AudioUtils.INSTANCE.getFramesCount(this.sampleRate.getValue(), this.frameSize.getValue(), n);
            return;
        }
        throw new IllegalArgumentException("The parameter 'speechDurationMs' should be 0ms >= speechDurationMs <= 300000ms!");
    }

    public final int getSilenceDurationMs() {
        return this.silenceDurationMs;
    }

    public final void setSilenceDurationMs(int n) {
        if (n >= 0 && n < 300001) {
            VadWebRTC vadWebRTC = this;
            vadWebRTC.silenceDurationMs = n;
            vadWebRTC.maxSilenceFramesCount = AudioUtils.INSTANCE.getFramesCount(this.sampleRate.getValue(), this.frameSize.getValue(), n);
            return;
        }
        throw new IllegalArgumentException("The parameter 'silenceDurationMs' should be 0ms >= silenceDurationMs <= 300000ms!");
    }

    @Override
    public void close() {
        VadWebRTC vadWebRTC = this;
        vadWebRTC.checkState();
        vadWebRTC.isInitiated = false;
        vadWebRTC.nativeDestroy(vadWebRTC.nativeHandle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/konovalov/vad/webrtc/VadWebRTC$Companion;", "", "()V", "android-vad-webrtc-v2.0.9_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

