/*
 * Decompiled with CFR 0.152.
 */
package br.com.safeguard.verifies;

import br.com.caelum.stella.validation.InvalidStateException;
import br.com.safeguard.constraint.annotations.Verify;
import br.com.safeguard.exceptions.SafeguardException;
import br.com.safeguard.interfaces.BaseParam;
import br.com.safeguard.params.Param;
import br.com.safeguard.types.ParametroTipo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParamVerify {
    private List<String> validElements;
    private List<String> invalidElements;

    public ParamVerify() {
        this(new ArrayList<String>(), new ArrayList<String>());
    }

    public ParamVerify(List<String> validElements, List<String> invalidElements) {
        this.validElements = validElements;
        this.invalidElements = invalidElements;
    }

    public void validate(Map<Integer, Param> elements) throws SafeguardException {
        if (elements.isEmpty()) {
            throw new SafeguardException("The map can not be empty");
        }
        elements.forEach((Integer2, param) -> this.assertValid(param.getValue(), param.getType()));
    }

    public void validate(List<Object> elements) throws SafeguardException {
        if (elements.isEmpty()) {
            throw new SafeguardException("The list can not be empty");
        }
        elements.forEach(element -> this.validate(element));
    }

    public boolean hasError() {
        return !this.invalidElements.isEmpty();
    }

    public List<String> getInvalidElements() {
        return this.invalidElements;
    }

    public List<String> getValidElements() {
        return this.validElements;
    }

    private void validate(Object object) {
        Class<?> clazz = object.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (!this.isVerifiable(field)) continue;
            this.validate(object, field);
        }
    }

    private void validate(Object object, Field field) {
        try {
            for (ParametroTipo param : field.getAnnotation(Verify.class).value()) {
                String value = String.valueOf(field.get(object));
                this.assertValid(value, param);
            }
        }
        catch (InvalidStateException e) {
            System.err.println(field.getName() + " isn't valid ");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private boolean isVerifiable(Field field) {
        field.setAccessible(true);
        return field.isAccessible() && field.isAnnotationPresent(Verify.class);
    }

    private void assertValid(String value, BaseParam param) {
        try {
            param.getType().assertValid((Object)value);
            this.validElements.add(value);
        }
        catch (InvalidStateException e) {
            this.invalidElements.add(value);
            e.printStackTrace();
        }
    }
}

