/*
 * Decompiled with CFR 0.152.
 */
package br.com.safeguard.validators;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import br.com.safeguard.interfaces.BasePattern;
import br.com.safeguard.messages.ErrorMessage;
import br.com.safeguard.patterns.Patterns;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class PatternValidator
implements Validator<String> {
    private MessageProducer message;
    private BasePattern pattern;

    public PatternValidator() {
        this.pattern = Patterns.DEFAULT;
        this.message = new ErrorMessage();
    }

    public PatternValidator(BasePattern pattern) {
        this.pattern = pattern;
        this.message = new ErrorMessage();
    }

    public PatternValidator(Patterns pattern) {
        this.pattern = pattern;
        this.message = new ErrorMessage();
    }

    private List<ValidationMessage> getInvalidValues(String value) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        if (!Pattern.matches(this.pattern.getPattern(), value)) {
            errors.add(this.message.getMessage((InvalidValue)this.pattern));
        }
        return errors;
    }

    public void assertValid(String value) {
        List<ValidationMessage> errors = this.getInvalidValues(value);
        if (!errors.isEmpty()) {
            throw new InvalidStateException(errors);
        }
    }

    public List<ValidationMessage> invalidMessagesFor(String value) {
        return this.getInvalidValues(value);
    }

    public boolean isEligible(String object) {
        return object != null;
    }
}

