/*
 * Decompiled with CFR 0.152.
 */
package br.com.safeguard.constraint.validators;

import br.com.safeguard.check.SafeguardCheck;
import br.com.safeguard.constraint.annotations.Verify;
import br.com.safeguard.interfaces.Check;
import br.com.safeguard.types.ParametroTipo;
import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class VerifyValidator
implements ConstraintValidator<Verify, String> {
    private Check check;
    private List<ParametroTipo> parametros;

    public void initialize(Verify verify) {
        this.parametros = Arrays.asList(verify.value());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        this.check = new SafeguardCheck();
        this.parametros.forEach(parametro -> this.check.elementOf(value, (ParametroTipo)parametro).validate());
        if (this.check.hasError().booleanValue()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("(" + value + ") cont\u00e9m caracteres inv\u00e1lidos ").addConstraintViolation();
        }
        return this.check.hasError() == false;
    }
}

