/*
 * Decompiled with CFR 0.152.
 */
package com.gigamole.library;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.gigamole.library.R;
import java.util.ArrayList;
import java.util.Random;

@TargetApi(value=11)
public class ArcProgressStackView
extends View {
    private static final float DEFAULT_START_ANGLE = 270.0f;
    private static final float DEFAULT_SWEEP_ANGLE = 360.0f;
    private static final float DEFAULT_DRAW_WIDTH_FRACTION = 0.7f;
    private static final float DEFAULT_MODEL_OFFSET = 5.0f;
    private static final float DEFAULT_SHADOW_RADIUS = 30.0f;
    private static final float DEFAULT_SHADOW_DISTANCE = 15.0f;
    private static final float DEFAULT_SHADOW_ANGLE = 90.0f;
    private static final int DEFAULT_ANIMATION_DURATION = 350;
    private static final int DEFAULT_ACTION_MOVE_ANIMATION_DURATION = 150;
    private static final float MAX_PROGRESS = 100.0f;
    private static final float MIN_PROGRESS = 0.0f;
    private static final float MAX_FRACTION = 1.0f;
    private static final float MIN_FRACTION = 0.0f;
    private static final float MAX_ANGLE = 360.0f;
    private static final float MIN_ANGLE = 0.0f;
    private static final float MIN_SHADOW = 0.0f;
    private static final float POSITIVE_ANGLE = 90.0f;
    private static final float NEGATIVE_ANGLE = 270.0f;
    private static final int POSITIVE_SLICE = 1;
    private static final int NEGATIVE_SLICE = -1;
    private static final int DEFAULT_SLICE = 0;
    private static final int ANIMATE_ALL_INDEX = -2;
    private static final int DISABLE_ANIMATE_INDEX = -1;
    private static final int DEFAULT_SHADOW_COLOR = Color.parseColor((String)"#8C000000");
    private float mStartAngle;
    private float mSweepAngle;
    private ArrayList<Model> mModels;
    private final Paint mProgressPaint;
    private final TextPaint mTextPaint;
    private final ValueAnimator mProgressAnimator;
    private Animator.AnimatorListener mAnimatorListener;
    private Interpolator mInterpolator;
    private int mAnimationDuration;
    private float mAnimatedFraction;
    private int mSize;
    private float mProgressModelSize;
    private float mProgressModelOffset;
    private float mDrawWidthFraction;
    private float mDrawWidthDimension;
    private float mShadowRadius;
    private float mShadowDistance;
    private float mShadowAngle;
    private boolean mIsAnimated;
    private boolean mIsShadowed;
    private boolean mIsRounded;
    private boolean mIsDragged;
    private boolean mIsModelBgEnabled;
    private int mShadowColor;
    private int mTextColor;
    private int mPreviewModelBgColor;
    private int mActionMoveModelIndex;
    private int mActionMoveLastSlice;
    private int mActionMoveSliceCounter;
    private boolean mIsActionMoved;
    private Typeface mTypeface;
    private IndicatorOrientation mIndicatorOrientation;
    private boolean mIsFeaturesAvailable;

    public ArcProgressStackView(Context context) {
        this(context, null);
    }

    public ArcProgressStackView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArcProgressStackView(Context context, AttributeSet attrs, int defStyleAttr) {
        block19: {
            super(context, attrs, defStyleAttr);
            this.mModels = new ArrayList();
            this.mProgressPaint = new Paint(1){
                {
                    this.setDither(true);
                    this.setStyle(Paint.Style.STROKE);
                }
            };
            this.mTextPaint = new TextPaint(1){
                {
                    this.setDither(true);
                    this.setTextAlign(Paint.Align.LEFT);
                }
            };
            this.mProgressAnimator = new ValueAnimator();
            this.mActionMoveModelIndex = -1;
            this.mActionMoveLastSlice = 0;
            this.setWillNotDraw(false);
            this.mIsFeaturesAvailable = Build.VERSION.SDK_INT >= 11;
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ArcProgressStackView);
            try {
                this.setIsAnimated(typedArray.getBoolean(R.styleable.ArcProgressStackView_apsv_animated, true));
                this.setIsShadowed(typedArray.getBoolean(R.styleable.ArcProgressStackView_apsv_shadowed, true));
                this.setIsRounded(typedArray.getBoolean(R.styleable.ArcProgressStackView_apsv_rounded, false));
                this.setIsDragged(typedArray.getBoolean(R.styleable.ArcProgressStackView_apsv_dragged, false));
                this.setTypeface(typedArray.getString(R.styleable.ArcProgressStackView_apsv_typeface));
                this.setTextColor(typedArray.getColor(R.styleable.ArcProgressStackView_apsv_text_color, -1));
                this.setShadowRadius(typedArray.getDimension(R.styleable.ArcProgressStackView_apsv_shadow_radius, 30.0f));
                this.setShadowDistance(typedArray.getDimension(R.styleable.ArcProgressStackView_apsv_shadow_distance, 15.0f));
                this.setShadowAngle(typedArray.getInteger(R.styleable.ArcProgressStackView_apsv_shadow_angle, 90));
                this.setShadowColor(typedArray.getColor(R.styleable.ArcProgressStackView_apsv_shadow_color, DEFAULT_SHADOW_COLOR));
                this.setAnimationDuration(typedArray.getInteger(R.styleable.ArcProgressStackView_apsv_animation_duration, 350));
                this.setStartAngle(typedArray.getInteger(R.styleable.ArcProgressStackView_apsv_start_angle, 270));
                this.setSweepAngle(typedArray.getInteger(R.styleable.ArcProgressStackView_apsv_sweep_angle, 360));
                this.setProgressModelOffset(typedArray.getDimension(R.styleable.ArcProgressStackView_apsv_model_offset, 5.0f));
                this.setModelBgEnabled(typedArray.getBoolean(R.styleable.ArcProgressStackView_apsv_model_bg_enabled, false));
                int orientationOrdinal = typedArray.getInt(R.styleable.ArcProgressStackView_apsv_indicator_orientation, 0);
                this.setIndicatorOrientation(orientationOrdinal == 0 ? IndicatorOrientation.VERTICAL : IndicatorOrientation.HORIZONTAL);
                Interpolator interpolator = null;
                try {
                    int interpolatorId = typedArray.getResourceId(R.styleable.ArcProgressStackView_apsv_interpolator, 0);
                    interpolator = interpolatorId == 0 ? null : AnimationUtils.loadInterpolator((Context)context, (int)interpolatorId);
                    this.setInterpolator(interpolator);
                }
                catch (Resources.NotFoundException exception) {
                    try {
                        interpolator = null;
                        exception.printStackTrace();
                        this.setInterpolator(interpolator);
                    }
                    catch (Throwable throwable) {
                        this.setInterpolator(interpolator);
                        throw throwable;
                    }
                }
                if (this.mIsFeaturesAvailable) {
                    this.mProgressAnimator.setFloatValues(new float[]{0.0f, 1.0f});
                    this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            ArcProgressStackView.this.mAnimatedFraction = ((Float)animation.getAnimatedValue()).floatValue();
                            ArcProgressStackView.this.postInvalidate();
                        }
                    });
                }
                if (typedArray.hasValue(R.styleable.ArcProgressStackView_apsv_draw_width)) {
                    TypedValue drawWidth = new TypedValue();
                    typedArray.getValue(R.styleable.ArcProgressStackView_apsv_draw_width, drawWidth);
                    if (drawWidth.type == 5) {
                        this.setDrawWidthDimension(drawWidth.getDimension(context.getResources().getDisplayMetrics()));
                    } else {
                        this.setDrawWidthFraction(drawWidth.getFraction(1.0f, 1.0f));
                    }
                } else {
                    this.setDrawWidthFraction(0.7f);
                }
                if (!this.isInEditMode()) break block19;
                String[] preview = null;
                try {
                    int previewId = typedArray.getResourceId(R.styleable.ArcProgressStackView_apsv_preview_colors, 0);
                    preview = previewId == 0 ? null : typedArray.getResources().getStringArray(previewId);
                }
                catch (Exception exception) {
                    preview = null;
                    exception.printStackTrace();
                }
                finally {
                    if (preview == null) {
                        preview = typedArray.getResources().getStringArray(R.array.default_preview);
                    }
                    Random random = new Random();
                    for (String previewColor : preview) {
                        this.mModels.add(new Model("", (float)random.nextInt(100), Color.parseColor((String)previewColor)));
                    }
                    this.measure(this.mSize, this.mSize);
                }
                this.mPreviewModelBgColor = typedArray.getColor(R.styleable.ArcProgressStackView_apsv_preview_bg, -3355444);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public long getAnimationDuration() {
        return this.mAnimationDuration;
    }

    @TargetApi(value=11)
    public void setAnimationDuration(long animationDuration) {
        this.mAnimationDuration = (int)animationDuration;
        this.mProgressAnimator.setDuration(animationDuration);
    }

    public Animator.AnimatorListener getAnimatorListener() {
        return this.mAnimatorListener;
    }

    public void setAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.mAnimatorListener = animatorListener;
        this.mProgressAnimator.addListener(this.mAnimatorListener);
    }

    public float getStartAngle() {
        return this.mStartAngle;
    }

    @FloatRange
    public void setStartAngle(@FloatRange(from=0.0, to=360.0) float startAngle) {
        this.mStartAngle = Math.max(0.0f, Math.min(startAngle, 360.0f));
        this.postInvalidate();
    }

    public float getSweepAngle() {
        return this.mSweepAngle;
    }

    @FloatRange
    public void setSweepAngle(@FloatRange(from=0.0, to=360.0) float sweepAngle) {
        this.mSweepAngle = Math.max(0.0f, Math.min(sweepAngle, 360.0f));
        this.postInvalidate();
    }

    public ArrayList<Model> getModels() {
        return this.mModels;
    }

    public void setModels(ArrayList<Model> models) {
        this.mModels.clear();
        this.mModels = models;
        this.requestLayout();
    }

    public int getSize() {
        return this.mSize;
    }

    public float getProgressModelSize() {
        return this.mProgressModelSize;
    }

    public boolean isAnimated() {
        return this.mIsAnimated;
    }

    @TargetApi(value=11)
    public void setIsAnimated(boolean isAnimated) {
        this.mIsAnimated = this.mIsFeaturesAvailable && isAnimated;
    }

    public boolean isShadowed() {
        return this.mIsShadowed;
    }

    @TargetApi(value=11)
    public void setIsShadowed(boolean isShadowed) {
        this.mIsShadowed = this.mIsFeaturesAvailable && isShadowed;
        this.resetShadowLayer();
        this.requestLayout();
    }

    public boolean isModelBgEnabled() {
        return this.mIsModelBgEnabled;
    }

    public void setModelBgEnabled(boolean modelBgEnabled) {
        this.mIsModelBgEnabled = modelBgEnabled;
        this.postInvalidate();
    }

    public boolean isRounded() {
        return this.mIsRounded;
    }

    public void setIsRounded(boolean isRounded) {
        this.mIsRounded = isRounded;
        if (this.mIsRounded) {
            this.mProgressPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mProgressPaint.setStrokeJoin(Paint.Join.ROUND);
        } else {
            this.mProgressPaint.setStrokeCap(Paint.Cap.BUTT);
            this.mProgressPaint.setStrokeJoin(Paint.Join.MITER);
        }
        this.requestLayout();
    }

    public boolean isDragged() {
        return this.mIsDragged;
    }

    public void setIsDragged(boolean isDragged) {
        this.mIsDragged = isDragged;
    }

    public Interpolator getInterpolator() {
        return (Interpolator)this.mProgressAnimator.getInterpolator();
    }

    @TargetApi(value=11)
    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator == null ? new AccelerateDecelerateInterpolator() : interpolator;
        this.mProgressAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
    }

    public float getProgressModelOffset() {
        return this.mProgressModelOffset;
    }

    public void setProgressModelOffset(float progressModelOffset) {
        this.mProgressModelOffset = progressModelOffset;
        this.requestLayout();
    }

    public float getDrawWidthFraction() {
        return this.mDrawWidthFraction;
    }

    @FloatRange
    public void setDrawWidthFraction(@FloatRange(from=0.0, to=1.0) float drawWidthFraction) {
        this.mDrawWidthFraction = Math.max(0.0f, Math.min(drawWidthFraction, 1.0f)) * 0.5f;
        this.mDrawWidthDimension = 0.0f;
        this.requestLayout();
    }

    public float getDrawWidthDimension() {
        return this.mDrawWidthDimension;
    }

    public void setDrawWidthDimension(float drawWidthDimension) {
        this.mDrawWidthFraction = 0.0f;
        this.mDrawWidthDimension = drawWidthDimension;
        this.requestLayout();
    }

    public float getShadowDistance() {
        return this.mShadowDistance;
    }

    public void setShadowDistance(float shadowDistance) {
        this.mShadowDistance = shadowDistance;
        this.resetShadowLayer();
        this.requestLayout();
    }

    public float getShadowAngle() {
        return this.mShadowAngle;
    }

    @FloatRange
    public void setShadowAngle(@FloatRange(from=0.0, to=360.0) float shadowAngle) {
        this.mShadowAngle = Math.max(0.0f, Math.min(shadowAngle, 360.0f));
        this.resetShadowLayer();
        this.requestLayout();
    }

    public float getShadowRadius() {
        return this.mShadowRadius;
    }

    public void setShadowRadius(float shadowRadius) {
        this.mShadowRadius = shadowRadius > 0.0f ? shadowRadius : 0.0f;
        this.resetShadowLayer();
        this.requestLayout();
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.resetShadowLayer();
        this.postInvalidate();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.mTextPaint.setColor(textColor);
        this.postInvalidate();
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(String typeface) {
        Typeface tempTypeface;
        try {
            if (this.isInEditMode()) {
                return;
            }
            tempTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typeface);
        }
        catch (Exception e) {
            tempTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
            e.printStackTrace();
        }
        this.setTypeface(tempTypeface);
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        this.mTextPaint.setTypeface(typeface);
        this.postInvalidate();
    }

    public IndicatorOrientation getIndicatorOrientation() {
        return this.mIndicatorOrientation;
    }

    public void setIndicatorOrientation(IndicatorOrientation indicatorOrientation) {
        this.mIndicatorOrientation = indicatorOrientation;
    }

    private void resetShadowLayer() {
        if (this.isInEditMode()) {
            return;
        }
        float newDx = (float)((double)this.mShadowDistance * Math.cos((double)((this.mShadowAngle - this.mStartAngle) / 180.0f) * Math.PI));
        float newDy = (float)((double)this.mShadowDistance * Math.sin((double)((this.mShadowAngle - this.mStartAngle) / 180.0f) * Math.PI));
        if (this.mIsShadowed) {
            this.mProgressPaint.setShadowLayer(this.mShadowRadius, newDx, newDy, this.mShadowColor);
        } else {
            this.mProgressPaint.clearShadowLayer();
        }
        this.setLayerType(this.mIsShadowed ? 1 : 2, this.mIsShadowed ? this.mProgressPaint : null);
        this.postInvalidate();
    }

    private void setStartGradientRoundedShadowLayer() {
        if (this.isInEditMode()) {
            return;
        }
        if (this.mIsShadowed) {
            float shadowOffset = this.mShadowRadius * 0.5f;
            this.mProgressPaint.setShadowLayer(shadowOffset, 0.0f, -shadowOffset, this.adjustColorAlpha(this.mShadowColor, 0.5f));
        } else {
            this.mProgressPaint.clearShadowLayer();
        }
        this.setLayerType(this.mIsShadowed ? 1 : 2, this.mIsShadowed ? this.mProgressPaint : null);
        this.postInvalidate();
    }

    private int adjustColorAlpha(int color, float factor) {
        return Color.argb((int)Math.round((float)Color.alpha((int)color) * factor), (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    public void animateProgress() {
        if (!this.mIsAnimated || this.mProgressAnimator == null) {
            return;
        }
        this.mActionMoveModelIndex = -2;
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
        this.mProgressAnimator.setDuration((long)this.mAnimationDuration);
        this.mProgressAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
        this.mProgressAnimator.removeListener(this.mAnimatorListener);
        this.mProgressAnimator.addListener(this.mAnimatorListener);
        this.mProgressAnimator.start();
    }

    private void animateActionMoveProgress() {
        if (!this.mIsAnimated || this.mProgressAnimator == null) {
            return;
        }
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
        this.mProgressAnimator.setDuration(150L);
        this.mProgressAnimator.setInterpolator(null);
        this.mProgressAnimator.removeListener(this.mAnimatorListener);
        this.mProgressAnimator.start();
    }

    private float getActionMoveAngle(float x, float y) {
        float radius = (float)this.mSize * 0.5f;
        float degrees = (float)((Math.toDegrees(Math.atan2(y - radius, x - radius)) + 360.0) % 360.0);
        if (degrees < 0.0f) {
            degrees = (float)((double)degrees + Math.PI * 2);
        }
        float newActionMoveX = (float)((double)radius * Math.cos((double)((degrees - this.mStartAngle) / 180.0f) * Math.PI));
        float newActionMoveY = (float)((double)radius * Math.sin((double)((degrees - this.mStartAngle) / 180.0f) * Math.PI));
        if ((degrees = (float)((Math.toDegrees(Math.atan2(newActionMoveY, newActionMoveX)) + 360.0) % 360.0)) < 0.0f) {
            degrees = (float)((double)degrees + Math.PI * 2);
        }
        return degrees;
    }

    private void handleActionMoveModel(MotionEvent event) {
        if (this.mActionMoveModelIndex == -1) {
            return;
        }
        float currentAngle = this.getActionMoveAngle(event.getX(), event.getY());
        int actionMoveCurrentSlice = currentAngle > 0.0f && currentAngle < 90.0f ? 1 : (currentAngle > 270.0f && currentAngle < 360.0f ? -1 : 0);
        if (actionMoveCurrentSlice != 0 && (this.mActionMoveLastSlice == -1 && actionMoveCurrentSlice == 1 || actionMoveCurrentSlice == -1 && this.mActionMoveLastSlice == 1)) {
            this.mActionMoveSliceCounter = this.mActionMoveLastSlice == -1 ? ++this.mActionMoveSliceCounter : --this.mActionMoveSliceCounter;
            if (this.mActionMoveSliceCounter > 1) {
                this.mActionMoveSliceCounter = 1;
            } else if (this.mActionMoveSliceCounter < -1) {
                this.mActionMoveSliceCounter = -1;
            }
        }
        this.mActionMoveLastSlice = actionMoveCurrentSlice;
        float actionMoveTotalAngle = currentAngle + 360.0f * (float)this.mActionMoveSliceCounter;
        Model model = this.mModels.get(this.mActionMoveModelIndex);
        if (actionMoveTotalAngle < 0.0f || actionMoveTotalAngle > 360.0f) {
            currentAngle = actionMoveTotalAngle = actionMoveTotalAngle > 360.0f ? 361.0f : -1.0f;
        }
        float touchProgress = Math.round(100.0f / this.mSweepAngle * currentAngle);
        model.setProgress(touchProgress);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsDragged) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.mActionMoveModelIndex = -1;
                float currentAngle = this.getActionMoveAngle(event.getX(), event.getY());
                if (currentAngle > this.mSweepAngle && currentAngle < 360.0f) break;
                for (int i = 0; i < this.mModels.size(); ++i) {
                    Model model = this.mModels.get(i);
                    if (!model.mBounds.contains(event.getX(), event.getY())) continue;
                    float modelRadius = model.mBounds.width() * 0.5f;
                    float modelOffset = this.mProgressModelSize * 0.5f;
                    float mainRadius = (float)this.mSize * 0.5f;
                    float distance = (float)Math.sqrt(Math.pow(event.getX() - mainRadius, 2.0) + Math.pow(event.getY() - mainRadius, 2.0));
                    if (!(distance > modelRadius - modelOffset) || !(distance < modelRadius + modelOffset)) continue;
                    this.mActionMoveModelIndex = i;
                    this.mIsActionMoved = true;
                    this.handleActionMoveModel(event);
                    this.animateActionMoveProgress();
                }
                break;
            }
            case 2: {
                if (this.mActionMoveModelIndex == -1 && !this.mIsActionMoved || this.mProgressAnimator.isRunning()) break;
                this.handleActionMoveModel(event);
                this.postInvalidate();
                break;
            }
            default: {
                this.mActionMoveLastSlice = 0;
                this.mActionMoveSliceCounter = 0;
                this.mIsActionMoved = false;
            }
        }
        if (event.getAction() == 2 && this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.mSize = width > (height = View.MeasureSpec.getSize((int)heightMeasureSpec)) ? height : width;
        float divider = this.mDrawWidthFraction == 0.0f ? this.mDrawWidthDimension : (float)this.mSize * this.mDrawWidthFraction;
        this.mProgressModelSize = divider / (float)this.mModels.size();
        float paintOffset = this.mProgressModelSize * 0.5f;
        float shadowOffset = this.mIsShadowed ? this.mShadowRadius + this.mShadowDistance : 0.0f;
        for (int i = 0; i < this.mModels.size(); ++i) {
            Model model = this.mModels.get(i);
            float modelOffset = this.mProgressModelSize * (float)i + (paintOffset + shadowOffset) - this.mProgressModelOffset * (float)i;
            model.mBounds.set(modelOffset, modelOffset, (float)this.mSize - modelOffset, (float)this.mSize - modelOffset);
            if (model.getColors() == null) continue;
            model.mSweepGradient = new SweepGradient(model.mBounds.centerX(), model.mBounds.centerY(), model.getColors(), null);
        }
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        float radius = (float)this.mSize * 0.5f;
        canvas.rotate(this.mStartAngle, radius, radius);
        for (int i = 0; i < this.mModels.size(); ++i) {
            float progressFraction;
            Model model = this.mModels.get(i);
            float f = progressFraction = this.mIsAnimated && !this.isInEditMode() ? (model.mLastProgress + this.mAnimatedFraction * (model.getProgress() - model.mLastProgress)) / 100.0f : model.getProgress() / 100.0f;
            if (i != this.mActionMoveModelIndex && this.mActionMoveModelIndex != -2) {
                progressFraction = model.getProgress() / 100.0f;
            }
            float progress = progressFraction * this.mSweepAngle;
            boolean isGradient = model.getColors() != null;
            this.mProgressPaint.setStrokeWidth(this.mProgressModelSize);
            model.mPath.reset();
            model.mPath.addArc(model.mBounds, 0.0f, progress);
            this.resetShadowLayer();
            this.mProgressPaint.setShader(null);
            this.mProgressPaint.setStyle(Paint.Style.STROKE);
            if (this.mIsModelBgEnabled) {
                this.mProgressPaint.setColor(this.isInEditMode() ? this.mPreviewModelBgColor : model.getBgColor());
                canvas.drawArc(model.mBounds, 0.0f, this.mSweepAngle, false, this.mProgressPaint);
                if (!this.isInEditMode()) {
                    this.mProgressPaint.clearShadowLayer();
                }
            }
            if (isGradient) {
                if (!this.mIsModelBgEnabled) {
                    canvas.drawPath(model.mPath, this.mProgressPaint);
                    if (!this.isInEditMode()) {
                        this.mProgressPaint.clearShadowLayer();
                    }
                }
                this.mProgressPaint.setShader((Shader)model.mSweepGradient);
            } else {
                this.mProgressPaint.setColor(model.getColor());
            }
            this.mProgressPaint.setAlpha(255);
            canvas.drawPath(model.mPath, this.mProgressPaint);
            if (this.isInEditMode()) continue;
            this.mTextPaint.setTextSize(this.mProgressModelSize * 0.5f);
            this.mTextPaint.getTextBounds(model.getTitle(), 0, model.getTitle().length(), model.mTextBounds);
            float titleHorizontalOffset = (float)model.mTextBounds.height() * 0.5f;
            float progressLength = (float)Math.PI / 180 * progress * model.mBounds.width() * 0.5f;
            String title = (String)TextUtils.ellipsize((CharSequence)model.getTitle(), (TextPaint)this.mTextPaint, (float)(progressLength - titleHorizontalOffset * 2.0f), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            canvas.drawTextOnPath(title, model.mPath, this.mIsRounded ? 0.0f : titleHorizontalOffset, titleHorizontalOffset, (Paint)this.mTextPaint);
            model.mPathMeasure.setPath(model.mPath, false);
            model.mPathMeasure.getPosTan(model.mPathMeasure.getLength(), model.mPos, model.mTan);
            float titleWidth = model.mTextBounds.width();
            String percentProgress = String.format("%d%%", (int)model.getProgress());
            this.mTextPaint.setTextSize(this.mProgressModelSize * 0.35f);
            this.mTextPaint.getTextBounds(percentProgress, 0, percentProgress.length(), model.mTextBounds);
            float progressHorizontalOffset = this.mIndicatorOrientation == IndicatorOrientation.VERTICAL ? (float)model.mTextBounds.height() * 0.5f : (float)model.mTextBounds.width() * 0.5f;
            float indicatorProgressOffset = (this.mIsRounded ? progressFraction : 1.0f) * (-progressHorizontalOffset - titleHorizontalOffset - (this.mIsRounded ? (float)model.mTextBounds.height() * 2.0f : 0.0f));
            model.mPathMeasure.getPosTan(model.mPathMeasure.getLength() + indicatorProgressOffset, model.mPos, this.mIndicatorOrientation == IndicatorOrientation.VERTICAL && !this.mIsRounded ? new float[2] : model.mTan);
            if (titleWidth + (float)model.mTextBounds.height() + titleHorizontalOffset * 2.0f - indicatorProgressOffset < progressLength) {
                float y;
                float x;
                float indicatorProgressAngle = (float)(Math.atan2(model.mTan[1], model.mTan[0]) * 57.29577951308232);
                float indicatorLengthProgressAngle = (progressLength + indicatorProgressOffset) / (model.mBounds.width() * 0.5f) * 57.29578f;
                indicatorProgressAngle = this.mIndicatorOrientation == IndicatorOrientation.VERTICAL ? (indicatorProgressAngle += (x = (float)((double)(model.mBounds.width() * 0.5f) * Math.cos((double)(indicatorLengthProgressAngle + this.mStartAngle) * Math.PI / 180.0)) + model.mBounds.centerX()) > radius ? -90.0f : 90.0f) : (indicatorProgressAngle += (y = (float)((double)(model.mBounds.height() * 0.5f) * Math.sin((double)(indicatorLengthProgressAngle + this.mStartAngle) * Math.PI / 180.0)) + model.mBounds.centerY()) > radius ? 180.0f : 0.0f);
                canvas.save();
                canvas.rotate(indicatorProgressAngle, model.mPos[0], model.mPos[1]);
                canvas.drawText(percentProgress, model.mPos[0] - model.mTextBounds.exactCenterX(), model.mPos[1] - model.mTextBounds.exactCenterY(), (Paint)this.mTextPaint);
                canvas.restore();
            }
            if (!isGradient || !this.mIsRounded || progress == 0.0f) continue;
            model.mPathMeasure.getPosTan(0.0f, model.mPos, model.mTan);
            this.setStartGradientRoundedShadowLayer();
            this.mProgressPaint.setShader(null);
            this.mProgressPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mProgressPaint.setStrokeWidth(0.0f);
            this.mProgressPaint.setColor(model.getColors()[0]);
            float halfSize = this.mProgressModelSize * 0.5f;
            RectF arcRect = new RectF(model.mPos[0] - halfSize, model.mPos[1] - halfSize, model.mPos[0] + halfSize, model.mPos[1] + halfSize);
            canvas.drawArc(arcRect, 0.0f, -180.0f, true, this.mProgressPaint);
        }
        canvas.restore();
    }

    public static enum IndicatorOrientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static class Model {
        private String mTitle;
        private float mLastProgress;
        private float mProgress;
        private int mColor;
        private int mBgColor;
        private int[] mColors;
        private RectF mBounds = new RectF();
        private Rect mTextBounds = new Rect();
        private Path mPath = new Path();
        private SweepGradient mSweepGradient;
        private PathMeasure mPathMeasure = new PathMeasure();
        private final float[] mPos = new float[2];
        private final float[] mTan = new float[2];

        public Model(String title, float progress, int color) {
            this.setTitle(title);
            this.setProgress(progress);
            this.setColor(color);
        }

        public Model(String title, float progress, int[] colors) {
            this.setTitle(title);
            this.setProgress(progress);
            this.setColors(colors);
        }

        public Model(String title, float progress, int bgColor, int color) {
            this.setTitle(title);
            this.setProgress(progress);
            this.setColor(color);
            this.setBgColor(bgColor);
        }

        public Model(String title, float progress, int bgColor, int[] colors) {
            this.setTitle(title);
            this.setProgress(progress);
            this.setColors(colors);
            this.setBgColor(bgColor);
        }

        public String getTitle() {
            return this.mTitle;
        }

        public void setTitle(String title) {
            this.mTitle = title;
        }

        public float getProgress() {
            return this.mProgress;
        }

        @FloatRange
        public void setProgress(@FloatRange(from=0.0, to=100.0) float progress) {
            this.mLastProgress = this.mProgress;
            this.mProgress = (int)Math.max(0.0f, Math.min(progress, 100.0f));
        }

        public int getColor() {
            return this.mColor;
        }

        public void setColor(int color) {
            this.mColor = color;
        }

        public int getBgColor() {
            return this.mBgColor;
        }

        public void setBgColor(int bgColor) {
            this.mBgColor = bgColor;
        }

        public int[] getColors() {
            return this.mColors;
        }

        public void setColors(int[] colors) {
            this.mColors = (int[])(colors != null && colors.length >= 2 ? colors : null);
        }
    }
}

