package caliban

import sttp.client3.SttpBackend
import zio.Task

package object tools {

  type SttpClient = SttpBackend[Task, Any]

  val supportedScalars = Set("Int", "Float", "Double", "Long", "Unit", "String", "Boolean", "BigInt", "BigDecimal")

  val reservedKeywords = Set(
    "abstract",
    "as",
    "case",
    "catch",
    "class",
    "def",
    "derives",
    "do",
    "else",
    "enum",
    "export",
    "extends",
    "extension",
    "false",
    "final",
    "finally",
    "for",
    "forSome",
    "given",
    "if",
    "implicit",
    "import",
    "infix",
    "inline",
    "lazy",
    "match",
    "new",
    "null",
    "object",
    "opaque",
    "open",
    "override",
    "package",
    "private",
    "protected",
    "return",
    "sealed",
    "super",
    "then",
    "this",
    "throw",
    "trait",
    "transparent",
    "try",
    "true",
    "type",
    "using",
    "val",
    "var",
    "while",
    "with",
    "yield",
    "_"
  )

  val caseClassReservedFields =
    Set("wait", "notify", "toString", "notifyAll", "hashCode", "getClass", "finalize", "equals", "clone")

  val tripleQuotes = "\"\"\""
  val doubleQuotes = "\""

  def safeName(name: String): String =
    if (name == "_") "_$" // scala 3 does not allow a name of `_`
    else if (reservedKeywords.contains(name) || name.endsWith("_")) s"`$name`"
    else if (caseClassReservedFields.contains(name)) s"$name$$"
    else name
}
